﻿using VT.FW.DB;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 插件表实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_PlugIn
    {
        /// <summary>
        /// 主键Id
        /// </summary>        
        public int PlugId
        {
            get;
            set;
        }

        /// <summary>
        /// 插件类型(1-基础组件，2-营销组件，3-其他组件，4-表单组件)
        /// </summary>        
        public int PlugType
        {
            get;
            set;
        }

        /// <summary>
        /// 插件Key
        /// </summary>        
        public string Id
        {
            get;
            set;
        }

        /// <summary>
        /// 插件名称
        /// </summary>        
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// 图标
        /// </summary>        
        public string Icon
        {
            get;
            set;
        }

        /// <summary>
        /// 状态
        /// </summary>        
        public int Status
        {
            get;
            set;
        }
    }
}
