﻿using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.User
{
    /// <summary>
    /// 管理提醒日志仓储层
    /// </summary>
    public class RB_Message_NoticeRepository : BaseRepository<RB_Message_Notice>
    {
        /// <summary>
        /// 获取分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Message_Notice_Extend> GetPageList(int pageIndex, int pageSize, out long rowsCount, RB_Message_Notice_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.* 
FROM RB_Message_Notice AS A
WHERE 1=1
");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(@" AND A.{0}={1} ", nameof(RB_Message_Notice_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(@" AND A.{0}={1} ", nameof(RB_Message_Notice_Extend.MallBaseId), query.MallBaseId);
                }
                if (query.Type > 0)
                {
                    builder.AppendFormat(@" AND A.{0}={1} ", nameof(RB_Message_Notice_Extend.Type), query.Type);
                }
                if (query.IsLook > 0)
                {
                    builder.AppendFormat(@" AND A.{0}={1} ", nameof(RB_Message_Notice_Extend.IsLook), query.IsLook);
                }
                if (!string.IsNullOrEmpty(query.StartTime))
                {
                    builder.AppendFormat(@" AND A.{0} >='{1}' ", nameof(RB_Message_Notice_Extend.CreateDate), query.StartTime);
                }
                if (!string.IsNullOrEmpty(query.EndTime))
                {
                    builder.AppendFormat(@" AND A.{0} <='{1} 23:59:59' ", nameof(RB_Message_Notice_Extend.CreateDate), query.EndTime);
                }
            }
            builder.AppendFormat(" order by Id desc");
            return GetPage<RB_Message_Notice_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString()).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Message_Notice_Extend> GetList(RB_Message_Notice_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.* 
FROM RB_Message_Notice AS A
WHERE 1=1
");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(@" AND A.{0}={1} ", nameof(RB_Message_Notice_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(@" AND A.{0}={1} ", nameof(RB_Message_Notice_Extend.MallBaseId), query.MallBaseId);
                }
                if (query.Type > 0)
                {
                    builder.AppendFormat(@" AND A.{0}={1} ", nameof(RB_Message_Notice_Extend.Type), query.Type);
                }
                if (query.IsLook > 0)
                {
                    builder.AppendFormat(@" AND A.{0}={1} ", nameof(RB_Message_Notice_Extend.IsLook), query.IsLook);
                }
                if (!string.IsNullOrEmpty(query.StartTime))
                {
                    builder.AppendFormat(@" AND A.{0} >='{1}' ", nameof(RB_Message_Notice_Extend.CreateDate), query.StartTime);
                }
                if (!string.IsNullOrEmpty(query.EndTime))
                {
                    builder.AppendFormat(@" AND A.{0} <='{1} 23:59:59' ", nameof(RB_Message_Notice_Extend.CreateDate), query.EndTime);
                }
            }
            return Get<RB_Message_Notice_Extend>(builder.ToString()).ToList();
        }

        /// <summary>
        /// 获取未查看的各类型消息数量
        /// </summary>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public List<RB_Message_Notice_Extend> GetAdminMessageNoticeNum(int tenantId, int mallBaseId)
        {
            string sql = $@"SELECT Type,COUNT(0) as IsLook FROM rb_message_notice where TenantId ={tenantId} and MallBaseId ={mallBaseId} and IsLook =2 GROUP BY Type";
            return Get<RB_Message_Notice_Extend>(sql).ToList();
        }
    }
}
