﻿using Mall.Model.Entity.Customer;
using Mall.Model.Extend.Customer;
using Mall.Model.Extend.User;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.Repository.Customer
{
    /// <summary>
    /// 客人积分明细仓储类
    /// </summary>
    public class RB_Customer_IntegralRepository : BaseRepository<RB_Customer_Integral>
    {
        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Customer_Integral_Extend> GetList(RB_Customer_Integral_Extend demodel)
        {
            string where = " 1=1 ";
            if (demodel.GroupId > 0)
            {
                where += $@" and {nameof(RB_Customer_Integral_Extend.GroupId)} ={demodel.GroupId}";
            }
            if (demodel.OrderId > 0)
            {
                where += $@" and {nameof(RB_Customer_Integral_Extend.OrderId)} ={demodel.OrderId}";
            }
            if (demodel.OrderType > 0)
            {
                where += $@" and {nameof(RB_Customer_Integral_Extend.OrderType)} ={demodel.OrderType}";
            }
            if (demodel.CustomerId > 0)
            {
                where += $@" and {nameof(RB_Customer_Integral_Extend.CustomerId)} ={demodel.CustomerId}";
            }
            if (demodel.CustomerType > 0)
            {
                where += $@" and {nameof(RB_Customer_Integral_Extend.CustomerType)} ={demodel.CustomerType}";
            }
            if (demodel.TCID > 0)
            {
                where += $@" and {nameof(RB_Customer_Integral_Extend.TCID)} ={demodel.TCID}";
            }

            string sql = $@"select * from RB_Customer_Integral where {where} order by Id desc";
            return Get<RB_Customer_Integral_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Customer_Integral_Extend> GetPageList(int pageIndex, int pageSize, out long count, RB_Customer_Integral_Extend demodel)
        {
            string where = " 1=1 ";
            if (demodel.GroupId > 0)
            {
                where += $@" and {nameof(RB_Customer_Integral_Extend.GroupId)} ={demodel.GroupId}";
            }
            if (demodel.OrderId > 0)
            {
                where += $@" and {nameof(RB_Customer_Integral_Extend.OrderId)} ={demodel.OrderId}";
            }
            if (demodel.OrderType > 0)
            {
                where += $@" and {nameof(RB_Customer_Integral_Extend.OrderType)} ={demodel.OrderType}";
            }
            if (demodel.CustomerId > 0)
            {
                where += $@" and {nameof(RB_Customer_Integral_Extend.CustomerId)} ={demodel.CustomerId}";
            }
            if (demodel.CustomerChildrenId > 0)
            {
                where += $@" and {nameof(RB_Customer_Integral_Extend.CustomerChildrenId)} ={demodel.CustomerChildrenId}";
            }
            if (demodel.Type == 1)
            {
                where += $@" and {nameof(RB_Customer_Integral_Extend.IntegralNum)} >0";
            }
            else if (demodel.Type == 2)
            {
                where += $@" and {nameof(RB_Customer_Integral_Extend.IntegralNum)} <=0";
            }

            string sql = $@"select * from RB_Customer_Integral where {where} order by Id desc";
            return GetPage<RB_Customer_Integral_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }

        /// <summary>
        /// 获取积分余额
        /// </summary>
        /// <param name="customerId"></param>
        /// <param name="customerChildrenId"></param>
        /// <returns></returns>
        public decimal GetCustomerIntegralSurplus(int customerId, int customerChildrenId) {
            string sql = $@"SELECT SUM(IntegralNum) FROM rb_customer_integral i WHERE CustomerId ={customerId} {(customerChildrenId > 0 ? "and CustomerChildrenId=" + customerChildrenId : "")}";
            var obj = ExecuteScalar(sql);
            return obj == null ? 0 : Convert.ToDecimal(obj);
        }

        /// <summary>
        /// 获取同业客户ID 通过 OpenId
        /// </summary>
        /// <param name="OpenId"></param>
        /// <returns></returns>
        public RB_Customer_Integral_Extend GetCustomerToOpenId(string OpenId) {
            string sql = $@" SELECT InfoID CustomerId,ID as CustomerChildrenId FROM rb_customer_infochildren WHERE OpenId ='{OpenId}'";
            return Get<RB_Customer_Integral_Extend>(sql).FirstOrDefault();
        }
        /// <summary>
        /// 获取同业客户ID 通过联系人ID
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public RB_Customer_Integral_Extend GetCustomerToChildId(int Id)
        {
            string sql = $@" SELECT InfoID CustomerId,ID as CustomerChildrenId FROM rb_customer_infochildren WHERE ID ={Id}";
            return Get<RB_Customer_Integral_Extend>(sql).FirstOrDefault();
        }

        /// <summary>
        /// 获取同行员工信息
        /// </summary>
        /// <param name="CustomerChildrenId"></param>
        /// <returns></returns>
        public RB_Customer_Integral_Extend GetCustomerInfo(int CustomerChildrenId) {
            string sql = $@" select InfoID as CustomerId,ID as CustomerChildrenId,IntegralUse from rb_customer_infochildren where ID ={CustomerChildrenId}";
            return Get<RB_Customer_Integral_Extend>(sql).FirstOrDefault();
        }

        /// <summary>
        /// 更新erp同业积分余额
        /// </summary>
        /// <param name="customerId"></param>
        /// <param name="totalIntegralNumber"></param>
        public void UpdateCustomerIntegral(int customerId, int totalIntegralNumber)
        {
            string sql = $@"update rb_customer_info set Integral=Integral-{totalIntegralNumber} where CustomerId={customerId}";
            Execute(sql);
        }

        /// <summary>
        /// 获取联系人信息
        /// </summary>
        /// <param name="customerChildrenIds"></param>
        /// <returns></returns>
        public List<RB_Customer_Integral_Extend> GetCustomerInfoList(string customerChildrenIds) {
            string sql = $@"SELECT c.ID as CustomerChildrenId,i.CustomerId,c.ContactName,i.CustomerName FROM rb_customer_infochildren c
left join rb_customer_info i on c.InfoID =i.CustomerId
WHERE c.ID in({customerChildrenIds})";
            return Get<RB_Customer_Integral_Extend>(sql).ToList();
        }
    }
}
