﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.Common
{
    /// <summary>
    /// web端登录用户信息缓存
    /// </summary>
    public class UserInfo
    {
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }

        /// <summary>
        /// 账号
        /// </summary>        
        public string Account
        {
            get;
            set;
        }

        
        /// <summary>
        /// 姓名/企业名称
        /// </summary>        
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// 手机号码
        /// </summary>        
        public string MobilePhone
        {
            get;
            set;
        }

        /// <summary>
        /// 微信号
        /// </summary>        
        public string WeChatNum
        {
            get;
            set;
        }


        /// <summary>
        /// 是否永久有效(0-默认，1-永久有效)
        /// </summary>        
        public int? IsEffective
        {
            get;
            set;
        }

        /// <summary>
        /// 账号有效期
        /// </summary>        
        public DateTime? AccountValidate
        {
            get;
            set;
        }

        /// <summary>
        /// 可创建小程序数量
        /// </summary>        
        public int? CreateMiniPrograme
        {
            get;
            set;
        }

        /// <summary>
        /// 商城名称
        /// </summary>        
        public string MallName
        {
            get;
            set;
        }

        /// <summary>
        /// 账号状态(0-默认，1-提交申请，2-审核通过，3-审核拒绝）
        /// </summary>        
        public int? AccountStatus
        {
            get;
            set;
        }

        /// <summary>
        /// token
        /// </summary>
        public string Token { get; set; }  
    }
}
