﻿using Mall.Common.AOP;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 商户用户表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Member_User
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 用户名称
        /// </summary>        
        public string Name
        {
            get;
            set;
        }
        /// <summary>
        /// 别名
        /// </summary>        
        public string AliasName
        {
            get;
            set;
        }
        /// <summary>
        /// 头像
        /// </summary>        
        public string Photo
        {
            get;
            set;
        }
        /// <summary>
        /// 来源  1微信  2支付宝
        /// </summary>        
        public UserSourceEnum? Source
        {
            get;
            set;
        }
        /// <summary>
        /// 唯一识别码
        /// </summary>        
        public string OpenId
        {
            get;
            set;
        }
        /// <summary>
        /// 手机号码
        /// </summary>        
        public string Moblie
        {
            get;
            set;
        }
        /// <summary>
        /// 会员等级  0 普通 根据会员等级表
        /// </summary>        
        public int? MemberGrade
        {
            get;
            set;
        }
        /// <summary>
        /// 订单数量
        /// </summary>        
        public int? OrderNum
        {
            get;
            set;
        }
        /// <summary>
        /// 优惠卷数量
        /// </summary>        
        public int? CouponsNum
        {
            get;
            set;
        }
        /// <summary>
        /// 卡卷数量
        /// </summary>        
        public int? CardVolumeNum
        {
            get;
            set;
        }
        /// <summary>
        /// 余额
        /// </summary>        
        public decimal? Balance
        {
            get;
            set;
        }
        /// <summary>
        /// 积分
        /// </summary>        
        public decimal? Integral
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// 上级 0表示总部
        /// </summary>        
        public int? SuperiorId
        {
            get;
            set;
        }
        /// <summary>
        /// 黑名单  1是 0否
        /// </summary>        
        public int? Blacklist
        {
            get;
            set;
        }
        /// <summary>
        /// 联系方式
        /// </summary>        
        public string ContactWay
        {
            get;
            set;
        }
        /// <summary>
        /// 备注
        /// </summary>        
        public string Remark
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号id
        /// </summary>        
        public int? TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 修改时间
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }
    }
}
