﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Model.Entity.BaseSetUp;
using Mall.Module.BaseSetUp;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;

namespace Mall.WebApi.Controllers.MallBase
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class MallBaseController : BaseController
    {

        private MallBaseModule mallBaseModule = new MallBaseModule();
        public ApiResult AddOrUpdate()
        {
            var query = JsonConvert.DeserializeObject<RB_MallBase>(RequestParm.msg.ToString());

            if (query == null)
            {
                return ApiResult.Failed("请传入需要操作的小程序");
            }
            else
            {

                if (query.ID == 0)//新增
                {

                }
                bool result = mallBaseModule.AddOrUpdate(query);
                if (result)
                {
                    return ApiResult.Success("基础信息保存成功");
                }
                else
                {
                    return ApiResult.Failed("基础信息保存失败");
                }

            }
        }
    }
}