﻿using System;
using Mall.Common.AOP;
using Mall.Common.Plugin;

namespace Mall.Model.Entity.Property
{

    /// <summary>
    /// 采购单明细实体
    /// </summary> 
    [Serializable]
    [DB(ConnectionName = "PropertyConnection")]
    public class RB_Procurement_Detail
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 采购单id
        /// </summary>        
        public int? ProcurementId
        {
            get;
            set;
        }
        /// <summary>
        /// 耗材id
        /// </summary>        
        public int? MaterialId
        {
            get;
            set;
        }
        /// <summary>
        /// 成本价格
        /// </summary>        
        public decimal? CostMoney
        {
            get;
            set;
        }
        /// <summary>
        /// 采购数量
        /// </summary>        
        public int? Number
        {
            get;
            set;
        }
        /// <summary>
        /// 状态 0 正常 1删除
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }
        /// <summary>
        /// 公司
        /// </summary>        
        public int? RB_Branch_Id
        {
            get;
            set;
        }
        /// <summary>
        /// 集团
        /// </summary>        
        public int? RB_Group_Id
        {
            get;
            set;
        }
        /// <summary>
        /// CreateBy
        /// </summary>        
        public int? CreateBy
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// 已入库的数量
        /// </summary>
        public int? StockInNum { get; set; }
    }
}