﻿using Mall.Common.AOP;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 图片魔方表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Mall_Magic
    {
        /// <summary>
        /// 魔方Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }

        /// <summary>
        /// 魔方名称
        /// </summary>        
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// 魔方样式
        /// </summary>        
        public int? Style
        {
            get;
            set;
        }

        /// <summary>
        /// 魔方数据[JSON]格式
        /// </summary>        
        public string MagicData
        {
            get;
            set;
        }

        /// <summary>
        /// 商户号Id
        /// </summary>        
        public int? TenantId
        {
            get;
            set;
        }

        /// <summary>
        /// 小程序Id
        /// </summary>        
        public int? MallBaseId
        {
            get;
            set;
        }

        /// <summary>
        /// 创建时间
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }

        /// <summary>
        /// 删除状态
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }
    }
}