﻿using Mall.Common.AOP;
using Mall.Common.Enum.Goods;
using Mall.Common.Enum.MarketingCenter;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 商户用户余额表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Member_BalanceRecharge
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }


        /// <summary>
        /// 订单号
        /// </summary>
        public string OrderNo { get; set; }
        /// <summary>
        /// 用户id
        /// </summary>
        public int? UserId { get; set; }

        /// <summary>
        /// 充值金额
        /// </summary>        
        public decimal? Balance
        {
            get;
            set;
        }

        /// <summary>
        /// 赠送金额
        /// </summary>
        public int GiveMoney { get; set; }


        /// <summary>
        /// 赠送积分
        /// </summary>
        public int GiveIntegral { get; set; }

        /// <summary>
        /// 充值规则id，0-则是默认，>0查找规则信息判断是否满足条件
        /// </summary>
        public int RechargeRulesId { get; set; }

        /// <summary>
        /// 充值订单生成时间
        /// </summary>
        public DateTime RechargeTime { get; set; }

        /// <summary>
        /// 状态  0-未支付   1-已支付
        /// </summary>
        public int Status { get; set; }

        /// <summary>
        /// 充值方式（1-在线充值，2-手动充值3-系统返利）
        /// </summary>
        public int RechargeType { get; set; }

        /// <summary>
        /// 订单来源（平台）  枚举
        /// </summary>        
        public UserSourceEnum? OrderSource
        {
            get;
            set;
        }
        /// <summary>
        /// 支付类型 枚举  1微信  2支付宝   3银行卡 
        /// </summary>        
        public Common.Enum.Goods.OrderPayTypeEnum? PayWay
        {
            get;
            set;
        }


        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号id
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }

        /// <summary>
        /// 备注
        /// </summary>
        public string Remarks { get; set; }

        /// <summary>
        /// 订单号
        /// </summary>        
        public string Out_Trade_No
        {
            get;
            set;
        }
        /// <summary>
        /// 微信支付订单号
        /// </summary>        
        public string Transaction_Id
        {
            get;
            set;
        }

    }
}
