﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 粉象返佣等级仓储层
    /// </summary>
    public class RB_Distributor_FXGradeRepository : RepositoryBase<RB_Distributor_FXGrade>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Distributor_FXGrade_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Distributor_FXGrade_Extend dmodel)
        {
            string where = $@" 1=1 and {nameof(RB_Distributor_FXGrade.Status)}=0";
            if (dmodel.TenantId > 0) {
                where += $@" and {nameof(RB_Distributor_FXGrade.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0) {
                where += $@" and {nameof(RB_Distributor_FXGrade.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0) {
                where += $@" and {nameof(RB_Distributor_FXGrade.Id)}={dmodel.Id}";
            }
            if (dmodel.Grade > 0) {
                where += $@" and {nameof(RB_Distributor_FXGrade.Grade)}={dmodel.Grade}";
            }
            if (!string.IsNullOrEmpty(dmodel.GradeName)) {
                where += $@" and {nameof(RB_Distributor_FXGrade.GradeName)} like '%{dmodel.GradeName}%'";
            }
            
            string sql = $@"select * from RB_Distributor_FXGrade where {where} order by Id desc";
            return GetPage<RB_Distributor_FXGrade_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Distributor_FXGrade_Extend> GetList(RB_Distributor_FXGrade_Extend dmodel)
        {
            string where = $@" 1=1 and {nameof(RB_Distributor_FXGrade.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Distributor_FXGrade.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Distributor_FXGrade.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and {nameof(RB_Distributor_FXGrade.Id)}={dmodel.Id}";
            }
            if (!string.IsNullOrEmpty(dmodel.GradeIds))
            {
                where += $@" and {nameof(RB_Distributor_FXGrade.Id)} in({dmodel.GradeIds})";
            }
            if (dmodel.Grade > 0)
            {
                where += $@" and {nameof(RB_Distributor_FXGrade.Grade)}={dmodel.Grade}";
            }
            if (!string.IsNullOrEmpty(dmodel.GradeName))
            {
                where += $@" and {nameof(RB_Distributor_FXGrade.GradeName)} like '%{dmodel.GradeName}%'";
            }
            if (dmodel.IsGuest > 0) 
            {
                where += $@" and {nameof(RB_Distributor_FXGrade.IsGuest)}={dmodel.IsGuest}";
            }
            if (dmodel.IsCanBuy > 0)
            {
                where += $@" and {nameof(RB_Distributor_FXGrade.IsCanBuy)}={dmodel.IsCanBuy}";
            }
            string sql = $@"select * from RB_Distributor_FXGrade where {where} order by Grade asc";
            return Get<RB_Distributor_FXGrade_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取下个等级
        /// </summary>
        /// <param name="grade"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public RB_Distributor_FXGrade_Extend GetDistrbutorUpgrade(int grade, int tenantId, int mallBaseId)
        {
            string where = $@" 1=1 and {nameof(RB_Distributor_FXGrade.Status)}=0";

            where += $@" and {nameof(RB_Distributor_FXGrade.TenantId)}={tenantId}";
            where += $@" and {nameof(RB_Distributor_FXGrade.MallBaseId)}={mallBaseId}";
            where += $@" and {nameof(RB_Distributor_FXGrade.Grade)}>{grade}";            

            string sql = $@"select * from RB_Distributor_FXGrade where {where} order by Grade asc limit 1";
            return Get<RB_Distributor_FXGrade_Extend>(sql).FirstOrDefault();
        }
    }
}
