﻿using Mall.Common.AOP;
using Mall.Common.Enum.MarketingCenter;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.MarketingCenter
{
    /// <summary>
    /// 模板市场扩展实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Template_Market_Extend : Model.Entity.MarketingCenter.RB_Template_Market
    {
        /// <summary>
        /// 创建时间字符串
        /// </summary>
        public string CreateDateStr
        {
            get
            {
                string str = "";
                if (this.CreateDate != null)
                {
                    str = Convert.ToDateTime(this.CreateDate).ToString("yyyy-MM-dd HH:mm:ss");
                }
                return str;
            }
        }

        /// <summary>
        /// 创建人
        /// </summary>
        public string CreateByName { get; set; }

        /// <summary>
        /// 编号【逗号分割查询使用】
        /// </summary>
        public string QIds { get; set; }
    }
}