﻿using Mall.Model.Entity.Property;
using Mall.Model.Extend.Property;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Property
{
    public class RB_WarehouseOut_ApplyRepository : RepositoryBase<RB_WarehouseOut_Apply>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_WarehouseOut_Apply); } }
        /// <summary>
        /// 出库申请列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_WarehouseOut_Apply_Extend> GetApplyPageList(int pageIndex, int pageSize, out long rowCount, RB_WarehouseOut_Apply_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(@$" select a.*,b.NotOutStock,c.Delivered from {TableName} as a
LEFT JOIN (SELECT ApplyId,COUNT(*) as NotOutStock from rb_warehouseout_goods where `IsOut`=0 and Status=0 GROUP BY ApplyId) as b on a.ID=b.ApplyId
LEFT JOIN (SELECT ApplyId,COUNT(*) as Delivered from rb_warehouseout_goods where `IsOut`=1 and Status=0 GROUP BY ApplyId) as c on a.ID=c.ApplyId
 where a.Status=0 ");
            if (query != null)
            {
                if (query.ID > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_Apply_Extend.ID)}={query.ID}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_Apply_Extend.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_Apply_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.ApplyStatus > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_Apply_Extend.ApplyStatus)}={query.ApplyStatus}");
                }
                if (query.OutStatus > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_Apply_Extend.OutStatus)}={query.OutStatus}");
                }
                if (query.SupplierId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_Apply_Extend.SupplierId)}={query.SupplierId}");
                }
            }
            return GetPage<RB_WarehouseOut_Apply_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 出库申请列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_WarehouseOut_Apply_Extend> GetApplyList(RB_WarehouseOut_Apply_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" select * from {TableName} as a where a.Status=0 ");
            if (query != null)
            {
                if (query.ID > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_Apply_Extend.ID)}={query.ID}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_Apply_Extend.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_Apply_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.OutStatus > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_Apply_Extend.OutStatus)}={query.OutStatus}");
                }
                if (query.ApplyStatus > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_Apply_Extend.ApplyStatus)}={query.ApplyStatus}");
                }
                if (query.SupplierId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_Apply_Extend.SupplierId)}={query.SupplierId}");
                }
            }
            return Get<RB_WarehouseOut_Apply_Extend>(builder.ToString()).ToList();
        }
    }
}
