﻿using Microsoft.AspNetCore.Http;
using System;
using System.Collections;
using System.Text;
using System.Xml;

namespace Mall.Common.Pay.WeChatPat
{
    /// <summary>
    /// 微信支付响应类
    /// </summary>
    public class ResponseHandler
    {


       

        /// <summary>
        /// 密钥
        /// </summary>
        private string _key;

        /// <summary>
        /// 微信服务器编码方式
        /// </summary>
        private const string Charset = "utf-8";

        /// <summary>
        /// 
        /// </summary>
        private Hashtable xmlMap;

        /// <summary>
        /// 获取页面提交的get和post参数
        /// </summary>
        public ResponseHandler(IHttpContextAccessor _accessor)
        {
            xmlMap = new Hashtable();

            if (_accessor.HttpContext.Request.ContentLength > 0)
            {
                var reader = new System.IO.StreamReader(_accessor.HttpContext.Request.Body, Encoding.UTF8);

                Plugin.LogHelper.Write(null, "Notify支付回调：reader-" + reader.ToString());
                _accessor.HttpContext.Request.Body.Position = 0;
                var xmlDoc = new XmlDocument();
                xmlDoc.Load(reader);
                var root = xmlDoc.SelectSingleNode("xml");
                var xnl = root.ChildNodes;
                foreach (XmlNode xnf in xnl)
                {
                    xmlMap.Add(xnf.Name, xnf.InnerText);
                }
                Plugin.LogHelper.Write(null, "Notify支付回调：xmlMap-" + xmlMap.ToString());
            }
            //if (HttpContext.Current.Request.InputStream.Length > 0)
            //{
            //    var xmlDoc = new XmlDocument();
            //    xmlDoc.Load(HttpContext.Current.Request.InputStream);
            //    var root = xmlDoc.SelectSingleNode("xml");
            //    var xnl = root.ChildNodes;
            //    foreach (XmlNode xnf in xnl)
            //    {
            //        xmlMap.Add(xnf.Name, xnf.InnerText);
            //    }
            //}
        }

        /// <summary>
        /// 初始化加载
        /// </summary>
        public virtual void Init()
        {
        }

        /// <summary>
        /// 获取密钥
        /// </summary>
        /// <returns></returns>
        public string GetKey()
        {
            return _key;
        }

        /// <summary>
        /// 设置密钥
        /// </summary>
        /// <param name="key"></param>
        public void SetKey(string key)
        {
            this._key = key;
        }

        /// <summary>
        /// 获取参数值
        /// </summary>
        /// <param name="parameter"></param>
        /// <returns></returns>
        public string GetParameter(string parameter)
        {
            var s = (string)xmlMap[parameter];
            return s ?? "";
        }

        /// <summary>
        /// 设置参数值
        /// </summary>
        /// <param name="parameter"></param>
        /// <param name="parameterValue"></param>
        public void SetParameter(string parameter, string parameterValue)
        {
            //if (parameter != null && parameter != "")
            //{
            //    if (parameters.Contains(parameter))
            //    {
            //        parameters.Remove(parameter);
            //    }
            //    parameters.Add(parameter, parameterValue);
            //}
        }

        /// <summary>
        /// 判断微信签名
        /// </summary>
        /// <returns></returns>
        public virtual bool IsWXsign(out string error)
        {
            var sb = new StringBuilder();
            var signMap = new Hashtable();
            foreach (string k in xmlMap.Keys)
            {
                if (k != "sign")
                {
                    signMap.Add(k.ToLower(), xmlMap[k]);
                }
            }
            var akeys = new ArrayList(signMap.Keys);
            akeys.Sort();
            foreach (string k in akeys)
            {
                var v = (string)signMap[k];
                sb.Append(k + "=" + v + "&");
            }
            sb.Append("key=" + this._key);
            var sign = Plugin.SecurityHelper.MD5EncryptWeChat(sb.ToString(), Charset).ToUpper();
            error = "sign = " + sign + "\r\n xmlMap[sign]=" + xmlMap["sign"].ToString();
            return sign.Equals(xmlMap["sign"]);
        }

        ///// <summary>
        ///// 获取编码方式
        ///// </summary>
        ///// <returns></returns>
        //protected virtual string GetCharset()
        //{
        //    //return "UTF-8";
        //    try
        //    {
        //        return HttpHelper.GetRequestEncoding(_accessor.HttpContext.Request).BodyName;
        //    }
        //    catch (Exception)
        //    {
        //        return "UTF-8";
        //    }
        //}
    }
}
