﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Extend.User;
using Mall.Repository;

namespace Mall.Module.User
{
    /// <summary>
    /// 小程序处理类
    /// </summary>
    public class MiniProgramModule
    {
        /// <summary>
        /// 商户仓储层对象
        /// </summary>
        private Mall.Repository.User.RB_MiniProgramRepository  programRepository = new Repository.User.RB_MiniProgramRepository();


        /// <summary>
        /// 根据查询条件获取小程序列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_MiniProgram_Extend> GetTenantListModule(RB_MiniProgram_Extend query)
        {
            return programRepository.GetListRepository(query);
        }

        /// <summary>
        /// 获取小程序分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_MiniProgram_Extend> GetMiniProgramPageListModule(int pageIndex, int pageSize, out long rowCount, RB_MiniProgram_Extend query)
        {
            return programRepository.GetPageListRepository(pageIndex, pageSize, out rowCount, query);
        }


        /// <summary>
        /// 判断用户是否存在
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool CheckMiniProgramModule(RB_MiniProgram_Extend extModel)
        {
            List<WhereHelper> wheres = new List<WhereHelper>()
            {
                new WhereHelper(nameof(RB_MiniProgram_Extend.MallName),extModel.MallName.Trim())
            };
            return programRepository.Exists(wheres);
        }

        /// <summary>
        /// 添加修改小程序
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetMiniProgramModule(RB_MiniProgram_Extend extModel)
        {
            bool flag = false;
            if (extModel.IsEffective == 1)
            {
                extModel.MallValidate = null;
            }
            if (extModel.MallBaseId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_MiniProgram_Extend.MallName),extModel.MallName.Trim()},
                    { nameof(RB_MiniProgram_Extend.IsEffective),extModel.IsEffective},
                    { nameof(RB_MiniProgram_Extend.MallValidate),extModel.MallValidate},
                };
                flag = programRepository.Update(fileds, new WhereHelper(nameof(RB_Tenant_Extend.TenantId), extModel.TenantId));
            }
            else
            {
                extModel.MallName = extModel.MallName.Trim();
                extModel.CreateDate = DateTime.Now;
                int NewId = programRepository.Insert(extModel);
                extModel.MallBaseId = NewId;
                flag = NewId > 0;
            }
            return flag;
        }



        /// <summary>
        /// 根据编号获取小程序信息
        /// </summary>
        /// <param name="MallBaseId">小程序Id</param>
        /// <returns></returns>
        public RB_MiniProgram_Extend GetMiniProgramModule(object MallBaseId)
        {
            RB_MiniProgram_Extend extModel = programRepository.GetEntity<RB_MiniProgram_Extend>(MallBaseId);
            if (extModel == null)
            {
                extModel = new RB_MiniProgram_Extend();
            }
            return extModel;
        }

        /// <summary>
        /// 更新小程序状态
        /// </summary>
        /// <param name="MallBaseId">小程序Id</param>
        /// <param name="Status">小程序状态</param>
        /// <returns></returns>
        public bool SetTenantStatusModule(object MallBaseId, int AccountStatus)
        {
            bool flag = false;
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                { nameof(RB_MiniProgram_Extend.Status),AccountStatus},
            };
            flag = programRepository.Update(fileds, new WhereHelper(nameof(RB_MiniProgram_Extend.MallBaseId), MallBaseId));
            return flag;
        }
    }
}
