﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 商户会员权益仓储层
    /// </summary>
    public class RB_Member_EquityRepository : RepositoryBase<RB_Member_Equity>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Member_Equity_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Member_Equity_Extend dmodel)
        {
            string where = $" 1=1 and {nameof(RB_Member_Equity.Status)}=0";
            if (dmodel.TenantId > 0) {
                where += $@" and {nameof(RB_Member_Equity.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Member_Equity.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (!string.IsNullOrEmpty(dmodel.Title)) {
                where += $@" and {nameof(RB_Member_Equity.Title)} like '%{dmodel.Title}%'";
            }
            if (dmodel.GradeId > 0) {
                where += $@" and {nameof(RB_Member_Equity.GradeId)} ={dmodel.GradeId}";
            }
            string sql = $@"select * from RB_Member_Equity where {where} order by Id desc";
            return GetPage<RB_Member_Equity_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Member_Equity_Extend> GetList(RB_Member_Equity_Extend dmodel)
        {
            string where = $" 1=1 and {nameof(RB_Member_Equity.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Member_Equity.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Member_Equity.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (!string.IsNullOrEmpty(dmodel.Title))
            {
                where += $@" and {nameof(RB_Member_Equity.Title)} like '%{dmodel.Title}%'";
            }
            if (dmodel.GradeId > 0)
            {
                where += $@" and {nameof(RB_Member_Equity.GradeId)} ={dmodel.GradeId}";
            }
            if (!string.IsNullOrEmpty(dmodel.GradeIds)) {
                where += $@" and {nameof(RB_Member_Equity.GradeId)} in({dmodel.GradeIds})";
            }
            string sql = $@"select * from RB_Member_Equity where {where} order by Id desc";
            return Get<RB_Member_Equity_Extend>(sql).ToList();
        }
    }
}
