﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;


namespace Mall.Repository.User
{
    /// <summary>
    /// 小程序仓储层
    /// </summary>
    public class RB_MiniProgramRepository : RepositoryBase<RB_MiniProgram>
    {
        /// <summary>
        /// 根据查询条件获取小程序列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_MiniProgram_Extend> GetListRepository(RB_MiniProgram_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(" SELECT * FROM RB_MiniProgram WHERE 1=1 ");
            if (query != null)
            {
                if (query.TenantId != null && query.TenantId > 0)
                {
                    builder.AppendFormat(" AND TenantId='{0}' ", query.TenantId);
                }
            }
            return Get<RB_MiniProgram_Extend>(builder.ToString()).ToList();
        }

        /// <summary>
        /// 获取小程序分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_MiniProgram_Extend> GetPageListRepository(int pageIndex, int pageSize, out long rowCount, RB_MiniProgram_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(@" 
SELECT A.*,B.Account,B.MobilePhone
FROM RB_MiniProgram AS A LEFT JOIN RB_Tenant AS B ON A.TenantId=B.TenantId
WHERE 1=1 ");
            if (query != null)
            {
                if (query.TenantId != null && query.TenantId > 0)
                {
                    builder.AppendFormat(" AND A.TenantId='{0}' ", query.TenantId);
                }
                if (query.MallName != null && !string.IsNullOrEmpty(query.MallName.Trim()))
                {
                    builder.AppendFormat(" AND A.MallName LIKE '%{0}%' ", query.MallName.Trim());
                }
            }
            return GetPage<RB_MiniProgram_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }
    }
}
