﻿using Mall.Model.Entity.TradePavilion;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Extend.TradePavilion
{
    /// <summary>
    /// 榜单扩展实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_FirstShop_List_Extend : RB_FirstShop_List
    {
        /// <summary>
        /// 面向群体
        /// </summary>
        public List<string> ObjectTypeList { get; set; }

        /// <summary>
        /// 面向群里id
        /// </summary>
        public int ObjectTypeId { get; set; }

        /// <summary>
        /// 小程序端状态  1进行中 ， 2报名已截止 ， 3已放榜
        /// </summary>
        public int State { get; set; }

        /// <summary>
        /// 排序  1根据报名截止日期
        /// </summary>
        public int OrderBy { get; set; }

        /// <summary>
        /// 是否查询正常的 1是
        /// </summary>
        public int IsAppletSelectNor { get; set; }

        /// <summary>
        /// 年份
        /// </summary>
        public int Year { get; set; }

        /// <summary>
        /// 报名
        /// </summary>
        public List<RB_FirstShop_ListEnroll_Extend> EnrollList { get; set; }

        /// <summary>
        /// 上榜列表
        /// </summary>
        public List<RB_FirstShop_ListEnroll_Extend> RankList { get; set; }

        #region 奖章信息

        /// <summary>
        /// 排名
        /// </summary>
        public int Rank { get; set; }

        /// <summary>
        /// 奖章图标
        /// </summary>
        public string MedalImage { get; set; }

        /// <summary>
        /// 上榜状态  1上榜   2未上榜
        /// </summary>
        public int RankListState { get; set; }
        #endregion


        /// <summary>
        /// 查询多个榜单
        /// </summary>
        public string QIds { get; set; }
    }
}
