﻿using Mall.Model.Entity.MarketingCenter;
using Mall.Model.Entity.User;
using Mall.Model.Extend.MarketingCenter;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.MarketingCenter
{
    public class RB_DiscountCouponRepository : RepositoryBase<RB_DiscountCoupon>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_DiscountCoupon); } }

        /// <summary>
        /// 表名称
        /// </summary>
        public string discountCouponTableName { get { return nameof(RB_Member_DiscountCoupon); } }

        /// <summary>
        /// 卡券信息列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_DiscountCoupon_Extend> GetDiscountCouponPageList(int pageIndex, int pageSize, out long rowCount, RB_DiscountCoupon_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE  {nameof(RB_DiscountCoupon_Extend.Status)}=0");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_DiscountCoupon_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_DiscountCoupon_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (!string.IsNullOrWhiteSpace(query.Name))
                {
                    builder.Append($" AND {nameof(RB_DiscountCoupon_Extend.Name)} like '%{query.Name}%'");
                }
            }
            return GetPage<RB_DiscountCoupon_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 卡券信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_DiscountCoupon_Extend> GetDiscountCouponList(RB_DiscountCoupon_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE {nameof(RB_DiscountCoupon_Extend.Status)}=0 ");
            if (query != null)
            {
                if (query.ID > 0)
                {
                    builder.Append($" AND {nameof(RB_DiscountCoupon_Extend.ID)}={query.ID}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_DiscountCoupon_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_DiscountCoupon_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (!string.IsNullOrWhiteSpace(query.Name))
                {
                    builder.Append($" AND {nameof(RB_DiscountCoupon_Extend.Name)} like '%{query.Name}%'");
                }
                if (!string.IsNullOrEmpty(query.CouponIds))
                {
                    builder.Append($" AND {nameof(RB_DiscountCoupon_Extend.ID)} in({query.CouponIds})");
                }
            }
            return Get<RB_DiscountCoupon_Extend>(builder.ToString()).ToList();
        }




        /// <summary>
        /// 根据用户id和商品分类以及商品id获取未使用的优惠券信息
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_DiscountCoupon_Extend> GetNoUseCouponList(RB_DiscountCoupon_Extend query)
        {
            string where = "   and a.StartDate<NOW() and  a.EndDate>NOW()  and b.`Status`=0  ";
            string goodsClassWhere = "";//分类
            string goodsWhere = "";//商品
            string allWhere = "";//通用
            if (query != null)
            {

                if (query.TenantId > 0)
                {
                    where += $" AND b.{nameof(RB_DiscountCoupon_Extend.TenantId)}={query.TenantId}";
                }
                if (query.MallBaseId > 0)
                {
                    where += $" AND b.{nameof(RB_DiscountCoupon_Extend.MallBaseId)}={query.MallBaseId}";
                }
                if (query.UserId > 0)
                {
                    where += $" AND a.{nameof(RB_DiscountCoupon_Extend.UserId)}={query.UserId}";
                }
                if (query.ProductList != null && query.ProductList.Any())
                {

                    List<int> allGoodsClass = new List<int>();

                    foreach (var item in query.ProductList)
                    {
                        if (!string.IsNullOrWhiteSpace(goodsWhere))
                        {
                            goodsWhere += $" or (c.ProductId = {item.ProductId} and b.MinConsumePrice<= {item.GoodsPrice})   ";
                        }
                        else
                        {
                            goodsWhere += $"  (c.ProductId = {item.ProductId} and b.MinConsumePrice<= {item.GoodsPrice})   ";
                        }
                        allGoodsClass.AddRange(item.GoodsClassId.ToList());
                    }
                    goodsWhere = " and (" + goodsWhere + ")";

                    //分类
                    var goodsClassList = allGoodsClass.GroupBy(x => x);
                    foreach (var item in goodsClassList)
                    {
                        decimal nowPrice = 0;

                        foreach (var classItem in query.ProductList)
                        {
                            if (classItem.GoodsClassId.Any(x => x == item.Key))
                            {
                                nowPrice += classItem.GoodsPrice;
                            }
                        }
                        if (!string.IsNullOrWhiteSpace(goodsClassWhere))
                        {
                            goodsClassWhere += $" or (c.ProductId = {item.Key} and b.MinConsumePrice<= {nowPrice})   ";
                        }
                        else
                        {
                            goodsClassWhere += $"  (c.ProductId = {item.Key} and b.MinConsumePrice<= {nowPrice})   ";
                        }
                    }
                    goodsClassWhere = " and (" + goodsClassWhere + ")";




                    decimal allPrice = query.ProductList.Sum(x => x.GoodsPrice);
                    allWhere = $" and  b.MinConsumePrice<= {allPrice} ";

                }
            }
            string sql = @$" SELECT a.ID,a.UserId,b.`Name`,b.CouponType,b.UseType,b.MinConsumePrice,b.DiscountsPrice,b.MaxDiscountsPrice,b.Describe,a.StartDate,a.EndDate from rb_discountcoupon as b
 LEFT JOIN  rb_discountcoupon_product as c on b.ID=c.DiscountCouponId 
LEFT JOIN rb_member_discountcoupon as a on a.CouponId=b.ID
where b.UseType=1 and c.`Status`=0 {where} {goodsClassWhere}
UNION ALL
SELECT a.ID,a.UserId,b.`Name`,b.CouponType,b.UseType,b.MinConsumePrice,b.DiscountsPrice,b.MaxDiscountsPrice,b.Describe,a.StartDate,a.EndDate from rb_discountcoupon as b
 LEFT JOIN  rb_discountcoupon_product as c on b.ID=c.DiscountCouponId 
LEFT JOIN rb_member_discountcoupon as a on a.CouponId=b.ID
where b.UseType=2 and c.`Status`=0  {where} {goodsWhere}
UNION all
 SELECT a.ID,a.UserId,b.`Name`,b.CouponType,b.UseType,b.MinConsumePrice,b.DiscountsPrice,b.MaxDiscountsPrice,b.Describe,a.StartDate,a.EndDate from rb_discountcoupon as b 
LEFT JOIN rb_member_discountcoupon as a on a.CouponId=b.ID
 where   b.UseType=3   {where} {allWhere}";
            return Get<RB_DiscountCoupon_Extend>(sql).ToList();
        }



    }
}
