﻿using Mall.Common.AOP;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Finance
{
    /// <summary>
    /// 客户账户表
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "FinanceConnection")]
    public class RB_ClientBankAccount
    {
        /// <summary>
        /// ID
        /// </summary>        
        public int ID
        {
            get;
            set;
        }
        /// <summary>
        /// 地接、OP、签证、票务、领队、工资提成、其他
        /// </summary>        
        public Common.Enum.Finance.ClientTypeEnum? Type
        {
            get;
            set;
        }
        /// <summary>
        /// 账户类型对应的对象编号
        /// </summary>        
        public int? ObjID
        {
            get;
            set;
        }
        /// <summary>
        /// 所属银行
        /// </summary>        
        public int? BankId
        {
            get;
            set;
        }
        /// <summary>
        /// 开户支行
        /// </summary>        
        public string OpenBankName
        {
            get;
            set;
        }
        /// <summary>
        /// 开户人
        /// </summary>        
        public string AccountHolder
        {
            get;
            set;
        }
        /// <summary>
        /// 卡号
        /// </summary>        
        public string CardNum
        {
            get;
            set;
        }
        /// <summary>
        /// 账户别名
        /// </summary>        
        public string AccountAlias
        {
            get;
            set;
        }
        /// <summary>
        /// 状态
        /// </summary>        
        public Common.Enum.DateStateEnum Status
        {
            get;
            set;
        }
        /// <summary>
        /// 创建人
        /// </summary>        
        public int? CreateBy
        {
            get;
            set;
        }
        /// <summary>
        /// 创建时间
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// 集团
        /// </summary>        
        public int? RB_Group_Id
        {
            get;
            set;
        }
        /// <summary>
        /// 公司
        /// </summary>        
        public int? RB_Branch_Id
        {
            get;
            set;
        }
        /// <summary>
        /// 公私账户类型  1公  2私
        /// </summary>
        public int? AccountType
        {
            get; set;
        }
        /// <summary>
        /// 账户分类  1平台  2银行  3虚拟账户  4微信支付宝
        /// </summary>
        public int? AccountClassify
        {
            get; set;
        }


        ///// <summary>
        ///// 供应商id
        ///// </summary>
        //public int SupplierId { get; set; }
    }
}
