﻿using Mall.Model.Entity.BaseSetUp;
using Mall.Model.Extend.BaseSetUp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.BaseSetUp
{
    /// <summary>
    /// 分类包邮规则分类仓储层
    /// </summary>
    public class RB_FreeShippingCategoryRepository : RepositoryBase<RB_FreeShippingCategory>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_FreeShippingCategory); } }
        /// <summary>
        /// 分类包邮规则分类信息列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_FreeShippingCategory_Extend> GetFreeShippingCategoryPage(int pageIndex, int pageSize, out long rowCount, RB_FreeShippingCategory_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT a.*,b.`Name` as CategoryName  FROM {TableName} as a LEFT JOIN rb_product_category as b on a.CategoryId=b.Id WHERE a.`Status`=0 and b.`Status`=0");
            if (query != null)
            {
                if (query.ID > 0)
                {
                    builder.Append($" AND a.{nameof(RB_FreeShippingCategory_Extend.ID)}={query.ID}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_FreeShippingCategory_Extend.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_FreeShippingCategory_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.FreeShippingId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_FreeShippingCategory_Extend.FreeShippingId)}={query.FreeShippingId}");
                }
                if (!string.IsNullOrWhiteSpace(query.FreeShippingIds))
                {
                    builder.Append($" AND a.{nameof(RB_FreeShippingCategory_Extend.FreeShippingId)} in ({query.FreeShippingIds})");
                }
                if (!string.IsNullOrWhiteSpace(query.CategoryIds))
                {
                    builder.Append($" AND a.{nameof(RB_FreeShippingCategory_Extend.CategoryId)} in ({query.CategoryIds})");
                }
            }
            return GetPage<RB_FreeShippingCategory_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 分类包邮规则分类信息列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_FreeShippingCategory_Extend> GetFreeShippingCategoryList(RB_FreeShippingCategory_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT a.*,b.`Name` as CategoryName FROM {TableName} as a LEFT JOIN rb_product_category as b on a.CategoryId=b.Id WHERE a.`Status`=0 and b.`Status`=0");
            if (query != null)
            {
                if (query.ID > 0)
                {
                    builder.Append($" AND a.{nameof(RB_FreeShippingCategory_Extend.ID)}={query.ID}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_FreeShippingCategory_Extend.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_FreeShippingCategory_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.FreeShippingId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_FreeShippingCategory_Extend.FreeShippingId)}={query.FreeShippingId}");
                }
                if (!string.IsNullOrWhiteSpace(query.FreeShippingIds))
                {
                    builder.Append($" AND a.{nameof(RB_FreeShippingCategory_Extend.FreeShippingId)} in ({query.FreeShippingIds})");
                }
                if (!string.IsNullOrWhiteSpace(query.CategoryIds))
                {
                    builder.Append($" AND a.{nameof(RB_FreeShippingCategory_Extend.CategoryId)} in ({query.CategoryIds})");
                }
            }
            return Get<RB_FreeShippingCategory_Extend>(builder.ToString()).ToList();
        }
    }
}
