﻿using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.User
{
    /// <summary>
    /// 供应商
    /// </summary>
   public class RB_SupplierRepository:RepositoryBase<RB_Supplier>
    {

        public string TableName { get { return nameof(RB_Supplier); } }
        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Supplier_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Supplier_Extend dmodel)
        {
            string where = " where 1=1  AND a.Status=0 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and a.{nameof(RB_Supplier.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and a.{nameof(RB_Supplier.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (!string.IsNullOrWhiteSpace(dmodel.Name))
            {
                where += $@" and a.{nameof(RB_Supplier.Name)} like '%{dmodel.Name}%'";
            }
            string sql = $@"select a.*,b.`Name` as IntroducerName from {TableName} as a LEFT JOIN rb_distributor_info as b on a.Introducer=b.UserId {where} order by a.Id desc";
            return GetPage<RB_Supplier_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Supplier_Extend> GetList(RB_Supplier_Extend dmodel)
        {
            string where = " where 1=1  AND a.Status=0 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and a.{nameof(RB_Supplier.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and a.{nameof(RB_Supplier.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.ID > 0)
            {
                where += $@" and a.{nameof(RB_Supplier.ID)}={dmodel.ID}";
            }
            if (!string.IsNullOrEmpty(dmodel.SupplierIds)) 
            {
                where += $@" and a.{nameof(RB_Supplier.ID)} in({dmodel.SupplierIds})";
            }
            string sql = $@"select a.*,b.`Name` as IntroducerName from {TableName} as a LEFT JOIN rb_distributor_info as b on a.Introducer=b.UserId {where} order by a.Id desc";
            return Get<RB_Supplier_Extend>(sql).ToList();
        }
    }
}
