﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Common.Plugin;
using Mall.Model.Entity.BaseSetUp;
using Mall.Model.Extend.BaseSetUp;
using Mall.Module.BaseSetUp;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace Mall.WebApi.Controllers.MallBase
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class MallBaseController : BaseController
    {

        private MallBaseModule mallBaseModule = new MallBaseModule();
        private Module.User.TenantModule TenantModule = new Module.User.TenantModule();

        #region 基础设置
        [HttpPost]
        public ApiResult AddOrUpdateMallBase()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_MallBase_Extend>(RequestParm.msg.ToString());

            if (query == null)
            {
                return ApiResult.Failed("请传入需要操作的小程序");
            }
            else
            {
                if (string.IsNullOrWhiteSpace(query.MallName))
                {
                    return ApiResult.Failed("请输入商城名称");
                }
                query.TenantId = UserInfo.TenantId;
                query.MallBaseId = parms.MallBaseId;
                //if (query.ID == 0)//新增
                //{
                //    var TenantModel = TenantModule.GetTenantModule(query.TenantId);
                //    if (TenantModel == null)
                //    {
                //        return ApiResult.Failed("请确保商户信息正确");
                //    }
                //    if (TenantModel.AccountStatus != 2)
                //    {
                //        return ApiResult.Failed("商户状态审核不通过");
                //    }
                //    if (TenantModel.IsEffective == 0 && TenantModel.AccountValidate.HasValue && TenantModel.AccountValidate.Value < System.DateTime.Now)
                //    {
                //        return ApiResult.Failed("商户账号已过期");
                //    }
                //    //判断当前商户下面有多少小程序

                //    if (TenantModel.CreateMiniPrograme.HasValue)
                //    {
                //        var oldList = mallBaseModule.GetListRepository(query);
                //        if (oldList.Count() >= TenantModel.CreateMiniPrograme.Value)
                //        {
                //            return ApiResult.Failed("商户可建小程序数：" + TenantModel.CreateMiniPrograme.Value);
                //        }
                //    }
                //}
                bool result = mallBaseModule.AddOrUpdateMallBase(query);
                if (result)
                {
                    return ApiResult.Success("基础信息保存成功");
                }
                else
                {
                    return ApiResult.Failed("基础信息保存失败");
                }

            }
        }


        [HttpPost]
        public ApiResult GetMallBaseInfo()
        {
            var parms = RequestParm;
            var query = new RB_MallBase_Extend();
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var model = mallBaseModule.GetListRepository(query).FirstOrDefault();
            if (model == null)
            {
                model = new RB_MallBase_Extend();
            }
            return ApiResult.Success("获取成功", model);
        }


        #endregion

        #region 物流设置

        #region 物流规格-物流设置
        /// <summary>
        /// 根据商户号获取物流信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetLogistics()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_Logistics>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            var oldLogisticsModel = mallBaseModule.GetLogisticsList(query).FirstOrDefault();
            if (oldLogisticsModel == null)
            {
                oldLogisticsModel = new RB_Logistics();
                oldLogisticsModel.LogisticsType = Common.Enum.MallBase.LogisticsTypeEnum.ExpressBird;
            }
            return ApiResult.Success("", oldLogisticsModel);
        }

        /// <summary>
        /// 保存物流信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult AddOrUpdateLogistics()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_Logistics>(RequestParm.msg.ToString());

            if (query == null)
            {
                return ApiResult.Failed("请传入物流基础信息");
            }
            else
            {
                query.TenantId = UserInfo.TenantId;
                query.MallBaseId = UserInfo.MallBaseId;
                bool result = mallBaseModule.AddOrUpdateLogistics(query);
                if (result)
                {
                    return ApiResult.Success("物流设置信息保存成功");
                }
                else
                {
                    return ApiResult.Failed("基物流设置信息保存失败");
                }
            }
        }



        /// <summary>
        /// 获取用户下载枚举列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetLogisticsEnumList()
        {
            var list = EnumHelper.GetEnumList(typeof(Mall.Common.Enum.MallBase.LogisticsTypeEnum));
            return ApiResult.Success("", list.Select(x => new
            {
                Name = x.Key,
                Id = Convert.ToInt32(x.Value)
            }));
        }
        #endregion

        #region 运费规则
        /// <summary>
        /// 列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetLogisticsRulesPage()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            RB_Logistics_Rules_Extend demodel = JsonConvert.DeserializeObject<RB_Logistics_Rules_Extend>(RequestParm.msg.ToString());
            demodel.TenantId = UserInfo.TenantId;
            demodel.MallBaseId = parms.MallBaseId;
            demodel.RulesType = Common.Enum.MallBase.RulesTypeEnum.Rule;
            var list = mallBaseModule.GetLogisticsRulesList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.ID,
                x.RulesName,
                x.IsDefault
            });
            return ApiResult.Success("", pagelist);
        }


        /// <summary>
        /// 获取详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetLogisticsRules()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_Logistics_Rules_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            query.RulesType = Common.Enum.MallBase.RulesTypeEnum.Rule;
            var oldLogisticsModel = mallBaseModule.GetLogisticsRulesModel(query);
            if (oldLogisticsModel == null)
            {
                oldLogisticsModel = new RB_Logistics_Rules_Extend();
            }
            return ApiResult.Success("", oldLogisticsModel);
        }



        /// <summary>
        /// 设置默认物流规则
        /// </summary>
        /// <returns></returns>
        public ApiResult SetLogisticsRulesDefault()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_Logistics_Rules_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            query.RulesType = Common.Enum.MallBase.RulesTypeEnum.Rule;
            bool result = mallBaseModule.SetDefaultLogisticsRules(query);

            if (result)
            {
                return ApiResult.Success("默认运费规则设置成功");
            }
            else
            {
                return ApiResult.Failed("默认运费规则设置失败");
            }

        }


        /// <summary>
        /// 保存物流信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult AddOrUpdateLogisticsRules()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_Logistics_Rules_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            query.RulesType = Common.Enum.MallBase.RulesTypeEnum.Rule;
            if (query == null)
            {
                return ApiResult.Failed("请传入物流规则信息");
            }
            else
            {
                if (string.IsNullOrWhiteSpace(query.RulesName))
                {
                    return ApiResult.Failed("请输入规则名称");
                }
                if (query.Detail == null || !query.Detail.Any())
                {
                    return ApiResult.Failed("请输入运费规则");
                }
                foreach (var item in query.Detail)
                {
                    if (item.List == null || !item.List.Any())
                    {
                        return ApiResult.Failed("请选择地区");
                    }
                }
                query.TenantId = UserInfo.TenantId;
                if (query.ID == 0)
                {
                    query.CreateDate = System.DateTime.Now;
                }
                query.UpdateDate = System.DateTime.Now;
                bool result = mallBaseModule.AddOrUpdateLogisticsRules(query);
                if (result)
                {
                    return ApiResult.Success("物流规则信息保存成功");
                }
                else
                {
                    return ApiResult.Failed("物流规则信息保存失败");
                }
            }
        }


        [HttpPost]
        public ApiResult DelRules()
        {
            var parms = RequestParm;
            JObject parmsJob = JObject.Parse(RequestParm.msg.ToString());
            int Id = parmsJob.GetInt("Id", 0);
            if (Id <= 0)
            {
                return ApiResult.Failed("请传递参数");
            }
            bool flag = mallBaseModule.DelRulesInfo(Id, UserInfo.TenantId, parms.MallBaseId);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }


        #endregion


        #region 包邮规则
        /// <summary>
        /// 列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetLogisticsPinkagePage()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            RB_Logistics_Rules_Extend demodel = JsonConvert.DeserializeObject<RB_Logistics_Rules_Extend>(RequestParm.msg.ToString());
            demodel.TenantId = UserInfo.TenantId;
            demodel.MallBaseId = parms.MallBaseId;
            demodel.RulesType = Common.Enum.MallBase.RulesTypeEnum.Pinkage;
            var list = mallBaseModule.GetLogisticsPinkageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.ID,
                x.RulesName,
                x.AllRegionPrice,
                RegionList = x.List.Select(x => x.RegionName)
            });
            return ApiResult.Success("", pagelist);
        }



        public ApiResult DelPinkage()
        {
            var parms = RequestParm;
            JObject parmsJob = JObject.Parse(RequestParm.msg.ToString());
            int Id = parmsJob.GetInt("Id", 0);
            if (Id <= 0)
            {
                return ApiResult.Failed("请传递参数");
            }
            bool flag = mallBaseModule.DelPinkageInfo(Id, UserInfo.TenantId, parms.MallBaseId);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }

        /// <summary>
        /// 获取详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetLogisticsPinkage()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_Logistics_Rules_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            query.RulesType = Common.Enum.MallBase.RulesTypeEnum.Pinkage;
            var oldLogisticsModel = mallBaseModule.GetPinkageModel(query);
            if (oldLogisticsModel == null)
            {
                oldLogisticsModel = new RB_Logistics_Rules_Extend();
            }
            return ApiResult.Success("", oldLogisticsModel);
        }


        /// <summary>
        /// 保存物流信息
        /// </summary>
        /// <returns></returns>
        public ApiResult AddOrUpdateLogisticsPinkage()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_Logistics_Rules_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            query.RulesType = Common.Enum.MallBase.RulesTypeEnum.Pinkage;
            if (query == null)
            {
                return ApiResult.Failed("请传入包邮规则信息");
            }
            else
            {
                if (string.IsNullOrWhiteSpace(query.RulesName))
                {
                    return ApiResult.Failed("请输入包邮名称");
                }
                if (query.AllRegionPrice <= -1)
                {
                    return ApiResult.Failed("包邮费用不能为负数");
                }
                if (query.List == null || !query.List.Any())
                {
                    return ApiResult.Failed("请选择地区");
                }
                query.TenantId = UserInfo.TenantId;
                if (query.ID == 0)
                {
                    query.CreateDate = System.DateTime.Now;
                }
                query.UpdateDate = System.DateTime.Now;
                bool result = mallBaseModule.AddOrUpdatePinkage(query);
                if (result)
                {
                    return ApiResult.Success("包邮规则信息保存成功");
                }
                else
                {
                    return ApiResult.Failed("包邮规则信息保存失败");
                }
            }
        }
        #endregion


        #region 起送规则
        public ApiResult GetMinPriceInfo()
        {
            var parms = RequestParm;
            var query = new RB_Logistics_Rules_Extend();
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            query.RulesType = Common.Enum.MallBase.RulesTypeEnum.OpenMinPrice;
            var model = mallBaseModule.GetLogisticsRulesModel(query);
            return ApiResult.Success("获取成功", model);
        }


        /// <summary>
        /// 保存起送信息
        /// </summary>
        /// <returns></returns>
        public ApiResult AddOrUpdateMinPrice()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_Logistics_Rules_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            query.RulesType = Common.Enum.MallBase.RulesTypeEnum.OpenMinPrice;
            if (query == null)
            {
                return ApiResult.Failed("请传入起送规则信息");
            }
            else
            {
                if (query.IsOpenAllRegionPrice == 1)
                {
                    if (query.AllRegionPrice < 0)
                    {
                        return ApiResult.Failed("全地区起送金额不能为负数");
                    }
                }

                if (query.ID == 0)
                {
                    query.CreateDate = System.DateTime.Now;
                }
                query.UpdateDate = System.DateTime.Now;
                bool result = mallBaseModule.AddOrUpdateLogisticsRules(query);
                if (result)
                {
                    return ApiResult.Success("起送规则信息保存成功");
                }
                else
                {
                    return ApiResult.Failed("起送规则信息保存失败");
                }
            }
        }
        #endregion

        #endregion


        #region 退货地址
        /// <summary>
        /// 退货地址列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetLogisticsDeliveryPage()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            RB_Logistics_Delivery_Extend demodel = JsonConvert.DeserializeObject<RB_Logistics_Delivery_Extend>(RequestParm.msg.ToString());
            demodel.TenantId = UserInfo.TenantId;
            demodel.MallBaseId = parms.MallBaseId;
            var list = mallBaseModule.GetDeliveryPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.ID,
                x.Name,
                x.Mobile,
                x.Remarks,
                Address = x.ProvinceName + x.CityName + x.DistrictName + x.Address,
                x.CityName,
                x.IsDefault
            });
            return ApiResult.Success("", pagelist);
        }


        /// <summary>
        /// 获取退货地址详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetLogisticsDelivery()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_Logistics_Delivery_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var oldLogisticsModel = mallBaseModule.GetLogisticsDeliveryList(query).FirstOrDefault();
            if (oldLogisticsModel == null)
            {
                oldLogisticsModel = new RB_Logistics_Delivery_Extend();
            }
            return ApiResult.Success("", oldLogisticsModel);
        }



        /// <summary>
        /// 设置默认退货地址
        /// </summary>
        /// <returns></returns>
        public ApiResult SetLogisticsDeliveryDefault()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_Logistics_Delivery_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            bool result = mallBaseModule.SetDefaultLogisticsDelivery(query);

            if (result)
            {
                return ApiResult.Success("默认收货地址设置成功");
            }
            else
            {
                return ApiResult.Failed("默认收货地址设置失败");
            }

        }


        /// <summary>
        /// 保存退货地址信息
        /// </summary>
        /// <returns></returns>
        public ApiResult AddOrUpdateLogisticsDelivery()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_Logistics_Delivery_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            if (query == null)
            {
                return ApiResult.Failed("请传入物流规则信息");
            }
            else
            {
                if (string.IsNullOrWhiteSpace(query.Name))
                {
                    return ApiResult.Failed("请输入收件人姓名");
                }
                if (string.IsNullOrWhiteSpace(query.Mobile))
                {
                    return ApiResult.Failed("请输入联系方式");
                }

                if (query.ProvinceId == 0)
                {
                    return ApiResult.Failed("请选择省");
                }
                if (query.CityId == 0)
                {
                    return ApiResult.Failed("请选择市");
                }
                if (query.DistrictId == 0)
                {
                    return ApiResult.Failed("请选择区");
                }
                if (string.IsNullOrWhiteSpace(query.Address))
                {
                    return ApiResult.Failed("请输入详细地址");
                }
                if (query.ID == 0)
                {
                    query.CreateDate = System.DateTime.Now;
                }
                query.UpdateDate = System.DateTime.Now;
                bool result = mallBaseModule.AddOrUpdateDelivery(query);
                if (result)
                {
                    return ApiResult.Success("退货地址保存成功");
                }
                else
                {
                    return ApiResult.Failed("退货地址保存失败");
                }
            }
        }

        /// <summary>
        /// 删除退货地址
        /// </summary>
        /// <returns></returns>
        public ApiResult DelDelivery()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_Logistics_Delivery_Extend>(RequestParm.msg.ToString());
            if (query.ID <= 0)
            {
                return ApiResult.Failed("请传递参数");
            }
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            bool flag = mallBaseModule.DelDelivery(query);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }

        #endregion


        #region 区域购买
        public ApiResult GetAreaBuyInfo()
        {
            var parms = RequestParm;
            var query = new RB_Logistics_Rules_Extend();
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            query.RulesType = Common.Enum.MallBase.RulesTypeEnum.AreaBuy;
            var model = mallBaseModule.GetPinkageModel(query);
            return ApiResult.Success("获取成功", model);
        }


        /// <summary>
        /// 保存区域购买
        /// </summary>
        /// <returns></returns>
        public ApiResult AddOrUpdateAreaBuy()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_Logistics_Rules_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            query.RulesType = Common.Enum.MallBase.RulesTypeEnum.AreaBuy;
            if (query == null)
            {
                return ApiResult.Failed("请传入区域规则信息");
            }
            else
            {
                //if (query.IsOpenAllRegionPrice ==1)
                //{
                //    if (query.List == null || !query.List.Any())
                //    {
                //        return ApiResult.Failed("请选择地区");
                //    }
                //}

                if (query.ID == 0)
                {
                    query.CreateDate = System.DateTime.Now;
                }
                query.UpdateDate = System.DateTime.Now;
                bool result = mallBaseModule.AddOrUpdatePinkage(query);
                if (result)
                {
                    return ApiResult.Success("区域购买信息保存成功");
                }
                else
                {
                    return ApiResult.Failed("区域购买信息保存失败");
                }
            }
        }
        #endregion


        #region 获取快递公司信息
        public ApiResult GetExpressInfo()
        {
            var parms = RequestParm;
            var query = new RB_Logistics_Express();
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var list = mallBaseModule.GetLogisticsExpressList(query);
            var result = list.Select(x => new
            {
                x.ID,
                x.Name,
                x.ExpressCode
            });
            return ApiResult.Success("获取成功", result);
        }
        #endregion


        #region 电子面单
        /// <summary>
        /// 获取电子面单分页
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetElectronicSheetPage()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            RB_ElectronicSheet_Extend demodel = JsonConvert.DeserializeObject<RB_ElectronicSheet_Extend>(RequestParm.msg.ToString());
            demodel.TenantId = UserInfo.TenantId;
            demodel.MallBaseId = parms.MallBaseId;
            var list = mallBaseModule.GetElectronicSheetPage(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.ID,
                x.Name,
                x.Account,
                x.Mobile,
                Address = x.ProvinceName + x.CityName + x.DistrictName + x.Address,
                x.IsDefault,
                x.ExpressName,
                x.WebDot,
                x.WebCode
            });
            return ApiResult.Success("", pagelist);
        }


        /// <summary>
        /// 获取电子面单详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetElectronicSheet()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_ElectronicSheet_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var oldLogisticsModel = mallBaseModule.GetElectronicSheetList(query).FirstOrDefault();
            if (oldLogisticsModel == null)
            {
                oldLogisticsModel = new RB_ElectronicSheet_Extend();
            }
            return ApiResult.Success("", oldLogisticsModel);
        }



        /// <summary>
        /// 设置默认电子面单
        /// </summary>
        /// <returns></returns>
        public ApiResult SetLogisticsElectronicSheet()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_ElectronicSheet_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            bool result = mallBaseModule.SetDefaultElectronicSheet(query);

            if (result)
            {
                return ApiResult.Success("默认电子面单设置成功");
            }
            else
            {
                return ApiResult.Failed("默认电子面单设置失败");
            }

        }


        /// <summary>
        /// 保存电子面单
        /// </summary>
        /// <returns></returns>
        public ApiResult AddOrUpdateElectronicSheet()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_ElectronicSheet_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            if (query == null)
            {
                return ApiResult.Failed("请传入电子面单信息");
            }
            else
            {
                if (string.IsNullOrWhiteSpace(query.Name))
                {
                    return ApiResult.Failed("请输入发件人名称");
                }
                if (string.IsNullOrWhiteSpace(query.Mobile))
                {
                    return ApiResult.Failed("请输入发件人电话");
                }
                if (query.ExpressId == 0)
                {
                    return ApiResult.Failed("请选择快递公司");
                }
                if (query.ProvinceId == 0)
                {
                    return ApiResult.Failed("请选择省");
                }
                if (query.CityId == 0)
                {
                    return ApiResult.Failed("请选择市");
                }
                if (query.DistrictId == 0)
                {
                    return ApiResult.Failed("请选择区");
                }
                if (string.IsNullOrWhiteSpace(query.Address))
                {
                    return ApiResult.Failed("请输入发件人详细地址");
                }
                if (query.ID == 0)
                {
                    query.CreateDate = System.DateTime.Now;
                }
                query.UpdateDate = System.DateTime.Now;
                bool result = mallBaseModule.AddOrUpdateElectronicSheet(query);
                if (result)
                {
                    return ApiResult.Success("电子面单保存成功");
                }
                else
                {
                    return ApiResult.Failed("电子面单保存失败");
                }
            }
        }

        /// <summary>
        /// 删除退货地址
        /// </summary>
        /// <returns></returns>
        public ApiResult DelElectronicSheet()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_ElectronicSheet_Extend>(RequestParm.msg.ToString());
            if (query.ID <= 0)
            {
                return ApiResult.Failed("请传递参数");
            }
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            bool flag = mallBaseModule.DelElectronicSheet(query);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }
        #endregion

        #region 上传设置
        public ApiResult GetFileStoreList()
        {
            var parms = RequestParm;
            var query = new RB_File_Store();
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var list = mallBaseModule.GetFileStoreList(query);

            return ApiResult.Success("获取成功", list);
        }

        /// <summary>
        /// 新增/修改上传设置
        /// </summary>
        /// <returns></returns>
        public ApiResult AddOrUpdateFileStore()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_File_Store>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;

            if (query == null)
            {
                return ApiResult.Failed("请传入上传设置信息");
            }
            else
            {
                if ((int)query.StoreType == 0)
                {

                    return ApiResult.Failed("请选择存储位置");

                }

                if (query.ID == 0)
                {
                    query.CreateDate = System.DateTime.Now;
                }
                query.UpdateDate = System.DateTime.Now;
                bool result = mallBaseModule.AddOrUpdateFileStore(query);
                if (result)
                {
                    return ApiResult.Success("上传设置保存成功");
                }
                else
                {
                    return ApiResult.Failed("上传设置保存失败");
                }
            }
        }


        /// <summary>
        /// 获取上传信息的详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetFileStoreDetail()
        {
            var parms = RequestParm;
            var query = new RB_File_Store();
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var model = mallBaseModule.GetFileStoreList(query).FirstOrDefault();
            if (model == null)
            {
                model = new RB_File_Store();
            }
            return ApiResult.Success("获取成功", model);
        }

        #endregion
    }
}