﻿using System;
using System.Collections.Generic;

namespace Mall.Common.Models
{
    /// <summary>
    /// API日志
    /// </summary>
    public class ApiMonitorLog
    {
        /// <summary>
        /// 请求地址
        /// </summary>
        public string Url { get; set; }
        /// <summary>
        /// 控制器名
        /// </summary>
        public string ControllerName { get; set; }
        /// <summary>
        /// 方法名
        /// </summary>
        public string ActionName { get; set; }
        /// <summary>
        /// 开始时间
        /// </summary>
        public DateTime ExecuteStartTime { get; set; }
        /// <summary>
        /// 结束时间
        /// </summary>
        public DateTime ExecuteEndTime { get; set; }
        /// <summary>
        /// 请求地址携带的参数
        /// </summary>
        public string QueryString { get; set; }
        /// <summary>
        /// 请求的Action 参数
        /// </summary>
        public Dictionary<string, object> ActionParams { get; set; }
        /// <summary>
        /// Http请求头
        /// </summary>
        public string HttpRequestHeaders { get; set; }
        /// <summary>
        /// 请求方式
        /// </summary>
        public string HttpMethod { get; set; }
        /// <summary>
        /// 请求的IP地址
        /// </summary>
        public string IP { get; set; }

        /// <summary>
        /// 请求总时间
        /// </summary>
        public double RequestTotalSecond
        {
            get
            {
                return (ExecuteEndTime - ExecuteStartTime).TotalSeconds;
            }
        }
        /// <summary>
        /// 获取监控指标日志
        /// </summary>
        /// <returns></returns>
        public string GetLoginfo()
        {
            string Msg = @"
            Action执行时间监控：
            请求地址：{0}
            ControllerName：{1}Controller
            ActionName:{2}
            开始时间：{3}
            结束时间：{4}
            总 时 间：{5}秒
            请求地址携带参数：{6}
            Action参数：{7}
            Http请求头:{8}
            客户端IP：{9},
            HttpMethod:{10}
                    ";
            return string.Format(Msg,
                Url,
                ControllerName,
                ActionName,
                ExecuteStartTime,
                ExecuteEndTime,
                RequestTotalSecond,
                QueryString,
                GetCollections(ActionParams),
                 HttpRequestHeaders,
                IP,
                HttpMethod);
        }

        /// <summary>
        /// 获取监控指标日志
        /// </summary>
        /// <returns></returns>
        public string GetLoginfo2()
        {
            string Msg = @"
            HKAction执行时间监控：
            开始时间：{0}
            结束时间：{1}
            总 时 间：{2}秒
            客户端IP：{3}
            Action参数：{4}
                    ";
            return string.Format(Msg,
                ExecuteStartTime,
                ExecuteEndTime,
                RequestTotalSecond,
                IP,
                GetCollections(ActionParams)
                );
        }

        /// <summary>
        /// 获取Action 参数
        /// </summary>
        /// <param name="Collections"></param>
        /// <returns></returns>
        public string GetCollections(Dictionary<string, object> Collections)
        {
            string Parameters = string.Empty;
            if (Collections == null || Collections.Count == 0)
            {
                return Parameters;
            }
            foreach (string key in Collections.Keys)
            {
                Parameters += string.Format("{0}={1}&", key, Collections[key]);
            }
            if (!string.IsNullOrWhiteSpace(Parameters) && Parameters.EndsWith("&"))
            {
                Parameters = Parameters.Substring(0, Parameters.Length - 1);
            }
            return Parameters;
        }

        /// <summary>
        /// 获取IP
        /// </summary>
        /// <returns></returns>
        //public string GetIP()
        //{
        //    string ip = string.Empty;
        //    if (!string.IsNullOrEmpty(.HttpContext.Current.Request.ServerVariables["HTTP_VIA"]))
        //        ip = Convert.ToString(System.Web.HttpContext.Current.Request.ServerVariables["HTTP_X_FORWARDED_FOR"]);
        //    if (string.IsNullOrEmpty(ip))
        //        ip = Convert.ToString(System.Web.HttpContext.Current.Request.ServerVariables["REMOTE_ADDR"]);
        //    return ip;
        //}
    }
}