﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.Common.Plugin
{
    /// <summary>
    /// 颜色帮助类
    /// </summary>
    public class ColorHelper
    {
        /// <summary>
        ///颜色数组
        /// </summary>
        private static string[] colorArray = new string[] { "#FFB6C1", "#DC143C", "#FFF0F5", "#DB7093", "#FF1493", "#DA70D6", "#FF00FF", "#800080", "#4B0082", "#7B68EE", "#483D8B", "#0000FF", "#708090", "#1E90FF", "#00BFFF", "#00FFFF", "#7FFFAA", "#32CD32", "#006400", "#EEE8AA", "#8B4513", "#FF4500"};

        /// <summary>
        /// NOPI HSSFColor 索引数组
        /// </summary>
        public static short[] colorIndexArray = new short[] { 45,22,61,40,51,11,13,47,15,43,9,41,44,46,14,24,   26,25,28,29,30,42,55,57,48,8,60,59,58,56,18,62,63,16,53,19,17,21,12,54,23,10,52,50,31,49,20,64};
       
        /// <summary>
        /// 颜色对象列表
        /// </summary>
        public List<ColorModel> ColorList { get; set; }

        /// <summary>
        /// 构造函数
        /// </summary>
        public ColorHelper()
        {
            ColorList = new List<ColorModel>();
        }

        /// <summary>
        /// 获取颜色
        /// </summary>
        /// <param name="ObjValue"></param>
        /// <returns></returns>
        public short GetColor(string ObjValue)
        {
            if (this.ColorList == null)
            {
                this.ColorList = new List<ColorModel>();
            }
            ColorModel model = new ColorModel();
            model = this.ColorList.Where(qitem => qitem.ObjValue == ObjValue).FirstOrDefault();
            if (model == null)
            {
                model = new ColorModel() { ObjIndex = this.ColorList.Count, ColorShortIndex = GetColorStr(), ObjValue = ObjValue };
                this.ColorList.Add(model);
            }
            return model.ColorShortIndex;
        }


        /// <summary>
        /// 生成不重复的颜色
        /// </summary>
        /// <returns></returns>
        public short GetColorStr()
        {
            short colorStr = colorIndexArray[GetRandomNumIndex()];
            while (ColorList.Where(qitem => qitem.ColorShortIndex == colorStr).Count() > 0)
            {
                colorStr = colorIndexArray[GetRandomNumIndex()];
            }
            return colorStr;
        }

        /// <summary>
        /// 生成随机数
        /// </summary>
        /// <returns></returns>
        public static int GetRandomNumIndex()
        {
            Random rd = new Random();
            int num = rd.Next(0, colorIndexArray.Length - 1);
            return num;
        }


        /// <summary>
        /// 生成随机数
        /// </summary>
        /// <returns></returns>
        public static int GetRandomNum()
        {
            Random rd = new Random();
            int num = rd.Next(0, colorArray.Length - 1);
            return num;
        }
    }

    /// <summary>
    /// 颜色帮助实体
    /// </summary>
    public class ColorModel
    {
        /// <summary>
        /// 对象索引
        /// </summary>
        public int ObjIndex { get; set; }

        /// <summary>
        /// 对象值
        /// </summary>
        public string ObjValue { get; set; }

        /// <summary>
        /// 颜色
        /// </summary>
        public short ColorShortIndex { get; set; }
    }
}
