﻿using System; 
using VT.FW.DB;

namespace Mall.Model.Entity.Product
{

    /// <summary>
    /// 拼团活动商品关联规格价格表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Groupbuy_Activity_Specificationprice
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }

        /// <summary>
        /// 商品id
        /// </summary>        
        public int? GoodsId
        {
            get;
            set;
        }

        /// <summary>
        /// 规格值 排序组
        /// </summary>        
        public string SpecificationSort
        {
            get;
            set;
        }

        /// <summary>
        /// 价格
        /// </summary>        
        public decimal? SellingPrice
        {
            get;
            set;
        }

        /// <summary>
        /// 返佣总金额
        /// </summary>        
        public decimal Commission
        {
            get;
            set;
        }

        /// <summary>
        /// 成本价
        /// </summary>        
        public decimal CostMoney
        {
            get;
            set;
        }

        /// <summary>
        /// 库存
        /// </summary>        
        public int? InventoryNum
        {
            get;
            set;
        }

        /// <summary>
        /// 商品重量   克
        /// </summary>        
        public int? GoodsWeight
        {
            get;
            set;
        }

        /// <summary>
        /// 商品货号
        /// </summary>        
        public string GoodsNumbers
        {
            get;
            set;
        }

        /// <summary>
        /// Status
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }


        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }

        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }

        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }

        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }

        /// <summary>
        /// 阶梯编号
        /// </summary>
        public int StepId { get; set; }
    }
}
