﻿using Mall.Common.Plugin;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.Common.Enum.Goods
{
    /// <summary>
    /// 订单售后列表导出选项枚举
    /// </summary>
    public enum OrderAfterSaleExportEnum
    {
        /// <summary>
        /// 所属平台
        /// </summary>
        [EnumField("所属平台")]
        SSPT = 1,
        /// <summary>
        /// 订单号
        /// </summary>
        [EnumField("订单号")]
        DDH = 2,
        /// <summary>
        /// 下单用户
        /// </summary>
        [EnumField("下单用户")]
        XDYH = 4,
        /// <summary>
        /// 商品名
        /// </summary>
        [EnumField("商品名")]
        SPM = 5,
        /// <summary>
        /// 规格
        /// </summary>
        [EnumField("规格")]
        GG = 6,
        /// <summary>
        /// 数量
        /// </summary>
        [EnumField("数量")]
        SL = 7,
        /// <summary>
        /// 货号
        /// </summary>
        [EnumField("货号")]
        HH = 8,
        /// <summary>
        /// 收件人
        /// </summary>
        [EnumField("收件人")]
        SJR = 10,
        /// <summary>
        /// 收件人电话
        /// </summary>
        [EnumField("收件人电话")]
        SJRDH = 11,
        /// <summary>
        /// 收件人地址
        /// </summary>
        [EnumField("收件人地址")]
        SJRDZ = 12,
        /// <summary>
        /// 商家备注
        /// </summary>
        [EnumField("商家备注")]
        ZJE = 13,
        /// <summary>
        /// 售后类型
        /// </summary>
        [EnumField("售后类型")]
        SJFK = 14,
        /// <summary>
        /// 退款金额
        /// </summary>
        [EnumField("退款金额")]
        YF = 15,
        /// <summary>
        /// 申请理由
        /// </summary>
        [EnumField("申请理由")]
        XDSJ = 16,
        /// <summary>
        /// 申请售后时间
        /// </summary>
        [EnumField("申请售后时间")]
        ZFFS = 17,
        /// <summary>
        /// 售后状态
        /// </summary>
        [EnumField("售后状态")]
        DDZT = 18,
        /// <summary>
        /// 用户发货快递
        /// </summary>
        [EnumField("用户发货快递")]
        FKZT = 19,
        /// <summary>
        /// 用户发货快递单号
        /// </summary>
        [EnumField("用户发货快递单号")]
        FKSJ = 20
    }
}
