﻿using Mall.Common.Plugin;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.Common.Enum.Goods
{
    /// <summary>
    /// 订单售后状态枚举
    /// </summary>
    public enum OrderAfterSaleStatusEnum
    {
        /// <summary>
        /// 待审核
        /// </summary>
        [EnumField("待审核")]
        Auditing = 1,
        /// <summary>
        /// 待买家发货
        /// </summary>
        [EnumField("待买家发货")]
        DeliveryToBuyer = 2,
        /// <summary>
        /// 待卖家收货
        /// </summary>
        [EnumField("待卖家收货")]
        ReceivedBySeller = 3,
        /// <summary>
        /// 待卖家退款
        /// </summary>
        [EnumField("待卖家退款")]
        RefundedBySeller = 4,
        /// <summary>
        /// 已完成
        /// </summary>
        [EnumField("已完成")]
        Completed = 5,
        /// <summary>
        /// 已拒绝
        /// </summary>
        [EnumField("已拒绝")]
        Rejected = 6
    }
}
