﻿using DapperExtensions.ValueObject;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Text;
using System.Threading.Tasks;

namespace DapperExtensions.Lambda
{
    /// <summary>
    /// 排序实现泛型类
    /// </summary>
    /// <typeparam name="T">约束</typeparam>
    [Serializable]
    public class OrderBy<T> : OrderBy, IOrderBy<T> where T : class
    {
        /// <summary>
        /// 新增排序
        /// </summary>
        /// <param name="lambdaOrderBy">表达式</param>
        public void AddOrderBy(Expression<Func<T, object>> lambdaOrderBy)
        {
            base.AddOrderBy(ExpressionToClip<T>.ToOrderByClip(lambdaOrderBy));
        }

        /// <summary>
        /// 新增排序
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <param name="lambdaOrderBy">表达式</param>
        public void AddOrderBy<T2>(Expression<Func<T, T2, object>> lambdaOrderBy)
        {
            base.AddOrderBy(ExpressionToClip<T>.ToOrderByClip(lambdaOrderBy));
        }

        /// <summary>
        /// 新增排序
        /// </summary>           
        /// <typeparam name="T2">约束</typeparam>
        /// <typeparam name="T3">约束</typeparam>
        /// <param name="lambdaOrderBy">表达式</param>
        public void AddOrderBy<T2, T3>(Expression<Func<T, T2, T3, object>> lambdaOrderBy)
        {
            base.AddOrderBy(ExpressionToClip<T>.ToOrderByClip(lambdaOrderBy));
        }

        /// <summary>
        /// 新增排序
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <typeparam name="T3">约束</typeparam>
        /// <typeparam name="T4">约束</typeparam>
        /// <param name="lambdaOrderBy">表达式</param>
        public void AddOrderBy<T2, T3, T4>(Expression<Func<T, T2, T3, T4, object>> lambdaOrderBy)
        {
            base.AddOrderBy(ExpressionToClip<T>.ToOrderByClip(lambdaOrderBy));
        }

        /// <summary>
        /// 新增排序
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <typeparam name="T3">约束</typeparam>
        /// <typeparam name="T4">约束</typeparam>
        /// <typeparam name="T5">约束</typeparam>
        /// <param name="lambdaOrderBy">表达式</param>
        public void AddOrderBy<T2, T3, T4, T5>(Expression<Func<T, T2, T3, T4, T5, object>> lambdaOrderBy)
        {
            base.AddOrderBy(ExpressionToClip<T>.ToOrderByClip(lambdaOrderBy));
        }

        /// <summary>
        /// 新增排序
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <typeparam name="T3">约束</typeparam>
        /// <typeparam name="T4">约束</typeparam>
        /// <typeparam name="T5">约束</typeparam>
        /// <typeparam name="T6">约束</typeparam>
        /// <param name="lambdaOrderBy">表达式</param>
        public void AddOrderBy<T2, T3, T4, T5, T6>(Expression<Func<T, T2, T3, T4, T5, T6, object>> lambdaOrderBy)
        {
            base.AddOrderBy(ExpressionToClip<T>.ToOrderByClip(lambdaOrderBy));
        }

        /// <summary>
        /// 添加倒序
        /// </summary>
        /// <param name="lambdaOrderBy">表达式</param>
        public void AddOrderByDescending(Expression<Func<T, object>> lambdaOrderBy)
        {
            base.AddOrderByDescending(ExpressionToClip<T>.ToOrderByClip(lambdaOrderBy, OrderByType.DESC));
        }

        /// <summary>
        /// 添加倒序
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <param name="lambdaOrderBy">表达式</param>
        public void AddOrderByDescending<T2>(Expression<Func<T, T2, object>> lambdaOrderBy)
        {
            base.AddOrderByDescending(ExpressionToClip<T>.ToOrderByClip(lambdaOrderBy, OrderByType.DESC));
        }

        /// <summary>
        /// 添加倒序
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <typeparam name="T3">约束</typeparam>
        /// <param name="lambdaOrderBy">表达式</param>
        public void AddOrderByDescending<T2, T3>(Expression<Func<T, T2, T3, object>> lambdaOrderBy)
        {
            base.AddOrderByDescending(ExpressionToClip<T>.ToOrderByClip(lambdaOrderBy, OrderByType.DESC));
        }

        /// <summary>
        /// 添加倒序
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <typeparam name="T3">约束</typeparam>
        /// <typeparam name="T4">约束</typeparam>
        /// <param name="lambdaOrderBy">表达式</param>
        public void AddOrderByDescending<T2, T3, T4>(Expression<Func<T, T2, T3, T4, object>> lambdaOrderBy)
        {
            base.AddOrderByDescending(ExpressionToClip<T>.ToOrderByClip(lambdaOrderBy, OrderByType.DESC));
        }

        /// <summary>
        /// 添加倒序
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <typeparam name="T3">约束</typeparam>
        /// <typeparam name="T4">约束</typeparam>
        /// <typeparam name="T5">约束</typeparam>
        /// <param name="lambdaOrderBy">表达式</param>
        public void AddOrderByDescending<T2, T3, T4, T5>(Expression<Func<T, T2, T3, T4, T5, object>> lambdaOrderBy)
        {
            base.AddOrderByDescending(ExpressionToClip<T>.ToOrderByClip(lambdaOrderBy, OrderByType.DESC));
        }

        /// <summary>
        /// 添加倒序
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <typeparam name="T3">约束</typeparam>
        /// <typeparam name="T4">约束</typeparam>
        /// <typeparam name="T5">约束</typeparam>
        /// <typeparam name="T6">约束</typeparam>
        /// <param name="lambdaOrderBy">表达式</param>
        public void AddOrderByDescending<T2, T3, T4, T5, T6>(Expression<Func<T, T2, T3, T4, T5, T6, object>> lambdaOrderBy)
        {
            base.AddOrderByDescending(ExpressionToClip<T>.ToOrderByClip(lambdaOrderBy, OrderByType.DESC));
        }
    }

    /// <summary>
    /// 排序实现类
    /// </summary>
    [Serializable]
    public class OrderBy : IOrderBy
    {
        private OrderByClip gb = OrderByClip.None;

        /// <summary>
        /// 新增排序
        /// </summary>
        /// <param name="orderby"></param>
        public void AddOrderBy(OrderByClip orderby)
        {
            gb = gb && orderby;
        }

        /// <summary>
        /// 新增倒序
        /// </summary>
        /// <param name="orderby"></param>
        public void AddOrderByDescending(OrderByClip orderby)
        {
            gb = gb && orderby;
        }

        /// <summary>
        /// 转换
        /// </summary>
        /// <returns></returns>
        public OrderByClip ToOrderByClip()
        {
            return gb;
        }
    }
}
