﻿using Mall.Model.Entity.Property;
using Mall.Model.Extend.Property;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Property
{
    /// <summary>
    /// 采购单仓储类
    /// </summary>
    public partial class RB_Procurement_DetailRepository : RepositoryBase<RB_Procurement_Detail>
    {
        /// <summary>
        /// 获取采购单分页数据
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="dmodel"></param>
        /// <param name="count"></param>
        /// <returns></returns>
        public List<RB_Procurement_Detail_Extend> GetList(RB_Procurement_Detail_Extend dmodel)
        {
            string where = " where 1=1 ";
            where += string.Format(" AND p.{0}={1}", nameof(RB_Procurement_Detail_Extend.Status), 0);
            where += $@" and p.RB_Group_Id={dmodel.RB_Group_Id}";            
            
            if (dmodel.TenantId > 0)
            {
                where += " and p." + nameof(RB_Procurement_Detail_Extend.TenantId) + "=" + dmodel.TenantId;
            }
            if (dmodel.MallBaseId > 0)
            {
                where += " and p." + nameof(RB_Procurement_Detail_Extend.MallBaseId) + "=" + dmodel.MallBaseId;
            }
            if (dmodel.ProcurementId > 0) 
            {
                where += " and p." + nameof(RB_Procurement_Detail_Extend.ProcurementId) + "=" + dmodel.ProcurementId;
            }
            if (!string.IsNullOrEmpty(dmodel.ProcurementIds)) 
            {
                where += " and p." + nameof(RB_Procurement_Detail_Extend.ProcurementId) + " in(" + dmodel.ProcurementIds + ")";
            }
            if (dmodel.MaterialId > 0)
            {
                where += " and p." + nameof(RB_Procurement_Detail_Extend.MaterialId) + "=" + dmodel.MaterialId;
            }

            string sql = $@" SELECT * FROM RB_Procurement_Detail p {where} order by p.Id desc";
            return Get<RB_Procurement_Detail_Extend>(sql).ToList();
        }

    }
}
