﻿using Mall.Common.AOP;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.AppletWeChat
{
    /// <summary>
    /// 微信小程序基础配置
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_AppletWeChat
    {
        public int ID { get; set; }

        /// <summary>
        /// 商户id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }

        public DateTime CreateDate { get; set; }
        public DateTime UpdateDate { get; set; }


        /// <summary>
        /// 小程序AppId
        /// </summary>
        public string AppId { get; set; }
        /// <summary>
        /// 小程序appSecret   
        /// </summary>
        public string AppSecret { get; set; }

        /// <summary>
        /// 微信支付商户号
        /// </summary>
        public string BusinessNO { get; set; }
        /// <summary>
        /// 微信支付Api密钥
        /// </summary>
        public string ApiSecret { get; set; }
        /// <summary>
        /// 微信支付apiclient_cert.pem
        /// </summary>
        public string ApiclientCert { get; set; }
        /// <summary>
        /// 微信支付apiclient_key.pem
        /// </summary>
        public string Apiclientkey { get; set; }
    }
}
