﻿using Mall.Common.AOP;
using Mall.Common.Enum.MarketingCenter;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.MarketingCenter
{
    /// <summary>
    /// 优惠券实体表
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_DiscountCoupon
    {

        public int ID { get; set; }

        /// <summary>
        /// 商户id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }


        public int Status { get; set; }

        public DateTime CreateDate { get; set; }
        public DateTime UpdateDate { get; set; }
        public string Name { get; set; }

        /// <summary>
        /// 有效期类型，1-领取后N天内有效，2-时间段
        /// </summary>
        public IndateTypeEnum IndateType { get; set; }

        /// <summary>
        /// 有效天数
        /// </summary>
        public int IndateDay { get; set; }

        /// <summary>
        /// 可发放数量,-1 无限制
        /// </summary>
        public int TotalNum { get; set; }

        /// <summary>
        /// 描述
        /// </summary>
        public string Describe { get; set; }


        /// <summary>
        /// 领取数量
        /// </summary>
        public int ReceiveNum { get; set; }

        /// <summary>
        /// 有效期开始时间
        /// </summary>
        public DateTime? StartDate { get; set; }

        /// <summary>
        /// 有效期结束时间
        /// </summary>
        public DateTime? EndDate { get; set; }

        /// <summary>
        /// 1-满减券，2-打折券
        /// </summary>
        public CouponTypeEnum CouponType { get; set; }


        /// <summary>
        ///排序
        /// </summary>
        public int Sort { get; set; }


        /// <summary>
        /// 1-指定商品类型，2-指定商品，3-全场通用，4-当面付
        /// </summary>
        public UseTypeEnum UseType { get; set; }


        /// <summary>
        /// 最低消费金额（元）
        /// </summary>
        public decimal MinConsumePrice { get; set; }


        /// <summary>
        /// 优惠金额/折扣
        /// </summary>
        public decimal DiscountsPrice { get; set; }


        /// <summary>
        ///最多优惠（元）
        /// </summary>
        public decimal MaxDiscountsPrice { get; set; }


        /// <summary>
        /// 领取方式设置2-领劵中心
        /// </summary>
        public int PickupCenter { get; set; }

        /// <summary>
        /// 1-会员专享
        /// </summary>
        public int OnlyMember { get; set; }
        /// <summary>
        /// 会员专享
        /// </summary>

        public string MemberLevel { get; set; }
    }
}
