﻿using Mall.Common.AOP;
using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;

namespace Mall.Model.Extend.Product
{
    /// <summary>
    /// 商品表扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Goods_Extend : RB_Goods
    {
        /// <summary>
        /// 排序
        /// </summary>
        public int? OrderBy { get; set; }
        /// <summary>
        /// 开始时间
        /// </summary>
        public string StartTime { get; set; }
        /// <summary>
        /// 结束时间
        /// </summary>
        public string EndTime { get; set; }
        /// <summary>
        /// 是否查询售罄   1是  其他否
        /// </summary>
        public int? IsSelectSellOut { get; set; }
        /// <summary>
        /// 分类ids
        /// </summary>
        public string CategoryIds { get; set; }
        /// <summary>
        /// 商品ids
        /// </summary>
        public string GoodsIds { get; set; }
        /// <summary>
        /// 封面图
        /// </summary>
        public string CoverImage { get; set; }
        /// <summary>
        /// 自定义分享图片
        /// </summary>
        public string CustomShareImagePath { get; set; }
        /// <summary>
        /// 运费名称
        /// </summary>
        public string FreightName { get; set; }
        /// <summary>
        /// 表单名称
        /// </summary>
        public string FormsName { get; set; }
        /// <summary>
        /// 轮播图列表
        /// </summary>
        public List<RB_ImageCommonModel> CarouselImageList { get; set; }
        /// <summary>
        /// 服务列表
        /// </summary>
        public List<RB_ImageCommonModel> ServiceList { get; set; }
        /// <summary>
        /// 商品分类
        /// </summary>
        public List<RB_Goods_Category_Extend> CategoryList { get; set; }
        /// <summary>
        /// 区域列表
        /// </summary>
        public List<RB_Goods_Area_Extend> AreaList { get; set; }
        /// <summary>
        /// 规格名列表
        /// </summary>
        public List<RB_Goods_Specification_Extend> SpecificationList { get; set; }        
        /// <summary>
        /// 规格价格列表
        /// </summary>
        public List<RB_Goods_SpecificationPrice_Extend> SpecificationPriceList { get; set; }
        /// <summary>
        /// 分销佣金列表
        /// </summary>
        public List<RB_Goods_DistributionCommission_Extend> DistributionCommissionList { get; set; }
        /// <summary>
        /// 会员价格列表
        /// </summary>
        public List<RB_Goods_MemberPrice_Extend> MemberPriceList { get; set; }

    }
}
