﻿using Mall.Common.AOP;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Extend.User
{
    /// <summary>
    /// 小程序扩展实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_MiniProgram_Extend : Model.Entity.User.RB_MiniProgram
    {
        /// <summary>
        /// 账号
        /// </summary>
        public string Account { get; set; }

        /// <summary>
        /// 手机号码
        /// </summary>
        public string MobilePhone { get; set; }

        /// <summary>
        /// 小程序有效期
        /// </summary>
        public string EffectiveDateStr
        {
            get
            {
                string str = "";
                if (this.IsEffective != null && this.IsEffective == 1)
                {
                    str = "永久有效";
                }
                else
                {
                    if (this.MallValidate != null)
                    {
                        str = Convert.ToDateTime(this.MallValidate).ToString("yyyy-MM-dd");
                    }
                }
                return str;
            }
        }

        /// <summary>
        /// 状态字符串
        /// </summary>
        public string StatusStr
        {
            get
            {
                string str = "正常";
                if (this.Status == 1)
                {
                    str = "禁用";
                }
                return str;
            }
        }

        /// <summary>
        /// 底部导航列表
        /// </summary>
        public List<RB_Miniprogram_Bottomnav_Extend> BottomTagList { get; set; }

        /// <summary>
        /// 小程序用户中心【收藏、足迹】菜单列表
        /// </summary>
        public List<RB_MiniProgram_UserCenterMenu_Extend> FavoriteFootMenuList { get; set; }

        /// <summary>
        /// 小程序用户中心【订单】菜单列表
        /// </summary>
        public List<RB_MiniProgram_UserCenterMenu_Extend> OrderMenuList { get; set; }

        /// <summary>
        /// 小程序用户中心【账户】菜单列表
        /// </summary>
        public List<RB_MiniProgram_UserCenterMenu_Extend> AccountMenuList { get; set; }

        /// <summary>
        /// 小程序用户中心【自定义】菜单列表
        /// </summary>
        public List<RB_MiniProgram_UserCenterMenu_Extend> SelfMenuList { get; set; }
    }
}
