﻿using Mall.Common.Plugin;
using Mall.Model.Entity.MarketingCenter;
using Mall.Model.Entity.User;
using Mall.Model.Extend.MarketingCenter;
using Mall.Model.Extend.User;
using Mall.Model.Query;
using Mall.Repository;
using Mall.Repository.MarketingCenter;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Module.MarketingCenter
{
    public class CouponModule
    {
        private RB_CouponRepository couponRepository = new RB_CouponRepository();
        private RB_DiscountCouponRepository discountCouponRepository = new RB_DiscountCouponRepository();
        private RB_DiscountCoupon_ProductRepository productRepository = new RB_DiscountCoupon_ProductRepository();


        private Repository.User.RB_Member_CouponRepository memberCouponRepository = new Repository.User.RB_Member_CouponRepository();
        private RB_Coupon_SelfMotionMemberRepository selfMotionMemberRepository = new RB_Coupon_SelfMotionMemberRepository();

        private RB_Coupon_SelfMotionRepository selfMotionRepository = new RB_Coupon_SelfMotionRepository();

        #region 卡券列表
        /// <summary>
        /// 卡券信息列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Coupon_Extend> GetCouponPageList(int pageIndex, int pageSize, out long rowCount, RB_Coupon_Extend query)
        {
            return couponRepository.GetCouponPageList(pageIndex, pageSize, out rowCount, query);
        }

        /// <summary>
        /// 卡券信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Coupon_Extend> GetCouponList(RB_Coupon_Extend query)
        {
            return couponRepository.GetCouponList(query);

        }

        public bool AddOrUpdateCoupon(RB_Coupon_Extend model)
        {
            if (model.ID == 0)
            {
                return couponRepository.Insert(model) > 0;
            }
            else
            {
                return couponRepository.Update(model);
            }
        }


        /// <summary>
        /// 删除卡券
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool DelCoupon(int id, int uid, int mallBaseId)
        {
            try
            {
                Dictionary<string, object> cols = new Dictionary<string, object>()
                {
                    { nameof(RB_Coupon.Status),1},
                    { nameof(RB_Coupon.UpdateDate),DateTime.Now},
                };
                List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Coupon.ID),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Coupon.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Coupon.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
            };
                return couponRepository.Update(cols, wheres1);

            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "DelCoupon");
                return false;
            }
        }



        #endregion

        #region 优惠券
        /// <summary>
        /// 优惠券信息列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_DiscountCoupon_Extend> GetDiscountCouponPageList(int pageIndex, int pageSize, out long rowCount, RB_DiscountCoupon_Extend query)
        {
            return discountCouponRepository.GetDiscountCouponPageList(pageIndex, pageSize, out rowCount, query);
        }

        /// <summary>
        /// 优惠券信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_DiscountCoupon_Extend> GetDiscountCouponList(RB_DiscountCoupon_Extend query)
        {
            var list = discountCouponRepository.GetDiscountCouponList(query);
            if (list != null && list.Any())
            {

                string Ids = string.Join(",", list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Category || x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Product).Select(x => x.ID));
                var listProduct = productRepository.GetListByDiscountCouponIds(query, Ids);
                foreach (var item in list)
                {
                    item.ProductList = new List<RB_DiscountCoupon_Product_Extend>();
                    item.ProductList = listProduct.Where(x => x.DiscountCouponId == item.ID).ToList();
                }
            }
            return list;

        }

        /// <summary>
        /// 新增/修改优惠券
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateDiscountCoupon(RB_DiscountCoupon_Extend model)
        {
            bool flag = false;
            var trans = discountCouponRepository.DbTransaction;
            try
            {
                int id = 0;
                if (model.ID == 0)
                {
                    id = discountCouponRepository.Insert(model, trans);
                    if (id > 0 && model.ProductList != null && model.ProductList.Any())
                    {
                        model.ProductList.ForEach(x => x.MallBaseId = model.MallBaseId);
                        model.ProductList.ForEach(x => x.TenantId = model.TenantId);
                        model.ProductList.ForEach(x => x.CreateDate = model.CreateDate);
                        model.ProductList.ForEach(x => x.UpdateDate = model.UpdateDate);
                        model.ProductList.ForEach(x => x.DiscountCouponId = id);
                        flag = productRepository.InsertBatch(model.ProductList, trans);
                    }
                    flag = id > 0;
                }
                else
                {
                    id = model.ID;
                    flag = discountCouponRepository.Update(model, trans);
                    var listProduct = productRepository.GetCouponProductList(new RB_DiscountCoupon_Product { TenantId = model.TenantId, MallBaseId = model.MallBaseId, DiscountCouponId = id });
                    if (listProduct != null && listProduct.Any())
                    {
                        foreach (var item in model.ProductList)
                        {
                            IDictionary<string, object> fileds = new Dictionary<string, object>()
                         {
                            { nameof(RB_DiscountCoupon_Product.Status),1},
                             { nameof(RB_DiscountCoupon_Product.UpdateDate),model.UpdateDate},
                          };
                            IList<WhereHelper> whereHelpers = new List<WhereHelper>()
                        {
                            new WhereHelper (){ FiledName=nameof(RB_DiscountCoupon_Product.ID),FiledValue=item.ID,OperatorEnum=OperatorEnum.Equal}
                        };
                            flag = productRepository.Update(fileds, whereHelpers, trans);
                        }
                    }

                    if (model.ProductList != null && model.ProductList.Any())
                    {
                        model.ProductList.ForEach(x => x.MallBaseId = model.MallBaseId);
                        model.ProductList.ForEach(x => x.TenantId = model.TenantId);
                        model.ProductList.ForEach(x => x.CreateDate = model.CreateDate);
                        model.ProductList.ForEach(x => x.UpdateDate = model.UpdateDate);
                        model.ProductList.ForEach(x => x.DiscountCouponId = id);
                        flag = productRepository.InsertBatch(model.ProductList, trans);
                    }
                }
                discountCouponRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "AddOrUpdateDiscountCoupon");
                discountCouponRepository.DBSession.Rollback("AddOrUpdateDiscountCoupon");
                return false;
            }
            return flag;
        }

        /// <summary>
        /// 删除优惠券
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool DelDiscountCoupon(int id, int uid, int mallBaseId)
        {
            bool flag = false;
            var trans = discountCouponRepository.DbTransaction;
            try
            {
                Dictionary<string, object> cols1 = new Dictionary<string, object>()
                    {
                        { nameof(RB_DiscountCoupon.Status),1},
                        { nameof(RB_DiscountCoupon.UpdateDate),DateTime.Now},
                    };
                List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_DiscountCoupon.ID),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_DiscountCoupon.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_DiscountCoupon.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
                };
                flag = discountCouponRepository.Update(cols1, wheres1);

                Dictionary<string, object> cols = new Dictionary<string, object>()
                    {
                        { nameof(RB_DiscountCoupon_Product.Status),1},
                        { nameof(RB_DiscountCoupon_Product.UpdateDate),DateTime.Now},
                    };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_DiscountCoupon_Product.DiscountCouponId),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_DiscountCoupon_Product.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_DiscountCoupon_Product.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
                };
                 productRepository.Update(cols, wheres);


                discountCouponRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "DelDiscountCoupon");
                discountCouponRepository.DBSession.Rollback("DelDiscountCoupon");
                return false;
            }
            return flag;
        }

        /// <summary>
        /// 领劵中心
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool UpdatePickupType(int id, int uid, int mallBaseId)
        {
            try
            {
                var model = discountCouponRepository.GetEntity(id);

                Dictionary<string, object> cols1 = new Dictionary<string, object>()
                    {
                        { nameof(RB_DiscountCoupon.PickupCenter),model.PickupCenter==0?1:0},
                        { nameof(RB_DiscountCoupon.UpdateDate),DateTime.Now},
                    };
                List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_DiscountCoupon.ID),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_DiscountCoupon.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_DiscountCoupon.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
                };
                return discountCouponRepository.Update(cols1, wheres1);


            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "UpdatePickupType");
                return false;
            }
        }



        /// <summary>
        /// 发放优惠券
        /// </summary>
        /// <param name="list"></param>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool GrantCoupon(List<RB_Member_DiscountCoupon> list, RB_DiscountCoupon_Extend model)
        {
            bool flag = false;
            var trans = memberCouponRepository.DbTransaction;
            try
            {

                flag = memberCouponRepository.InsertBatch(list);
                if (model != null && flag)
                {
                    Dictionary<string, object> cols1 = new Dictionary<string, object>()
                    {
                        { nameof(RB_DiscountCoupon.ReceiveNum),model.ReceiveNum+list.Count()},
                        { nameof(RB_DiscountCoupon.UpdateDate),DateTime.Now},
                    };
                    List<WhereHelper> wheres1 = new List<WhereHelper>()
                    {
                    new WhereHelper(){
                            FiledName=nameof(RB_DiscountCoupon.ID),
                            FiledValue=model.ID,
                            OperatorEnum=OperatorEnum.Equal
                    },
                    new WhereHelper(){
                            FiledName=nameof(RB_DiscountCoupon.TenantId),
                            FiledValue=model.TenantId,
                            OperatorEnum=OperatorEnum.Equal
                    },
                    new WhereHelper(){
                            FiledName=nameof(RB_DiscountCoupon.MallBaseId),
                            FiledValue=model.MallBaseId,
                            OperatorEnum=OperatorEnum.Equal
                    }
                    };
                    flag = discountCouponRepository.Update(cols1, wheres1);
                }
                memberCouponRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "GrantCoupon");
                memberCouponRepository.DBSession.Rollback("GrantCoupon");
                return false;
            }
            return flag;
        }
        #endregion

        #region 自动发放优惠券规则
        /// <summary>
        /// 自动发放优惠券规则列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Coupon_SelfMotion_Extend> GetSelfMotionPageLis(int pageIndex, int pageSize, out long rowCount, RB_Coupon_SelfMotion_Extend query)
        {
            return selfMotionRepository.GetSelfMotionPageLis(pageIndex, pageSize, out rowCount, query);
        }

        /// <summary>
        /// 自动发放优惠券规则列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Coupon_SelfMotion_Extend> GettRepositoryList(RB_Coupon_SelfMotion_Extend query)
        {
            return selfMotionRepository.GettRepositoryList(query);
        }

        /// <summary>
        /// 新增/修改自动发放优惠券
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateSelfMotion(RB_Coupon_SelfMotion_Extend model)
        {
            bool flag = false;
            var trans = selfMotionRepository.DbTransaction;
            try
            {
                int id = 0;
                if (model.ID == 0)
                {
                    id = selfMotionRepository.Insert(model, trans);
                    if (id > 0 && model.UserList != null && model.UserList.Any())
                    {
                        model.UserList.ForEach(x => x.MallBaseId = model.MallBaseId);
                        model.UserList.ForEach(x => x.TenantId = model.TenantId);
                        model.UserList.ForEach(x => x.CreateDate = model.CreateDate);
                        model.UserList.ForEach(x => x.UpdateDate = model.UpdateDate);
                        model.UserList.ForEach(x => x.SelfMotionId = id);
                        flag = selfMotionMemberRepository.InsertBatch(model.UserList, trans);
                    }
                    flag = id > 0;
                }
                else
                {
                    id = model.ID;
                    flag = selfMotionRepository.Update(model, trans);
                    var listProduct = selfMotionMemberRepository.GetListRepository(new RB_Coupon_SelfMotionMember_Extend { TenantId = model.TenantId, MallBaseId = model.MallBaseId, SelfMotionId = id });
                    if (listProduct != null && listProduct.Any())
                    {
                        foreach (var item in model.UserList)
                        {
                            IDictionary<string, object> fileds = new Dictionary<string, object>()
                         {
                            { nameof(RB_Coupon_SelfMotionMember.Status),1},
                             { nameof(RB_Coupon_SelfMotionMember.UpdateDate),model.UpdateDate},
                          };
                            IList<WhereHelper> whereHelpers = new List<WhereHelper>()
                        {
                            new WhereHelper (){ FiledName=nameof(RB_Coupon_SelfMotionMember.ID),FiledValue=item.ID,OperatorEnum=OperatorEnum.Equal}
                        };
                            flag = productRepository.Update(fileds, whereHelpers, trans);
                        }
                    }

                    if (model.UserList != null && model.UserList.Any())
                    {
                        model.UserList.ForEach(x => x.MallBaseId = model.MallBaseId);
                        model.UserList.ForEach(x => x.TenantId = model.TenantId);
                        model.UserList.ForEach(x => x.CreateDate = model.CreateDate);
                        model.UserList.ForEach(x => x.UpdateDate = model.UpdateDate);
                        model.UserList.ForEach(x => x.SelfMotionId = id);
                        flag = selfMotionMemberRepository.InsertBatch(model.UserList, trans);
                    }
                }
                selfMotionRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "AddOrUpdateSelfMotion");
                selfMotionRepository.DBSession.Rollback("AddOrUpdateSelfMotion");
                return false;
            }
            return flag;
        }

        /// <summary>
        /// 删除自动发放优惠券
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool DelDiscountSelfMotion(int id, int uid, int mallBaseId)
        {
            bool flag = false;
            var trans = selfMotionRepository.DbTransaction;
            try
            {
                Dictionary<string, object> cols1 = new Dictionary<string, object>()
                    {
                        { nameof(RB_Coupon_SelfMotion.Status),1},
                        { nameof(RB_Coupon_SelfMotion.UpdateDate),DateTime.Now},
                    };
                List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Coupon_SelfMotion.ID),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Coupon_SelfMotion.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Coupon_SelfMotion.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
                };
                flag = selfMotionRepository.Update(cols1, wheres1);

                Dictionary<string, object> cols = new Dictionary<string, object>()
                    {
                        { nameof(RB_Coupon_SelfMotionMember.Status),1},
                        { nameof(RB_Coupon_SelfMotionMember.UpdateDate),DateTime.Now},
                    };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Coupon_SelfMotionMember.SelfMotionId),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Coupon_SelfMotionMember.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Coupon_SelfMotionMember.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
                };
                flag = selfMotionMemberRepository.Update(cols, wheres);


                selfMotionRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "DelDiscountSelfMotion");
                selfMotionRepository.DBSession.Rollback("DelDiscountSelfMotion");
                return false;
            }
            return flag;
        }


        #endregion


        #region 优惠券发放统计


        /// <summary>
        /// 数据统计-积分收支
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<MemberCoupon_Query> GetCouponStatisticslList(int pageIndex, int pageSize, out long rowCount, MemberCoupon_Query query)
        {
            return memberCouponRepository.GetCouponStatisticslList(pageIndex, pageSize, out rowCount, query);
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Member_DiscountCoupon_Extend> GetTotalIntegral(RB_Member_DiscountCoupon_Extend dmodel)
        {
            return memberCouponRepository.GetExportIntegraStatisticslList(dmodel);

        }

        /// <summary>
        /// 数据统计-积分收支
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<MemberCoupon_Query> GetExportCouponStatisticslList(MemberCoupon_Query query)
        {
            return memberCouponRepository.GetExportCouponStatisticslList(query);
        }
        #endregion 

    }
}
