﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Common;
using Mall.Common.API;
using Mall.Common.Plugin;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using Mall.Model.Extend.User;
using Mall.Repository;
using Mall.Repository.BaseSetUp;
using Mall.Repository.Product;
using Mall.Repository.User;
using Newtonsoft.Json;

namespace Mall.Module.Product
{
    /// <summary>
    /// 商品处理层
    /// </summary>
    public class ProductModule
    {
        /// <summary>
        /// 素材分组
        /// </summary>
        private readonly RB_Material_GroupRepository material_GroupRepository = new RB_Material_GroupRepository();
        /// <summary>
        /// 素材管理
        /// </summary>
        private readonly RB_Material_InfoRepository material_InfoRepository = new RB_Material_InfoRepository();
        /// <summary>
        /// 商品分类
        /// </summary>
        private readonly RB_Product_CategoryRepository product_CategoryRepository = new RB_Product_CategoryRepository();
        /// <summary>
        /// 商品分类样式
        /// </summary>
        private readonly RB_Product_CategoryStyleRepository product_CategoryStyleRepository = new RB_Product_CategoryStyleRepository();
        /// <summary>
        /// 商品规格
        /// </summary>
        private readonly RB_Product_SpecificationRepository product_SpecificationRepository = new RB_Product_SpecificationRepository();
        /// <summary>
        /// 快速购买
        /// </summary>
        private readonly RB_Product_QuickBuyRepository product_QuickBuyRepository = new RB_Product_QuickBuyRepository();
        /// <summary>
        /// 推荐设置
        /// </summary>
        private readonly RB_Product_RecommendRepository product_RecommendRepository = new RB_Product_RecommendRepository();
        /// <summary>
        /// 商品服务
        /// </summary>
        private readonly RB_Product_ServiceRepository product_ServiceRepository = new RB_Product_ServiceRepository();
        /// <summary>
        /// 商品
        /// </summary>
        private readonly RB_GoodsRepository goodsRepository = new RB_GoodsRepository();
        /// <summary>
        /// 商品区域
        /// </summary>
        private readonly RB_Goods_AreaRepository goods_AreaRepository = new RB_Goods_AreaRepository();
        /// <summary>
        /// 商品分类
        /// </summary>
        private readonly RB_Goods_CategoryRepository goods_CategoryRepository = new RB_Goods_CategoryRepository();
        /// <summary>
        /// 商品规格
        /// </summary>
        private readonly RB_Goods_SpecificationRepository goods_SpecificationRepository = new RB_Goods_SpecificationRepository();
        /// <summary>
        /// 商品规格值
        /// </summary>
        private readonly RB_Goods_SpecificationValueRepository goods_SpecificationValueRepository = new RB_Goods_SpecificationValueRepository();
        /// <summary>
        /// 商品规格价格
        /// </summary>
        private readonly RB_Goods_SpecificationPriceRepository goods_SpecificationPriceRepository = new RB_Goods_SpecificationPriceRepository();
        /// <summary>
        /// 分销商等级
        /// </summary>
        private readonly RB_Distributor_GradeRepository distributor_GradeRepository = new RB_Distributor_GradeRepository();
        /// <summary>
        /// 会员等级
        /// </summary>
        private readonly RB_Member_GradeRepository member_GradeRepository = new RB_Member_GradeRepository();
        /// <summary>
        /// 商品分销佣金
        /// </summary>
        private readonly RB_Goods_DistributionCommissionRepository goods_DistributionCommissionRepository = new RB_Goods_DistributionCommissionRepository();
        /// <summary>
        /// 商品会员价格
        /// </summary>
        private readonly RB_Goods_MemberPriceRepository goods_MemberPriceRepository = new RB_Goods_MemberPriceRepository();
        /// <summary>
        /// 运费
        /// </summary>
        private readonly RB_Logistics_RulesRepository logistics_RulesRepository = new RB_Logistics_RulesRepository();



        #region 小程序接口

        /// <summary>
        /// 获取小程序商品列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Goods_Extend> GetAppletGoodsPageList(int pageIndex, int pageSize, out long count, RB_Goods_Extend demodel)
        {
            var list = goodsRepository.GetAppletGoodsPageList(pageIndex, pageSize, out count, demodel);
            if (list.Any())
            {
                foreach (var item in list)
                {
                    item.CoverImage = "";
                    if (!string.IsNullOrEmpty(item.CarouselImage) && item.CarouselImage != "[]")
                    {
                        List<int> CarouselIdList = JsonConvert.DeserializeObject<List<int>>(item.CarouselImage);
                        //封面图
                        item.CoverImage = material_InfoRepository.GetEntity(CarouselIdList[0])?.Path ?? "";
                    }
                }
            }
            return list;
        }

        /// <summary>
        /// 获取小程序商品详情
        /// </summary>
        /// <param name="goodsId"></param>
        /// <param name="TenantId"></param>
        /// <param name="MallBaseId"></param>
        /// <returns></returns>
        public RB_Goods_Extend GetAppletGoodsInfo(int goodsId, int TenantId, int MallBaseId)
        {
            var model = goodsRepository.GetEntity(goodsId).RefMapperTo<RB_Goods_Extend>();
            if (model == null || model.TenantId != TenantId || model.MallBaseId != MallBaseId)
            {
                return null;
            }
            model.SpecificationList = new List<RB_Goods_Specification_Extend>();
            model.SpecificationPriceList = new List<RB_Goods_SpecificationPrice_Extend>();
            if (model.IsCustomSpecification == 1)
            {
                model.SpecificationList = goods_SpecificationRepository.GetList(new RB_Goods_Specification_Extend() { GoodsId = goodsId, TenantId = TenantId, MallBaseId = MallBaseId });
                if (model.SpecificationList.Any())
                {
                    var svlist = goods_SpecificationValueRepository.GetList(new RB_Goods_SpecificationValue_Extend() { GoodsId = goodsId, TenantId = TenantId, MallBaseId = MallBaseId });
                    if (svlist.Where(x => x.Image > 0).Any())
                    {
                        string imgIds = string.Join(",", svlist.Where(x => x.Image > 0).Select(x => x.Image).Distinct());
                        var mlist = material_InfoRepository.GetList(new RB_Material_Info_Extend() { MaterialIds = imgIds, TenantId = TenantId, MallBaseId = MallBaseId });
                        foreach (var item in svlist.Where(x => x.Image > 0))
                        {
                            item.ImagePath = mlist.Where(x => x.Id == item.Image).FirstOrDefault()?.Path ?? "";
                        }
                    }
                    foreach (var item in model.SpecificationList)
                    {
                        item.SpecificationValueList = svlist.Where(x => x.SpecificationId == item.Id).ToList();
                    }
                }
                model.SpecificationPriceList = goods_SpecificationPriceRepository.GetList(new RB_Goods_SpecificationPrice_Extend() { GoodsId = goodsId, TenantId = TenantId, MallBaseId = MallBaseId });
            }
            model.AreaList = new List<RB_Goods_Area_Extend>();
            if (model.IsAreaBuy == 1)
            {
                model.AreaList = goods_AreaRepository.GetList(new RB_Goods_Area_Extend() { GoodsId = goodsId, TenantId = TenantId, MallBaseId = MallBaseId });
            }
            model.DistributionCommissionList = new List<RB_Goods_DistributionCommission_Extend>();
            if (model.SeparateDistribution == 1)
            {
                model.DistributionCommissionList = goods_DistributionCommissionRepository.GetList(new RB_Goods_DistributionCommission_Extend() { GoodsId = goodsId, TenantId = TenantId, MallBaseId = MallBaseId });
            }
            model.MemberPriceList = new List<RB_Goods_MemberPrice_Extend>();
            if (model.EnjoyMember == 1 && model.SeparateSetMember == 1)
            {
                model.MemberPriceList = goods_MemberPriceRepository.GetList(new RB_Goods_MemberPrice_Extend() { GoodsId = goodsId, TenantId = TenantId, MallBaseId = MallBaseId });
            }
            model.CarouselImageList = new List<RB_ImageCommonModel>();
            if (!string.IsNullOrEmpty(model.CarouselImage) && model.CarouselImage != "[]")
            {
                List<int> CarouselIdList = JsonConvert.DeserializeObject<List<int>>(model.CarouselImage);
                //轮播图
                var mlist = material_InfoRepository.GetList(new RB_Material_Info_Extend() { MaterialIds = string.Join(",", CarouselIdList), TenantId = TenantId, MallBaseId = MallBaseId });
                foreach (var item in CarouselIdList)
                {
                    var cmodel = mlist.Where(x => x.Id == item).FirstOrDefault();
                    model.CarouselImageList.Add(new RB_ImageCommonModel()
                    {
                        Id = item,
                        Name = cmodel?.Name ?? "",
                        Path = cmodel?.Path ?? ""
                    });
                }
            }
            if (model.CustomShareImage > 0)
            {
                model.CustomShareImagePath = material_InfoRepository.GetEntity(model.CustomShareImage)?.Path ?? "";
            }
            //服务列表
            model.ServiceList = new List<RB_ImageCommonModel>();
            if (model.IsDefaultService == 2)
            {
                if (!string.IsNullOrEmpty(model.GoodsService) && model.GoodsService != "[]")
                {
                    List<int> ServiceIds = JsonConvert.DeserializeObject<List<int>>(model.GoodsService);
                    var slist = product_ServiceRepository.GetList(new RB_Product_Service_Extend() { ServiceIds = string.Join(",", ServiceIds), TenantId = TenantId, MallBaseId = MallBaseId });
                    foreach (var item in slist)
                    {
                        model.ServiceList.Add(new RB_ImageCommonModel()
                        {
                            Id = item.Id,
                            Name = item.Name
                        });
                    }
                }
            }
            else if (model.IsDefaultService == 1) {
                var slist = product_ServiceRepository.GetList(new RB_Product_Service_Extend() { IsDefault = 1, TenantId = TenantId, MallBaseId = MallBaseId });
                foreach (var item in slist)
                {
                    model.ServiceList.Add(new RB_ImageCommonModel()
                    {
                        Id = item.Id,
                        Name = item.Name
                    });
                }
            }

            //运费
            if (model.FreightId > 0)
            {
                model.FreightName = logistics_RulesRepository.GetEntity(model.FreightId)?.RulesName ?? "";
            }
            else
            {
                model.FreightName = "默认运费";
            }
            //表单
            if (model.FormsId > 0)
            {
                model.FormsName = "未建表";
            }
            else
            {
                model.FormsName = "默认表单";
            }

            return model;
        }
        #endregion


        #region 素材管理
        /// <summary>
        /// 获取素材分组列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Material_Group_Extend> GetMaterialGroupList(RB_Material_Group_Extend dmodel) {
            var list= material_GroupRepository.GetList(dmodel);
            return list;
        }


        /// <summary>
        /// 获取素材分组分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Material_Info_Extend> GetMaterialInfoPageList(int pageIndex, int pageSize, out long count, RB_Material_Info_Extend dmodel)
        {
            var list = material_InfoRepository.GetPageList(pageIndex, pageSize, out count, dmodel);
            return list;
        }

        /// <summary>
        /// 新增分组
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetMaterialGroupInfo(RB_Material_Group_Extend demodel)
        {
            if (demodel.Id > 0)
            {
                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Material_Group.Name),demodel.Name},
                    { nameof(RB_Material_Group.Sort),demodel.Sort},
                    { nameof(RB_Material_Group.UpdateDate),demodel.UpdateDate},
                };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                    new WhereHelper(){
                     FiledName=nameof(RB_Material_Group.Id),
                      FiledValue=demodel.Id,
                       OperatorEnum=OperatorEnum.Equal
                    }
                };
                return material_GroupRepository.Update(keyValues, wheres);
            }
            else {
                return material_GroupRepository.Insert(demodel) > 0;
            }
        }

        /// <summary>
        /// 设置素材信息
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetMaterialInfo(RB_Material_Info_Extend demodel)
        {
            if (demodel.Id > 0)
            {
                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Material_Info.Name),demodel.Name},
                    { nameof(RB_Material_Info.UpdateDate),demodel.UpdateDate},
                };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                    new WhereHelper(){
                     FiledName=nameof(RB_Material_Group.Id),
                      FiledValue=demodel.Id,
                       OperatorEnum=OperatorEnum.Equal
                    }
                };
                return material_InfoRepository.Update(keyValues, wheres);
            }
            else {
                return material_InfoRepository.Insert(demodel) > 0;
            }
        }

        /// <summary>
        /// 设置分组回收
        /// </summary>
        /// <param name="groupId"></param>
        /// <param name="uid"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool SetMaterialGroupRecycled(int groupId, string uid, int mallBaseId)
        {
            var gmodel = material_GroupRepository.GetEntity(groupId);
            if (gmodel == null) {
                return false;
            }
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Material_Group.Recycled),2},
                { nameof(RB_Material_Group.UpdateDate),DateTime.Now},
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                    FiledName=nameof(RB_Material_Group.Id),
                    FiledValue=groupId,
                    OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                    FiledName=nameof(RB_Material_Group.TenantId),
                    FiledValue=Convert.ToInt32(uid),
                    OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                    FiledName=nameof(RB_Material_Group.MallBaseId),
                    FiledValue=mallBaseId,
                    OperatorEnum=OperatorEnum.Equal
                },
            };
            bool flag = material_GroupRepository.Update(keyValues, wheres);
            if (flag) {
                //分组下所有素材全回收
                material_InfoRepository.SetMaterialInfoRecycled(groupId, Convert.ToInt32(uid), mallBaseId);
            }
            return flag;
        }

        /// <summary>
        /// 删除分组
        /// </summary>
        /// <param name="groupId"></param>
        /// <param name="uid"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool DelMaterialGroupInfo(int groupId, string uid, int mallBaseId)
        {
            var gmodel = material_GroupRepository.GetEntity(groupId);
            if (gmodel == null)
            {
                return false;
            }
            if (gmodel.Recycled != 2) {
                return false;
            }
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Material_Group.Status),1},
                { nameof(RB_Material_Group.UpdateDate),DateTime.Now},
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                    FiledName=nameof(RB_Material_Group.Id),
                    FiledValue=groupId,
                    OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                    FiledName=nameof(RB_Material_Group.TenantId),
                    FiledValue=Convert.ToInt32(uid),
                    OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                    FiledName=nameof(RB_Material_Group.MallBaseId),
                    FiledValue=mallBaseId,
                    OperatorEnum=OperatorEnum.Equal
                },
            };
            bool flag = material_GroupRepository.Update(keyValues, wheres);
            if (flag) {
                //删除分组下所有的素材
                material_InfoRepository.DelMaterialInfo("", uid, mallBaseId, groupId);
            }
            return flag;
        }

        /// <summary>
        /// 设置分组还原
        /// </summary>
        /// <param name="groupId"></param>
        /// <param name="uid"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool SetMaterialGroupRestore(int groupId, string uid, int mallBaseId)
        {
            var gmodel = material_GroupRepository.GetEntity(groupId);
            if (gmodel == null)
            {
                return false;
            }
            if (gmodel.Recycled != 2)
            {
                return false;
            }
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Material_Group.Recycled),1},
                { nameof(RB_Material_Group.UpdateDate),DateTime.Now},
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                    FiledName=nameof(RB_Material_Group.Id),
                    FiledValue=groupId,
                    OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                    FiledName=nameof(RB_Material_Group.TenantId),
                    FiledValue=Convert.ToInt32(uid),
                    OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                    FiledName=nameof(RB_Material_Group.MallBaseId),
                    FiledValue=mallBaseId,
                    OperatorEnum=OperatorEnum.Equal
                },
            };
            return material_GroupRepository.Update(keyValues, wheres);
        }

        /// <summary>
        /// 设置素材回收
        /// </summary>
        /// <param name="materialIds"></param>
        /// <param name="uid"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool SetMaterialInfoRecycled(string materialIds, string uid, int mallBaseId)
        {
            bool flag = material_InfoRepository.SetMaterialListRecycled(materialIds, uid, mallBaseId);
            return flag;
        }

        /// <summary>
        /// 删除素材
        /// </summary>
        /// <param name="materialIds"></param>
        /// <param name="uid"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool DelMaterialInfo(string materialIds, string uid, int mallBaseId)
        {
            bool flag = material_InfoRepository.DelMaterialInfo(materialIds, uid, mallBaseId);
            return flag;
        }

        /// <summary>
        /// 设置素材还原
        /// </summary>
        /// <param name="materialIds"></param>
        /// <param name="uid"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool SetMaterialInfoRestore(string materialIds, string uid, int mallBaseId)
        {
            var trans = material_InfoRepository.DbTransaction;
            try
            {
                var list = material_InfoRepository.GetList(new RB_Material_Info_Extend() { MaterialIds = materialIds, TenantId = Convert.ToInt32(uid), MallBaseId = mallBaseId });
                if (list.Any())
                {
                    //查询出所有的分组
                    var glist = material_GroupRepository.GetList(new RB_Material_Group_Extend() { GroupIds = string.Join(",", list.Select(x => x.GroupId).Distinct()), TenantId = Convert.ToInt32(uid), MallBaseId = mallBaseId });
                    if (glist.Where(x => x.Recycled == 2).Any())
                    {
                        foreach (var item in glist.Where(x => x.Recycled == 2)) {
                            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                                { nameof(RB_Material_Group.Recycled),1},
                                { nameof(RB_Material_Group.UpdateDate),DateTime.Now},
                            };
                            List<WhereHelper> wheres = new List<WhereHelper>() {
                                new WhereHelper(){
                                    FiledName=nameof(RB_Material_Group.Id),
                                    FiledValue=item.Id,
                                    OperatorEnum=OperatorEnum.Equal
                                },
                                new WhereHelper(){
                                    FiledName=nameof(RB_Material_Group.TenantId),
                                    FiledValue=Convert.ToInt32(uid),
                                    OperatorEnum=OperatorEnum.Equal
                                },
                                new WhereHelper(){
                                    FiledName=nameof(RB_Material_Group.MallBaseId),
                                    FiledValue=mallBaseId,
                                    OperatorEnum=OperatorEnum.Equal
                                },
                            };
                            material_GroupRepository.Update(keyValues, wheres, trans);
                        }
                    }
                    foreach (var item in list) {
                        Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                            { nameof(RB_Material_Info.Recycled),1},
                            { nameof(RB_Material_Info.UpdateDate),DateTime.Now},
                        };
                        List<WhereHelper> wheres = new List<WhereHelper>() {
                            new WhereHelper(){
                                FiledName=nameof(RB_Material_Info.Id),
                                FiledValue=item.Id,
                                OperatorEnum=OperatorEnum.Equal
                            },
                            new WhereHelper(){
                                FiledName=nameof(RB_Material_Info.TenantId),
                                FiledValue=Convert.ToInt32(uid),
                                OperatorEnum=OperatorEnum.Equal
                            },
                            new WhereHelper(){
                                FiledName=nameof(RB_Material_Info.MallBaseId),
                                FiledValue=mallBaseId,
                                OperatorEnum=OperatorEnum.Equal
                            },
                        };
                        material_InfoRepository.Update(keyValues, wheres, trans);
                    }
                }
                material_InfoRepository.DBSession.Commit();
                return true;
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "SetMaterialInfoRestore");
                material_InfoRepository.DBSession.Rollback();
                return false;
            }
        }

        /// <summary>
        /// 设置分组转移
        /// </summary>
        /// <param name="materialIds"></param>
        /// <param name="groupId"></param>
        /// <param name="Type"></param>
        /// <param name="uid"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool SetMaterialInfoTransfer(string materialIds, int groupId, int Type, string uid, int mallBaseId)
        {
            var gmodel = material_GroupRepository.GetEntity(groupId);
            if (gmodel == null) {
                return false;
            }
            if (gmodel.Status == 1 || gmodel.Recycled == 2 || gmodel.Type != Type)
            {
                return false;
            }
            return material_InfoRepository.SetMaterialInfoTransfer(materialIds, groupId, uid, mallBaseId);
        }

        #endregion

        #region 商品分类

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Product_Category_Extend> GetProductCategoryPageList(int pageIndex, int pageSize, out long count, RB_Product_Category_Extend demodel)
        {
            var list = product_CategoryRepository.GetPageList(pageIndex, pageSize, out count, demodel);
            if (list.Any()) {
                List<int> ImgIds = new List<int>();
                ImgIds.AddRange(list.Select(x => x.Icon ?? 0).Distinct());
                ImgIds.AddRange(list.Select(x => x.BigIcon ?? 0).Distinct());
                ImgIds.AddRange(list.Select(x => x.AdvertisingImage ?? 0).Distinct());
                List<RB_Material_Info_Extend> mlist = new List<RB_Material_Info_Extend>();
                if (ImgIds.Any()) {
                    mlist = material_InfoRepository.GetList(new RB_Material_Info_Extend() { MaterialIds = string.Join(",", ImgIds), TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                }

                foreach (var item in list) {
                    item.IconPath = mlist.Where(x => x.Id == item.Icon).FirstOrDefault()?.Path ?? "";
                    item.BigIconPath = mlist.Where(x => x.Id == item.BigIcon).FirstOrDefault()?.Path ?? "";
                    item.AdvertisingImagePath = mlist.Where(x => x.Id == item.AdvertisingImage).FirstOrDefault()?.Path ?? "";
                }
            }
            return list;
        }

        /// <summary>
        /// 删除分类
        /// </summary>
        /// <param name="categoryId"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool DelProductCategoryInfo(int categoryId, int tenantId, int mallBaseId)
        {
            var trans = product_CategoryRepository.DbTransaction;
            try
            {
                var list = GetProductCategoryForALLChlid(categoryId, tenantId, mallBaseId);
                foreach (var item in list) {
                    Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                        { nameof(RB_Product_Category.Status),1},
                        { nameof(RB_Product_Category.UpdateDate),DateTime.Now},
                    };
                    List<WhereHelper> wheres = new List<WhereHelper>() {
                        new WhereHelper(){
                             FiledName=nameof(RB_Product_Category.Id),
                              FiledValue=categoryId,
                               OperatorEnum=OperatorEnum.Equal
                        },
                        new WhereHelper(){
                             FiledName=nameof(RB_Product_Category.TenantId),
                              FiledValue=tenantId,
                               OperatorEnum=OperatorEnum.Equal
                        },
                        new WhereHelper(){
                             FiledName=nameof(RB_Product_Category.MallBaseId),
                              FiledValue=mallBaseId,
                               OperatorEnum=OperatorEnum.Equal
                        }
                    };
                    bool flag = product_CategoryRepository.Update(keyValues, wheres, trans);
                }
                product_CategoryRepository.DBSession.Commit();
                return true;
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "DelProductCategoryInfo");
                product_CategoryRepository.DBSession.Rollback();
                return false;
            }
        }

        /// <summary>
        /// 获取分类样式
        /// </summary>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public RB_Product_CategoryStyle_Extend GetProductCategoryStyleInfo(int tenantId, int mallBaseId)
        {
            return product_CategoryStyleRepository.GetList(new RB_Product_CategoryStyle_Extend() { TenantId = tenantId, MallBaseId = mallBaseId }).FirstOrDefault();
        }

        /// <summary>
        /// 保存分类样式
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetProductCategoryStyleInfo(RB_Product_CategoryStyle_Extend demodel)
        {
            if (demodel.Id > 0)
            {
                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Product_CategoryStyle.Type),demodel.Type},
                    { nameof(RB_Product_CategoryStyle.Style),demodel.Style},
                    { nameof(RB_Product_CategoryStyle.CategoryNum),demodel.CategoryNum},
                    { nameof(RB_Product_CategoryStyle.RowNum),demodel.RowNum},
                    { nameof(RB_Product_CategoryStyle.UpdateDate),demodel.UpdateDate},
                };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                    new WhereHelper(){
                            FiledName=nameof(RB_Product_Category.Id),
                            FiledValue=demodel.Id,
                            OperatorEnum=OperatorEnum.Equal
                    }
                };
                return product_CategoryStyleRepository.Update(keyValues, wheres);
            }
            else {
                return product_CategoryStyleRepository.Insert(demodel) > 0;
            }
        }

        /// <summary>
        /// 保存排序
        /// </summary>
        /// <param name="delist"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool SetProductCategorySort(List<RB_Product_CategorySort> delist, int tenantId, int mallBaseId)
        {
            var trans = product_CategoryRepository.DbTransaction;
            try
            {
                string ids = string.Join(",", delist.Select(x => x.Id));
                var list = product_CategoryRepository.GetList(new RB_Product_Category_Extend() { CategoryIds = ids, TenantId = tenantId, MallBaseId = mallBaseId });
                if (list.Any())
                {
                    foreach (var item in list)
                    {
                        var demodel = delist.Where(x => x.Id == item.Id).FirstOrDefault();
                        Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                            { nameof(RB_Product_Category.Sort),demodel.Sort},
                        };
                        List<WhereHelper> wheres = new List<WhereHelper>() {
                            new WhereHelper(){
                                 FiledName=nameof(RB_Product_Category.Id),
                                  FiledValue=item.Id,
                                   OperatorEnum=OperatorEnum.Equal
                            }
                        };
                        bool flag = product_CategoryRepository.Update(keyValues, wheres, trans);
                    }
                }
                product_CategoryRepository.DBSession.Commit();
                return true;
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "SetProductCategorySort");
                product_CategoryRepository.DBSession.Rollback();
                return false;
            }
        }

        /// <summary>
        /// 获取树形结构列表
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Product_CategoryTree> GetProductCategoryTreeList(RB_Product_Category_Extend demodel)
        {
            List<RB_Product_CategoryTree> treeList = new List<RB_Product_CategoryTree>();
            var list = product_CategoryRepository.GetList(demodel);
            if (list.Any())
            {
                List<int> ImgIds = new List<int>();
                ImgIds.AddRange(list.Select(x => x.Icon ?? 0).Distinct());
                ImgIds.AddRange(list.Select(x => x.BigIcon ?? 0).Distinct());
                ImgIds.AddRange(list.Select(x => x.AdvertisingImage ?? 0).Distinct());
                List<RB_Material_Info_Extend> mlist = new List<RB_Material_Info_Extend>();
                if (ImgIds.Any())
                {
                    mlist = material_InfoRepository.GetList(new RB_Material_Info_Extend() { MaterialIds = string.Join(",", ImgIds), TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                }

                foreach (var item in list)
                {
                    item.IconPath = mlist.Where(x => x.Id == item.Icon).FirstOrDefault()?.Path ?? "";
                    item.BigIconPath = mlist.Where(x => x.Id == item.BigIcon).FirstOrDefault()?.Path ?? "";
                    item.AdvertisingImagePath = mlist.Where(x => x.Id == item.AdvertisingImage).FirstOrDefault()?.Path ?? "";
                }
                list = list.OrderBy(x => x.Sort).ThenBy(x => x.Id).ToList();
                treeList = GetProductCategoryChildTree(list, 0);                
            }

            return treeList;
        }

        /// <summary>
        /// 获取子集列表
        /// </summary>
        /// <param name="list"></param>
        /// <param name="parentId"></param>
        /// <returns></returns>
        public List<RB_Product_CategoryTree> GetProductCategoryChildTree(List<RB_Product_Category_Extend> list, int parentId) {
            List<RB_Product_CategoryTree> RList = new List<RB_Product_CategoryTree>();
            var CList = list.Where(x => x.ParentId == parentId).ToList();
            foreach (var item in CList) {
                var cmodel = new RB_Product_CategoryTree
                {
                    Id = item.Id,
                    Name = item.Name,
                    Icon = item.Icon ?? 0,
                    IconPath = item.IconPath
                };
                cmodel.ChildList = GetProductCategoryChildTree(list, item.Id);
                RList.Add(cmodel);
            }
            return RList;
        }

        /// <summary>
        /// 保存商品分类
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetProductCategoryInfo(RB_Product_Category_Extend demodel)
        {
            if (demodel.Id > 0)
            {
                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Product_Category.AdvertisingAddress),demodel.AdvertisingAddress},
                    { nameof(RB_Product_Category.AdvertisingImage),demodel.AdvertisingImage},
                    { nameof(RB_Product_Category.BigIcon),demodel.BigIcon},
                    { nameof(RB_Product_Category.Enabled),demodel.Enabled},
                    { nameof(RB_Product_Category.Icon),demodel.Icon},
                    { nameof(RB_Product_Category.IsShow),demodel.IsShow},
                    { nameof(RB_Product_Category.Name),demodel.Name},
                    { nameof(RB_Product_Category.Sort),demodel.Sort},
                    { nameof(RB_Product_Category.UpdateDate),demodel.UpdateDate}
                };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                    new WhereHelper(){
                         FiledName=nameof(RB_Product_Category.Id),
                          FiledValue=demodel.Id,
                           OperatorEnum=OperatorEnum.Equal
                    }
                };
                return product_CategoryRepository.Update(keyValues, wheres);
            }
            else
            {
                int Id = product_CategoryRepository.Insert(demodel);
                if (Id > 0) {
                    int RootId = Id;
                    if (demodel.ParentId > 0) {
                        var pmodel = product_CategoryRepository.GetEntity(demodel.ParentId);
                        RootId = pmodel?.RootId ?? 0;
                    }
                    Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                        { nameof(RB_Product_Category.RootId),RootId},
                    };
                    List<WhereHelper> wheres = new List<WhereHelper>() {
                        new WhereHelper(){
                                FiledName=nameof(RB_Product_Category.Id),
                                FiledValue=Id,
                                OperatorEnum=OperatorEnum.Equal
                        }
                    };
                    product_CategoryRepository.Update(keyValues, wheres);
                }
                return Id > 0;
            }
        }

        /// <summary>
        /// 获取商品分类
        /// </summary>
        /// <param name="categoryId"></param>
        /// <returns></returns>
        public RB_Product_Category_Extend GetProductCategoryInfo(int categoryId)
        {
            var model = product_CategoryRepository.GetEntity(categoryId).RefMapperTo<RB_Product_Category_Extend>();
            List<int> ImgIds = new List<int>
            {
                model.Icon ?? 0,
                model.BigIcon ?? 0,
                model.AdvertisingImage ?? 0
            };
            List<RB_Material_Info_Extend> mlist = new List<RB_Material_Info_Extend>();
            if (ImgIds.Any())
            {
                mlist = material_InfoRepository.GetList(new RB_Material_Info_Extend() { MaterialIds = string.Join(",", ImgIds)});
            }

            model.IconPath = mlist.Where(x => x.Id == model.Icon).FirstOrDefault()?.Path ?? "";
            model.BigIconPath = mlist.Where(x => x.Id == model.BigIcon).FirstOrDefault()?.Path ?? "";
            model.AdvertisingImagePath = mlist.Where(x => x.Id == model.AdvertisingImage).FirstOrDefault()?.Path ?? "";
            var p1Model = product_CategoryRepository.GetEntity(model?.ParentId);
            if (p1Model != null) {
                model.Parent1Name = p1Model.Name;
                var p2Model = product_CategoryRepository.GetEntity(p1Model?.ParentId);
                if (p2Model != null) {
                    model.Parent1Name = p2Model.Name;
                    model.Parent2Name = p1Model.Name;//黄媛媛要求  1表示1级  2表示2级
                }
            }
            return model;
        }

        /// <summary>
        /// 获取当前分类的所有子集分类
        /// </summary>
        /// <param name="categoryId"></param>
        /// <param name="tid"></param>
        /// <param name="mid"></param>
        /// <returns></returns>
        public List<RB_Product_Category_Extend> GetProductCategoryForALLChlid(int categoryId,int tid,int mid)
        {
            var model = product_CategoryRepository.GetEntity(categoryId);
            var list = product_CategoryRepository.GetList(new RB_Product_Category_Extend() { RootId = model.RootId, TenantId = tid, MallBaseId = mid });
            List<RB_Product_Category_Extend> RList = GetProductCategoryALLChild(list, model.Id);
            RList.AddRange(list.Where(x => x.Id == model.Id).ToList());
            return RList;
        }

        /// <summary>
        /// 获取所有子集
        /// </summary>
        /// <param name="list"></param>
        /// <param name="id"></param>
        /// <returns></returns>
        private List<RB_Product_Category_Extend> GetProductCategoryALLChild(List<RB_Product_Category_Extend> list, int id)
        {
            List<RB_Product_Category_Extend> RList = new List<RB_Product_Category_Extend>();
            var list2 = list.Where(x => x.ParentId == id).ToList();
            RList.AddRange(list2);
            foreach (var item in list2) {
                RList.AddRange(GetProductCategoryALLChild(list, item.Id));
            }
            return RList;
        }

        /// <summary>
        /// 分类转移
        /// </summary>
        /// <param name="cmodel"></param>
        /// <param name="parentId"></param>
        /// <param name="list"></param>
        /// <returns></returns>
        public bool SetProductCategoryTransfer(RB_Product_Category_Extend cmodel, int parentId, List<RB_Product_Category_Extend> list)
        {
            var trans = product_CategoryRepository.DbTransaction;
            try
            {
                int RootId = cmodel.Id;
                int Tier = 0;
                if (parentId > 0)
                {
                    var pmodel = product_CategoryRepository.GetEntity(parentId);
                    if (pmodel == null)
                    {
                        return false;
                    }
                    RootId = pmodel.RootId ?? 0;
                    Tier = (pmodel.Tier ?? 0) + 1;
                }
                else
                {
                    Tier = 1;
                }
                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Product_Category.ParentId),parentId},
                    { nameof(RB_Product_Category.UpdateDate),DateTime.Now},
                };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                    new WhereHelper(){
                         FiledName=nameof(RB_Product_Category.Id),
                          FiledValue=cmodel.Id,
                           OperatorEnum=OperatorEnum.Equal
                    }
                };
                bool flag = product_CategoryRepository.Update(keyValues, wheres, trans);
                if (flag)
                {
                    //更新所有子集rootid=
                    foreach (var item in list)
                    {
                        Dictionary<string, object> keyValues1 = new Dictionary<string, object>() {
                            { nameof(RB_Product_Category.RootId),RootId},
                            { nameof(RB_Product_Category.Tier),Tier+(item.Tier??0)-(cmodel.Tier??0) }
                        };
                        List<WhereHelper> wheres1 = new List<WhereHelper>() {
                            new WhereHelper(){
                                    FiledName=nameof(RB_Product_Category.Id),
                                    FiledValue=item.Id,
                                    OperatorEnum=OperatorEnum.Equal
                            }
                        };
                        product_CategoryRepository.Update(keyValues1, wheres1, trans);
                    }
                }
                product_CategoryRepository.DBSession.Commit();
                return flag;
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "SetProductCategoryTransfer");
                product_CategoryRepository.DBSession.Rollback();
                return false;
            }
        }

        #endregion

        #region 商品规格
        /// <summary>
        /// 获取商品规格分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Product_Specification_Extend> GetProducSpecificationPageList(int pageIndex, int pageSize, out long count, RB_Product_Specification_Extend demodel)
        {
            var list = product_SpecificationRepository.GetPageList(pageIndex, pageSize, out count, demodel);
            foreach (var item in list) {
                item.SpecList = new List<string>();
                if (!string.IsNullOrEmpty(item.Content)) {
                    item.SpecList = JsonConvert.DeserializeObject<List<string>>(item.Content);
                }
            }
            return list;
        }        

        /// <summary>
        /// 获取规格列表
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Product_Specification_Extend> GetProducSpecificationList(RB_Product_Specification_Extend demodel)
        {
            var list = product_SpecificationRepository.GetList(demodel);
            foreach (var item in list)
            {
                item.SpecList = new List<string>();
                if (!string.IsNullOrEmpty(item.Content))
                {
                    item.SpecList = JsonConvert.DeserializeObject<List<string>>(item.Content);
                }
            }
            return list;
        }

        /// <summary>
        /// 保存修改规格
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetProductSpecificationInfo(RB_Product_Specification_Extend demodel)
        {
            if (demodel.Id > 0)
            {
                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Product_Specification.Name),demodel.Name},
                    { nameof(RB_Product_Specification.Content),demodel.Content},
                    { nameof(RB_Product_Specification.UpdateDate),demodel.UpdateDate}
                };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                    new WhereHelper(){
                         FiledName=nameof(RB_Product_Specification.Id),
                          FiledValue=demodel.Id,
                           OperatorEnum=OperatorEnum.Equal
                    }
                };
                return product_SpecificationRepository.Update(keyValues, wheres);
            }
            else {
                return product_SpecificationRepository.Insert(demodel) > 0;
            }
        }

        /// <summary>
        /// 删除商品规格
        /// </summary>
        /// <param name="specificationId"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool DelProductSpecificationInfo(int specificationId, int tenantId, int mallBaseId)
        {
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Product_Specification.Status),1},
                { nameof(RB_Product_Specification.UpdateDate),DateTime.Now}
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Product_Specification.Id),
                        FiledValue=specificationId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Product_Specification.TenantId),
                        FiledValue=tenantId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Product_Specification.MallBaseId),
                        FiledValue=mallBaseId,
                        OperatorEnum=OperatorEnum.Equal
                }
            };
            return product_SpecificationRepository.Update(keyValues, wheres);
        }
        #endregion

        #region 快速购买

        /// <summary>
        /// 快速购买分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Product_QuickBuy_Extend> GetProductQuickBuyPageList(int pageIndex, int pageSize, out long count, RB_Product_QuickBuy_Extend demodel)
        {
            var list = product_QuickBuyRepository.GetPageList(pageIndex, pageSize, out count, demodel);
            if (list.Any()) {
                string imgids = string.Join(",", list.Where(x => x.Icon > 0).Select(x => x.Icon));
                List<RB_Material_Info_Extend> mlist = new List<RB_Material_Info_Extend>();
                if (!string.IsNullOrEmpty(imgids)) {
                    mlist = material_InfoRepository.GetList(new RB_Material_Info_Extend() { MaterialIds = imgids, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                }
                foreach (var item in list) {
                    item.IconPath = mlist.Where(x => x.Id == item.Icon).FirstOrDefault()?.Path ?? "";
                }
            }
            return list;
        }

        /// <summary>
        /// 获取快速购买列表
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Product_QuickBuy_Extend> GetProductQuickBuyList(RB_Product_QuickBuy_Extend demodel)
        {
            var list = product_QuickBuyRepository.GetAllList(demodel);
            if (list.Any())
            {
                string imgids = string.Join(",", list.Where(x => x.Icon > 0).Select(x => x.Icon));
                List<RB_Material_Info_Extend> mlist = new List<RB_Material_Info_Extend>();
                if (!string.IsNullOrEmpty(imgids))
                {
                    mlist = material_InfoRepository.GetList(new RB_Material_Info_Extend() { MaterialIds = imgids, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                }
                foreach (var item in list)
                {
                    item.IconPath = mlist.Where(x => x.Id == item.Icon).FirstOrDefault()?.Path ?? "";
                }
            }
            return list;
        }

        /// <summary>
        /// 验证快速购买分类
        /// </summary>
        /// <param name="id"></param>
        /// <param name="categoryId"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool ValidateQuickBuyCategory(int id, int? categoryId, int tenantId, int mallBaseId)
        {
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Product_QuickBuy.CategoryId),
                        FiledValue=categoryId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Product_QuickBuy.TenantId),
                        FiledValue=tenantId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Product_QuickBuy.MallBaseId),
                        FiledValue=mallBaseId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Product_QuickBuy.Status),
                        FiledValue=0,
                        OperatorEnum=OperatorEnum.Equal
                }
            };
            if (id > 0) {
                wheres.Add(new WhereHelper() {
                    FiledName = nameof(RB_Product_QuickBuy.Id),
                    FiledValue = id,
                    OperatorEnum = OperatorEnum.NotEqual
                });
            }
            return product_QuickBuyRepository.Exists(wheres);
        }

        /// <summary>
        /// 新增修改快速购买
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetProductQuickBuyInfo(RB_Product_QuickBuy_Extend demodel)
        {
            if (demodel.Id > 0)
            {
                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Product_QuickBuy.CategoryId),demodel.CategoryId},
                    { nameof(RB_Product_QuickBuy.Sort),demodel.Sort},
                    { nameof(RB_Product_QuickBuy.UpdateDate),DateTime.Now}
                };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                    new WhereHelper(){
                            FiledName=nameof(RB_Product_QuickBuy.Id),
                            FiledValue=demodel.Id,
                            OperatorEnum=OperatorEnum.Equal
                    },
                    new WhereHelper(){
                        FiledName=nameof(RB_Product_QuickBuy.TenantId),
                        FiledValue=demodel.TenantId,
                        OperatorEnum=OperatorEnum.Equal
                    },
                    new WhereHelper(){
                        FiledName=nameof(RB_Product_QuickBuy.MallBaseId),
                        FiledValue=demodel.MallBaseId,
                        OperatorEnum=OperatorEnum.Equal
                    },
                };
                return product_QuickBuyRepository.Update(keyValues, wheres);
            }
            else {
                return product_QuickBuyRepository.Insert(demodel) > 0;
            }
        }        

        /// <summary>
        /// 删除快速购买
        /// </summary>
        /// <param name="quickBuyId"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool DelProductQuickBuyInfo(int quickBuyId, int tenantId, int mallBaseId)
        {
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Product_QuickBuy.Status),1},
                { nameof(RB_Product_QuickBuy.UpdateDate),DateTime.Now}
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                    FiledName=nameof(RB_Product_QuickBuy.Id),
                    FiledValue=quickBuyId,
                    OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                    FiledName=nameof(RB_Product_QuickBuy.TenantId),
                    FiledValue=tenantId,
                    OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                    FiledName=nameof(RB_Product_QuickBuy.MallBaseId),
                    FiledValue=mallBaseId,
                    OperatorEnum=OperatorEnum.Equal
                },
            };
            return product_QuickBuyRepository.Update(keyValues, wheres);
        }

        #endregion

        #region 推荐设置
        /// <summary>
        /// 获取推荐设置详情
        /// </summary>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public RB_Product_Recommend_Extend GetProductRecommendSetInfo(int tenantId, int mallBaseId)
        {
            var model = product_RecommendRepository.GetList(new RB_Product_Recommend_Extend() { TenantId = tenantId, MallBaseId = mallBaseId }).FirstOrDefault();
            if (model == null) {
                return new RB_Product_Recommend_Extend();
            }
            model.OrderProductList = new List<RB_ProductRecommendModel>();
            if (model.IsOrderRecommend == 1 && !string.IsNullOrEmpty(model.OrderProductIds)) {
                //查询商品
                var glist = goodsRepository.GetList(new RB_Goods_Extend() { GoodsIds = model.OrderProductIds, TenantId = tenantId, MallBaseId = mallBaseId });
                foreach (var item in glist)
                {                    
                    //轮播图
                    if (!string.IsNullOrEmpty(item.CarouselImage) && item.CarouselImage != "[]")
                    {
                        List<int> CarouselIdList = JsonConvert.DeserializeObject<List<int>>(item.CarouselImage);
                        //封面图
                        item.CoverImage = material_InfoRepository.GetEntity(CarouselIdList[0])?.Path ?? "";
                    }
                }
                foreach (var item in glist) {
                    model.OrderProductList.Add(new RB_ProductRecommendModel()
                    {
                        Id = item.Id,
                        Image = item.CoverImage,
                        Name = item.Name
                    });
                }
            }
            model.CommentProductList = new List<RB_ProductRecommendModel>();
            if (model.IsCommentRecommend == 1 && !string.IsNullOrEmpty(model.CommentProductIds)) {
                var glist = goodsRepository.GetList(new RB_Goods_Extend() { GoodsIds = model.CommentProductIds, TenantId = tenantId, MallBaseId = mallBaseId });
                foreach (var item in glist)
                {
                    //轮播图
                    if (!string.IsNullOrEmpty(item.CarouselImage) && item.CarouselImage != "[]")
                    {
                        List<int> CarouselIdList = JsonConvert.DeserializeObject<List<int>>(item.CarouselImage);
                        //封面图
                        item.CoverImage = material_InfoRepository.GetEntity(CarouselIdList[0])?.Path ?? "";
                    }
                }
                foreach (var item in glist)
                {
                    model.CommentProductList.Add(new RB_ProductRecommendModel()
                    {
                        Id = item.Id,
                        Image = item.CoverImage,
                        Name = item.Name
                    });
                }
            }
            return model;
        }

        /// <summary>
        /// 保存推荐设置
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetProductRecommendSetInfo(RB_Product_Recommend_Extend demodel)
        {
            if (demodel.Id > 0)
            {
                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Product_Recommend.CommentProductIds),demodel.CommentProductIds},
                    { nameof(RB_Product_Recommend.CommentRecommentStatus),demodel.CommentRecommentStatus},
                    { nameof(RB_Product_Recommend.DetailRecommendNum),demodel.DetailRecommendNum},
                    { nameof(RB_Product_Recommend.DetailRecommendStatus),demodel.DetailRecommendStatus},
                    { nameof(RB_Product_Recommend.IsCommentRecommend),demodel.IsCommentRecommend},
                    { nameof(RB_Product_Recommend.IsOrderRecommend),demodel.IsOrderRecommend},
                    { nameof(RB_Product_Recommend.OrderCompleteStatus),demodel.OrderCompleteStatus},
                    { nameof(RB_Product_Recommend.OrderProductIds),demodel.OrderProductIds},
                    { nameof(RB_Product_Recommend.UpdateDate),demodel.UpdateDate}
                };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                    new WhereHelper(){
                         FiledName=nameof(RB_Product_Recommend.Id),
                          FiledValue=demodel.Id,
                           OperatorEnum=OperatorEnum.Equal
                    }
                };
                return product_RecommendRepository.Update(keyValues, wheres);
            }
            else {
                return product_RecommendRepository.Insert(demodel) > 0;
            }
        }

        #endregion

        #region 商品服务

        /// <summary>
        /// 获取商品服务分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Product_Service_Extend> GetProductServicePageList(int pageIndex, int pageSize, out long count, RB_Product_Service_Extend demodel)
        {
            return product_ServiceRepository.GetPageList(pageIndex, pageSize, out count, demodel);
        }

        /// <summary>
        /// 获取商品服务列表
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Product_Service_Extend> GetProductServiceList(RB_Product_Service_Extend demodel)
        {
            return product_ServiceRepository.GetList(demodel);
        }


        /// <summary>
        /// 新增修改商品服务
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetProductServiceInfo(RB_Product_Service_Extend demodel)
        {
            if (demodel.Id > 0)
            {
                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Product_Service.Name),demodel.Name},
                    { nameof(RB_Product_Service.Sort),demodel.Sort},
                    { nameof(RB_Product_Service.Remark),demodel.Remark},
                    { nameof(RB_Product_Service.IsDefault),demodel.IsDefault},
                    { nameof(RB_Product_Service.UpdateDate),demodel.UpdateDate}
                };
                if (demodel.UpdateType == 1)
                { //只更新默认状态
                    var model = product_ServiceRepository.GetEntity(demodel.Id);
                    if (model == null) {
                        return false;
                    }
                    keyValues = new Dictionary<string, object>()
                    {
                        { nameof(RB_Product_Service.IsDefault),model.IsDefault==1?2:1},
                        { nameof(RB_Product_Service.UpdateDate),demodel.UpdateDate}
                    };
                }
                else if (demodel.UpdateType == 2)
                { //只更新排序
                    keyValues = new Dictionary<string, object>()
                    {
                        { nameof(RB_Product_Service.Sort),demodel.Sort},
                        { nameof(RB_Product_Service.UpdateDate),demodel.UpdateDate}
                    };
                }
                List<WhereHelper> wheres = new List<WhereHelper>() {
                    new WhereHelper(){
                         FiledName=nameof(RB_Product_Service.Id),
                          FiledValue=demodel.Id,
                           OperatorEnum=OperatorEnum.Equal
                    }
                };
                return product_ServiceRepository.Update(keyValues, wheres);
            }
            else
            {
                return product_ServiceRepository.Insert(demodel) > 0;
            }
        }

        /// <summary>
        /// 获取服务详情
        /// </summary>
        /// <param name="serviceId"></param>
        /// <returns></returns>
        public RB_Product_Service_Extend GetProductServiceInfo(int serviceId)
        {
            return product_ServiceRepository.GetEntity(serviceId).RefMapperTo<RB_Product_Service_Extend>();
        }

        /// <summary>
        /// 删除商品服务
        /// </summary>
        /// <param name="serviceId"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool DelProductServiceInfo(int serviceId, int tenantId, int mallBaseId)
        {
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Product_Service.Status),1},
                { nameof(RB_Product_Service.UpdateDate),DateTime.Now}
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                    FiledName=nameof(RB_Product_Service.Id),
                    FiledValue=serviceId,
                    OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                    FiledName=nameof(RB_Product_Service.TenantId),
                    FiledValue=tenantId,
                    OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                    FiledName=nameof(RB_Product_Service.MallBaseId),
                    FiledValue=mallBaseId,
                    OperatorEnum=OperatorEnum.Equal
                },
            };
            return product_ServiceRepository.Update(keyValues, wheres);
        }
        #endregion

        #region 商品管理

        /// <summary>
        /// 获取后台商品分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Goods_Extend> GetProductGoodsPageList(int pageIndex, int pageSize, out long count, RB_Goods_Extend demodel)
        {
            var list = goodsRepository.GetPageList(pageIndex, pageSize, out count, demodel);
            if (list.Any()) {
                //查询分类
                string ids = string.Join(",", list.Select(x => x.Id));
                var clist = goods_CategoryRepository.GetList(new RB_Goods_Category_Extend() { GoodsIds = ids, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                foreach (var item in list) {
                    item.CategoryList = clist.Where(x => x.GoodsId == item.Id).ToList();
                    //轮播图
                    item.CoverImage = "";
                    if (!string.IsNullOrEmpty(item.CarouselImage) && item.CarouselImage != "[]") {
                        List<int> CarouselIdList = JsonConvert.DeserializeObject<List<int>>(item.CarouselImage);
                        //封面图
                        item.CoverImage = material_InfoRepository.GetEntity(CarouselIdList[0])?.Path ?? "";
                        //轮播图
                    }
                }
            }
            return list;
        }

        /// <summary>
        /// 获取后台商品列表
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Goods_Extend> GetProductGoodsList(RB_Goods_Extend demodel)
        {
            var list = goodsRepository.GetList(demodel);
            if (list.Any())
            {
                //查询分类
                string ids = string.Join(",", list.Select(x => x.Id));
                var clist = goods_CategoryRepository.GetList(new RB_Goods_Category_Extend() { GoodsIds = ids, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                foreach (var item in list)
                {
                    item.CategoryList = clist.Where(x => x.GoodsId == item.Id).ToList();
                    //轮播图
                    item.CoverImage = "";
                    if (!string.IsNullOrEmpty(item.CarouselImage) && item.CarouselImage != "[]")
                    {
                        List<int> CarouselIdList = JsonConvert.DeserializeObject<List<int>>(item.CarouselImage);
                        //封面图
                        item.CoverImage = material_InfoRepository.GetEntity(CarouselIdList[0])?.Path ?? "";
                        //轮播图
                    }
                }
            }
            return list;
        }

        /// <summary>
        /// 新增修改商品信息
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetProductGoodsInfo(RB_Goods_Extend demodel)
        {
            var trans = goodsRepository.DbTransaction;
            try
            {
                if (demodel.Id > 0)
                {
                    //修改
                    Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                        { nameof(RB_Goods.Name),demodel.Name},
                        { nameof(RB_Goods.CarouselImage),demodel.CarouselImage},
                        { nameof(RB_Goods.VideoAddress),demodel.VideoAddress},
                        { nameof(RB_Goods.CustomShareTitles),demodel.CustomShareTitles},
                        { nameof(RB_Goods.CustomShareImage),demodel.CustomShareImage},
                        { nameof(RB_Goods.GoodsStatus),demodel.GoodsStatus},
                        { nameof(RB_Goods.InventoryNum),demodel.InventoryNum},
                        { nameof(RB_Goods.DefaultSpecificationName),demodel.DefaultSpecificationName},
                        { nameof(RB_Goods.IsCustomSpecification),demodel.IsCustomSpecification},
                        { nameof(RB_Goods.Sort),demodel.Sort},
                        { nameof(RB_Goods.SellingPrice),demodel.SellingPrice},
                        { nameof(RB_Goods.OriginalPrice),demodel.OriginalPrice},
                        { nameof(RB_Goods.Unit),demodel.Unit},
                        { nameof(RB_Goods.CostPrice),demodel.CostPrice},
                        { nameof(RB_Goods.IsGoodsNegotiable),demodel.IsGoodsNegotiable},
                        { nameof(RB_Goods.SalesNum),demodel.SalesNum},
                        { nameof(RB_Goods.GoodsNumbers),demodel.GoodsNumbers},
                        { nameof(RB_Goods.GoodsWeight),demodel.GoodsWeight},
                        { nameof(RB_Goods.IsDefaultService),demodel.IsDefaultService},
                        { nameof(RB_Goods.GoodsService),demodel.GoodsService},
                        { nameof(RB_Goods.FreightId),demodel.FreightId},
                        { nameof(RB_Goods.FormsId),demodel.FormsId},
                        { nameof(RB_Goods.LimitBuyGoodsNum),demodel.LimitBuyGoodsNum},
                        { nameof(RB_Goods.LimitBuyOrderNum),demodel.LimitBuyOrderNum},
                        { nameof(RB_Goods.FullNumPinkage),demodel.FullNumPinkage},
                        { nameof(RB_Goods.FullMoneyPinkage),demodel.FullMoneyPinkage},
                        { nameof(RB_Goods.IsAreaBuy),demodel.IsAreaBuy},
                        { nameof(RB_Goods.IntegralPresent),demodel.IntegralPresent},
                        { nameof(RB_Goods.IntegralPresentType),demodel.IntegralPresentType},
                        { nameof(RB_Goods.PointsDeduction),demodel.PointsDeduction},
                        { nameof(RB_Goods.PointsDeductionType),demodel.PointsDeductionType},
                        { nameof(RB_Goods.IsMultipleDeduction),demodel.IsMultipleDeduction},
                        { nameof(RB_Goods.GoodsDetails),demodel.GoodsDetails},
                        { nameof(RB_Goods.UpdateDate),demodel.UpdateDate},
                        { nameof(RB_Goods.SeparateDistribution),demodel.SeparateDistribution},
                        { nameof(RB_Goods.SeparateDistributionType),demodel.SeparateDistributionType},
                        { nameof(RB_Goods.SeparateDistributionMoneyType),demodel.SeparateDistributionMoneyType},
                        { nameof(RB_Goods.SeparateDistributionMoneyType),demodel.SeparateDistributionMoneyType},
                        { nameof(RB_Goods.SeparateSetMember),demodel.SeparateSetMember},
                        { nameof(RB_Goods.IsQuickBuy),demodel.IsQuickBuy}
                    };
                    List<WhereHelper> wheres = new List<WhereHelper>() {
                        new WhereHelper(){
                             FiledName=nameof(RB_Goods.Id),
                              FiledValue=demodel.Id,
                               OperatorEnum=OperatorEnum.Equal
                        },
                        new WhereHelper(){
                             FiledName=nameof(RB_Goods.TenantId),
                              FiledValue=demodel.TenantId,
                               OperatorEnum=OperatorEnum.Equal
                        },
                        new WhereHelper(){
                             FiledName=nameof(RB_Goods.MallBaseId),
                              FiledValue=demodel.MallBaseId,
                               OperatorEnum=OperatorEnum.Equal
                        }
                    };
                    bool flag = goodsRepository.Update(keyValues, wheres, trans);
                    if (flag) {
                        #region 修改分类
                        var clist = goods_CategoryRepository.GetList(new RB_Goods_Category_Extend() { GoodsId = demodel.Id, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                        var insertList = demodel.CategoryList.Where(x => !clist.Select(y => y.CategoryId).Contains(x.CategoryId)).ToList();
                        //var updateList = clist.Where(x => demodel.CategoryList.Select(y => y.CategoryId).Contains(x.CategoryId)).ToList();
                        var deleteList = clist.Where(x => !demodel.CategoryList.Select(y => y.CategoryId).Contains(x.CategoryId)).ToList();
                        foreach (var item in insertList) {
                            goods_CategoryRepository.Insert(new RB_Goods_Category()
                            {
                                CategoryId = item.CategoryId,
                                CreateDate = demodel.CreateDate,
                                GoodsId = demodel.Id,
                                Id = 0,
                                MallBaseId = demodel.MallBaseId,
                                Status = 0,
                                TenantId = demodel.TenantId
                            }, trans);
                        }
                        foreach (var item in deleteList) {
                            goods_CategoryRepository.Delete(item.Id, trans);
                        }
                        #endregion
                        #region 修改规格
                        if (demodel.IsCustomSpecification == 1)
                        {
                            var slist = goods_SpecificationRepository.GetList(new RB_Goods_Specification_Extend() { GoodsId = demodel.Id, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                            if (slist.Count() != demodel.SpecificationList.Count() || slist.Count() != demodel.SpecificationList.Where(x => x.Id > 0).Count())
                            {
                                var svlist = goods_SpecificationValueRepository.GetList(new RB_Goods_SpecificationValue_Extend() { GoodsId = demodel.Id, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                                var splist = goods_SpecificationPriceRepository.GetList(new RB_Goods_SpecificationPrice_Extend() { GoodsId = demodel.Id, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                                //删除后新增
                                goods_SpecificationRepository.DeleteBatch(slist, trans);
                                goods_SpecificationValueRepository.DeleteBatch(svlist, trans);
                                goods_SpecificationPriceRepository.DeleteBatch(splist, trans);
                                foreach (var item in demodel.SpecificationList)
                                {
                                    int sid = goods_SpecificationRepository.Insert(new RB_Goods_Specification()
                                    {
                                        CreateDate = demodel.CreateDate,
                                        EnabledImage = item.EnabledImage,
                                        GoodsId = demodel.Id,
                                        Id = 0,
                                        MallBaseId = demodel.MallBaseId,
                                        Name = item.Name,
                                        Sort = item.Sort,
                                        Status = 0,
                                        TenantId = demodel.TenantId
                                    }, trans);
                                    if (sid > 0)
                                    {
                                        foreach (var qitem in item.SpecificationValueList)
                                        {
                                            goods_SpecificationValueRepository.Insert(new RB_Goods_SpecificationValue()
                                            {
                                                CreateDate = demodel.CreateDate,
                                                GoodsId = demodel.Id,
                                                Id = 0,
                                                Image = qitem.Image,
                                                MallBaseId = demodel.MallBaseId,
                                                Name = qitem.Name,
                                                Sort = qitem.Sort,
                                                Status = 0,
                                                TenantId = demodel.TenantId,
                                                SpecificationId = sid
                                            }, trans);
                                        }
                                    }
                                }
                                foreach (var item in demodel.SpecificationPriceList)
                                {
                                    goods_SpecificationPriceRepository.Insert(new RB_Goods_SpecificationPrice()
                                    {
                                        CreateDate = demodel.CreateDate,
                                        GoodsId = demodel.Id,
                                        Id = 0,
                                        GoodsNumbers = item.GoodsNumbers,
                                        GoodsWeight = item.GoodsWeight,
                                        InventoryNum = item.InventoryNum,
                                        MallBaseId = demodel.MallBaseId,
                                        SellingPrice = item.SellingPrice,
                                        SpecificationSort = item.SpecificationSort,
                                        Status = 0,
                                        TenantId = demodel.TenantId,
                                        UpdateDate = demodel.UpdateDate
                                    }, trans);
                                }
                            }
                            else
                            {
                                //更新
                                var svlist = goods_SpecificationValueRepository.GetList(new RB_Goods_SpecificationValue_Extend() { GoodsId = demodel.Id, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                                var splist = goods_SpecificationPriceRepository.GetList(new RB_Goods_SpecificationPrice_Extend() { GoodsId = demodel.Id, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                                foreach (var item in slist) {
                                    var supmodel = demodel.SpecificationList.Where(x => x.Id == item.Id).FirstOrDefault();
                                    Dictionary<string, object> keyValues1 = new Dictionary<string, object>() {
                                        { nameof(RB_Goods_Specification.EnabledImage),supmodel.EnabledImage},
                                        { nameof(RB_Goods_Specification.Name),supmodel.Name},
                                        { nameof(RB_Goods_Specification.Sort),supmodel.Sort}
                                    };
                                    List<WhereHelper> wheres1 = new List<WhereHelper>() {
                                        new WhereHelper(){
                                             FiledName=nameof(RB_Goods_Specification.Id),
                                              FiledValue=item.Id,
                                               OperatorEnum=OperatorEnum.Equal
                                        }
                                    };
                                    bool flag1 = goods_SpecificationRepository.Update(keyValues1, wheres1, trans);
                                    if (flag1) {
                                        var sv2list = svlist.Where(x => x.SpecificationId == item.Id).ToList();
                                        if (sv2list.Count() != supmodel.SpecificationValueList.Count() || sv2list.Count() != supmodel.SpecificationValueList.Where(x => x.Id > 0).Count())
                                        {
                                            goods_SpecificationValueRepository.DeleteBatch(sv2list, trans);
                                            foreach (var qitem in supmodel.SpecificationValueList)
                                            {
                                                goods_SpecificationValueRepository.Insert(new RB_Goods_SpecificationValue()
                                                {
                                                    CreateDate = demodel.CreateDate,
                                                    GoodsId = demodel.Id,
                                                    Id = 0,
                                                    Image = qitem.Image,
                                                    MallBaseId = demodel.MallBaseId,
                                                    Name = qitem.Name,
                                                    Sort = qitem.Sort,
                                                    Status = 0,
                                                    TenantId = demodel.TenantId,
                                                    SpecificationId = item.Id
                                                }, trans);
                                            }
                                        }
                                        else {
                                            foreach (var qitem in sv2list)
                                            {
                                                var supModel1 = supmodel.SpecificationValueList.Where(x => x.Id == qitem.Id).FirstOrDefault();
                                                Dictionary<string, object> keyValues2 = new Dictionary<string, object>() {
                                                    { nameof(RB_Goods_SpecificationValue.Image),supModel1.Image},
                                                    { nameof(RB_Goods_SpecificationValue.Name),supModel1.Name},
                                                    { nameof(RB_Goods_SpecificationValue.Sort),supModel1.Sort}
                                                };
                                                List<WhereHelper> wheres2 = new List<WhereHelper>() {
                                                    new WhereHelper(){
                                                         FiledName=nameof(RB_Goods_Specification.Id),
                                                          FiledValue=qitem.Id,
                                                           OperatorEnum=OperatorEnum.Equal
                                                    }
                                                };
                                                goods_SpecificationValueRepository.Update(keyValues2, wheres2, trans);
                                            }
                                        }
                                    }
                                }
                                //价格新增/更新
                                if (splist.Count() != demodel.SpecificationPriceList.Count() || splist.Count() != demodel.SpecificationPriceList.Where(x => splist.Select(y => y.SpecificationSort).Contains(x.SpecificationSort)).Count())
                                {
                                    goods_SpecificationPriceRepository.DeleteBatch(splist, trans);
                                    foreach (var item in demodel.SpecificationPriceList)
                                    {
                                        goods_SpecificationPriceRepository.Insert(new RB_Goods_SpecificationPrice()
                                        {
                                            CreateDate = demodel.CreateDate,
                                            GoodsId = demodel.Id,
                                            Id = 0,
                                            GoodsNumbers = item.GoodsNumbers,
                                            GoodsWeight = item.GoodsWeight,
                                            InventoryNum = item.InventoryNum,
                                            MallBaseId = demodel.MallBaseId,
                                            SellingPrice = item.SellingPrice,
                                            SpecificationSort = item.SpecificationSort,
                                            Status = 0,
                                            TenantId = demodel.TenantId,
                                            UpdateDate = demodel.UpdateDate
                                        }, trans);
                                    }
                                }
                                else {
                                    foreach (var item in splist) {
                                        var pupmodel = demodel.SpecificationPriceList.Where(x => x.SpecificationSort == item.SpecificationSort).FirstOrDefault();
                                        if (item.SellingPrice != pupmodel.SellingPrice || item.InventoryNum != pupmodel.InventoryNum || item.GoodsNumbers != pupmodel.GoodsNumbers || item.GoodsWeight != pupmodel.GoodsWeight)
                                        {
                                            Dictionary<string, object> keyValues1 = new Dictionary<string, object>() {
                                                { nameof(RB_Goods_SpecificationPrice.SellingPrice),pupmodel.SellingPrice},
                                                { nameof(RB_Goods_SpecificationPrice.InventoryNum),pupmodel.InventoryNum},
                                                { nameof(RB_Goods_SpecificationPrice.GoodsWeight),pupmodel.GoodsWeight},
                                                { nameof(RB_Goods_SpecificationPrice.GoodsNumbers),pupmodel.GoodsNumbers}
                                            };
                                            List<WhereHelper> wheres1 = new List<WhereHelper>() {
                                                new WhereHelper(){
                                                     FiledName=nameof(RB_Goods_SpecificationPrice.Id),
                                                      FiledValue=item.Id,
                                                       OperatorEnum=OperatorEnum.Equal
                                                }
                                            };
                                            goods_SpecificationPriceRepository.Update(keyValues1, wheres1, trans);
                                        }
                                    }
                                }
                            }
                        }
                        #endregion
                        #region 修改区域
                        var alist = goods_AreaRepository.GetList(new RB_Goods_Area_Extend() { GoodsId = demodel.Id, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                        var insertList1 = demodel.AreaList.Where(x => !alist.Select(y => y.AreaId).Contains(x.AreaId)).ToList();
                        var deleteList1 = alist.Where(x => !demodel.AreaList.Select(y => y.AreaId).Contains(x.AreaId)).ToList();
                        foreach (var item in insertList1)
                        {
                            goods_AreaRepository.Insert(new RB_Goods_Area()
                            {
                                AreaId = item.AreaId,
                                AreaType = item.AreaType,
                                CreateDate = demodel.CreateDate,
                                GoodsId = demodel.Id,
                                Id = 0,
                                MallBaseId = demodel.MallBaseId,
                                Status = 0,
                                TenantId = demodel.TenantId
                            }, trans);
                        }
                        foreach (var item in deleteList1)
                        {
                            goods_AreaRepository.Delete(item.Id, trans);
                        }


                        #endregion
                        //修改卡卷
                        #region 修改分销佣金
                        if (demodel.SeparateDistribution == 1) {
                            //价格新增/更新
                            var dclist = goods_DistributionCommissionRepository.GetList(new RB_Goods_DistributionCommission_Extend() { GoodsId = demodel.Id, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                            if (dclist.Count() != demodel.DistributionCommissionList.Count() 
                                || dclist.Count() != demodel.DistributionCommissionList.Where(x => dclist.Select(y => y.SpecificationSort).Contains(x.SpecificationSort)).Count()
                                || dclist.Select(x => x.DistributorGrade).Distinct().Count() != demodel.DistributionCommissionList.Select(x => x.DistributorGrade).Distinct().Count()
                                || dclist.Select(x => x.DistributorGrade).Distinct().Count() != dclist.Select(x => x.DistributorGrade).Distinct().Where(x => demodel.DistributionCommissionList.Select(y => y.DistributorGrade).Distinct().Contains(x)).Count())
                            {
                                goods_DistributionCommissionRepository.DeleteBatch(dclist, trans);
                                foreach (var item in demodel.DistributionCommissionList)
                                {
                                    goods_DistributionCommissionRepository.Insert(new RB_Goods_DistributionCommission()
                                    {
                                        CreateDate = demodel.CreateDate,
                                        GoodsId = demodel.Id,
                                        Id = 0,
                                        DistributorGrade = item.DistributorGrade,
                                        OneCommission = item.OneCommission,
                                        ThreeCommission = item.ThreeCommission,
                                        TwoCommission = item.TwoCommission,
                                        MallBaseId = demodel.MallBaseId,
                                        SpecificationSort = item.SpecificationSort,
                                        Status = 0,
                                        TenantId = demodel.TenantId,
                                        UpdateDate = demodel.UpdateDate
                                    }, trans);
                                }
                            }
                            else
                            {
                                
                                foreach (var item in dclist)
                                {
                                    var pupmodel = demodel.DistributionCommissionList.Where(x => x.SpecificationSort == item.SpecificationSort && x.DistributorGrade == item.DistributorGrade).FirstOrDefault();
                                    if (item.OneCommission != pupmodel.OneCommission || item.TwoCommission != pupmodel.TwoCommission || item.ThreeCommission != pupmodel.ThreeCommission)
                                    {
                                        Dictionary<string, object> keyValues1 = new Dictionary<string, object>() {
                                            { nameof(RB_Goods_DistributionCommission.OneCommission),pupmodel.OneCommission},
                                            { nameof(RB_Goods_DistributionCommission.TwoCommission),pupmodel.TwoCommission},
                                            { nameof(RB_Goods_DistributionCommission.ThreeCommission),pupmodel.ThreeCommission}
                                        };
                                        List<WhereHelper> wheres1 = new List<WhereHelper>() {
                                            new WhereHelper(){
                                                    FiledName=nameof(RB_Goods_DistributionCommission.Id),
                                                    FiledValue=item.Id,
                                                    OperatorEnum=OperatorEnum.Equal
                                            }
                                        };
                                        goods_DistributionCommissionRepository.Update(keyValues1, wheres1, trans);
                                    }
                                }
                            }
                        }
                        #endregion
                        #region 修改会员价格
                        if (demodel.EnjoyMember == 1 && demodel.SeparateSetMember == 1) {
                            var mplist = goods_MemberPriceRepository.GetList(new RB_Goods_MemberPrice_Extend() { GoodsId = demodel.Id, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                            if (mplist.Count() != demodel.MemberPriceList.Count()
                                || mplist.Count() != demodel.MemberPriceList.Where(x => mplist.Select(y => y.SpecificationSort).Contains(x.SpecificationSort)).Count()
                                || mplist.Select(x => x.MemberGrade).Distinct().Count() != demodel.MemberPriceList.Select(x => x.MemberGrade).Distinct().Count()
                                || mplist.Select(x => x.MemberGrade).Distinct().Count() != mplist.Select(x => x.MemberGrade).Distinct().Where(x => demodel.MemberPriceList.Select(y => y.MemberGrade).Distinct().Contains(x)).Count())
                            {
                                goods_MemberPriceRepository.DeleteBatch(mplist, trans);
                                foreach (var item in demodel.MemberPriceList)
                                {
                                    goods_MemberPriceRepository.Insert(new RB_Goods_MemberPrice()
                                    {
                                        CreateDate = demodel.CreateDate,
                                        GoodsId = demodel.Id,
                                        Id = 0,
                                        MemberGrade = item.MemberGrade,
                                        MemberPrice = item.MemberPrice,
                                        MallBaseId = demodel.MallBaseId,
                                        SpecificationSort = item.SpecificationSort,
                                        Status = 0,
                                        TenantId = demodel.TenantId,
                                        UpdateDate = demodel.UpdateDate
                                    }, trans);
                                }
                            }
                            else
                            {

                                foreach (var item in mplist)
                                {
                                    var pupmodel = demodel.MemberPriceList.Where(x => x.SpecificationSort == item.SpecificationSort && x.MemberGrade == item.MemberGrade).FirstOrDefault();
                                    if (item.MemberPrice != pupmodel.MemberPrice)
                                    {
                                        Dictionary<string, object> keyValues1 = new Dictionary<string, object>() {
                                            { nameof(RB_Goods_MemberPrice.MemberPrice),pupmodel.MemberPrice}
                                        };
                                        List<WhereHelper> wheres1 = new List<WhereHelper>() {
                                            new WhereHelper(){
                                                    FiledName=nameof(RB_Goods_MemberPrice.Id),
                                                    FiledValue=item.Id,
                                                    OperatorEnum=OperatorEnum.Equal
                                            }
                                        };
                                        goods_MemberPriceRepository.Update(keyValues1, wheres1, trans);
                                    }
                                }
                            }
                        }
                        #endregion
                    }
                }
                else {
                    int Id = goodsRepository.Insert(demodel, trans);
                    bool flag = Id > 0;
                    if (flag) {
                        //插入分类
                        foreach (var item in demodel.CategoryList) {
                            goods_CategoryRepository.Insert(new RB_Goods_Category()
                            {
                                CategoryId = item.CategoryId,
                                CreateDate = demodel.CreateDate,
                                GoodsId = Id,
                                Id = 0,
                                MallBaseId = demodel.MallBaseId,
                                Status = 0,
                                TenantId = demodel.TenantId
                            }, trans);
                        }
                        //插入规格
                        if (demodel.IsCustomSpecification == 1) {
                            foreach (var item in demodel.SpecificationList) {
                                int sid= goods_SpecificationRepository.Insert(new RB_Goods_Specification()
                                {
                                    CreateDate = demodel.CreateDate,
                                    EnabledImage = item.EnabledImage,
                                    GoodsId = Id,
                                    Id = 0,
                                    MallBaseId = demodel.MallBaseId,
                                    Name = item.Name,
                                    Sort = item.Sort,
                                    Status = 0,
                                    TenantId = demodel.TenantId
                                }, trans);
                                if (sid > 0)
                                {
                                    foreach (var qitem in item.SpecificationValueList)
                                    {
                                        goods_SpecificationValueRepository.Insert(new RB_Goods_SpecificationValue()
                                        {
                                            CreateDate = demodel.CreateDate,
                                            GoodsId = Id,
                                            Id = 0,
                                            Image = qitem.Image,
                                            MallBaseId = demodel.MallBaseId,
                                            Name = qitem.Name,
                                            Sort = qitem.Sort,
                                            Status = 0,
                                            TenantId = demodel.TenantId,
                                            SpecificationId = sid
                                        }, trans);
                                    }
                                }
                            }
                            foreach (var item in demodel.SpecificationPriceList) {
                                goods_SpecificationPriceRepository.Insert(new RB_Goods_SpecificationPrice()
                                {
                                    CreateDate = demodel.CreateDate,
                                    GoodsId = Id,
                                    Id = 0,
                                    GoodsNumbers = item.GoodsNumbers,
                                    GoodsWeight = item.GoodsWeight,
                                    InventoryNum = item.InventoryNum,
                                    MallBaseId = demodel.MallBaseId,
                                    SellingPrice = item.SellingPrice,
                                    SpecificationSort = item.SpecificationSort,
                                    Status = 0,
                                    TenantId = demodel.TenantId,
                                    UpdateDate = demodel.UpdateDate
                                }, trans);
                            }
                        }
                        //插入区域
                        foreach (var item in demodel.AreaList) {
                            goods_AreaRepository.Insert(new RB_Goods_Area()
                            {
                                AreaId = item.AreaId,
                                AreaType = item.AreaType,
                                CreateDate = demodel.CreateDate,
                                GoodsId = Id,
                                Id = 0,
                                MallBaseId = demodel.MallBaseId,
                                Status = 0,
                                TenantId = demodel.TenantId
                            }, trans);
                        }
                        //插入卡卷
                        //插入分销佣金
                        if (demodel.SeparateDistribution == 1) {
                            foreach (var item in demodel.DistributionCommissionList)
                            {
                                goods_DistributionCommissionRepository.Insert(new RB_Goods_DistributionCommission()
                                {
                                    CreateDate = demodel.CreateDate,
                                    GoodsId = Id,
                                    Id = 0,
                                    DistributorGrade = item.DistributorGrade,
                                    OneCommission = item.OneCommission,
                                    ThreeCommission = item.ThreeCommission,
                                    TwoCommission = item.TwoCommission,
                                    MallBaseId = demodel.MallBaseId,
                                    SpecificationSort = item.SpecificationSort,
                                    Status = 0,
                                    TenantId = demodel.TenantId,
                                    UpdateDate = demodel.UpdateDate
                                }, trans);
                            }
                        }
                        //插入会员价格
                        if (demodel.EnjoyMember == 1 && demodel.SeparateSetMember == 1) {
                            foreach (var item in demodel.MemberPriceList)
                            {
                                goods_MemberPriceRepository.Insert(new RB_Goods_MemberPrice()
                                {
                                    CreateDate = demodel.CreateDate,
                                    GoodsId = Id,
                                    Id = 0,
                                    MemberGrade = item.MemberGrade,
                                    MemberPrice = item.MemberPrice,
                                    MallBaseId = demodel.MallBaseId,
                                    SpecificationSort = item.SpecificationSort,
                                    Status = 0,
                                    TenantId = demodel.TenantId,
                                    UpdateDate = demodel.UpdateDate
                                }, trans);
                            }
                        }
                    }
                }
                goodsRepository.DBSession.Commit();
                return true;
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "SetProductGoodsInfo");
                goodsRepository.DBSession.Rollback();
                return false;
            }
        }

        /// <summary>
        /// 获取商品详情
        /// </summary>
        /// <param name="goodsId"></param>
        /// <returns></returns>
        public RB_Goods_Extend GetProductGoodsInfo(int goodsId,int TenantId,int MallBaseId)
        {
            var model = goodsRepository.GetEntity(goodsId).RefMapperTo<RB_Goods_Extend>();
            if (model == null || model.TenantId != TenantId || model.MallBaseId != MallBaseId){
                return null;
            }
            model.CategoryList = goods_CategoryRepository.GetList(new RB_Goods_Category_Extend() { GoodsId = goodsId, TenantId = TenantId, MallBaseId = MallBaseId });
            model.SpecificationList = new List<RB_Goods_Specification_Extend>();
            model.SpecificationPriceList = new List<RB_Goods_SpecificationPrice_Extend>();
            if (model.IsCustomSpecification == 1) {
                model.SpecificationList = goods_SpecificationRepository.GetList(new RB_Goods_Specification_Extend() { GoodsId = goodsId, TenantId = TenantId, MallBaseId = MallBaseId });
                if (model.SpecificationList.Any()) {
                    var svlist = goods_SpecificationValueRepository.GetList(new RB_Goods_SpecificationValue_Extend() { GoodsId = goodsId, TenantId = TenantId, MallBaseId = MallBaseId });
                    if (svlist.Where(x => x.Image > 0).Any()) {
                        string imgIds = string.Join(",", svlist.Where(x => x.Image > 0).Select(x => x.Image).Distinct());
                        var mlist = material_InfoRepository.GetList(new RB_Material_Info_Extend() { MaterialIds = imgIds, TenantId = TenantId, MallBaseId = MallBaseId });
                        foreach (var item in svlist.Where(x => x.Image > 0)) {
                            item.ImagePath = mlist.Where(x => x.Id == item.Image).FirstOrDefault()?.Path ?? "";
                        }
                    }
                    foreach (var item in model.SpecificationList) {
                        item.SpecificationValueList = svlist.Where(x => x.SpecificationId == item.Id).ToList();
                    }
                }
                model.SpecificationPriceList = goods_SpecificationPriceRepository.GetList(new RB_Goods_SpecificationPrice_Extend() { GoodsId = goodsId, TenantId = TenantId, MallBaseId = MallBaseId });
            }
            model.AreaList = new List<RB_Goods_Area_Extend>();
            if (model.IsAreaBuy == 1) {
                model.AreaList = goods_AreaRepository.GetList(new RB_Goods_Area_Extend() { GoodsId = goodsId, TenantId = TenantId, MallBaseId = MallBaseId });
            }
            model.DistributionCommissionList = new List<RB_Goods_DistributionCommission_Extend>();
            if (model.SeparateDistribution == 1) {
                model.DistributionCommissionList = goods_DistributionCommissionRepository.GetList(new RB_Goods_DistributionCommission_Extend() { GoodsId = goodsId, TenantId = TenantId, MallBaseId = MallBaseId });
            }
            model.MemberPriceList = new List<RB_Goods_MemberPrice_Extend>();
            if (model.EnjoyMember == 1 && model.SeparateSetMember == 1){
                model.MemberPriceList = goods_MemberPriceRepository.GetList(new RB_Goods_MemberPrice_Extend() { GoodsId = goodsId, TenantId = TenantId, MallBaseId = MallBaseId });
            }
            model.CarouselImageList = new List<RB_ImageCommonModel>();
            if (!string.IsNullOrEmpty(model.CarouselImage) && model.CarouselImage != "[]")
            {
                List<int> CarouselIdList = JsonConvert.DeserializeObject<List<int>>(model.CarouselImage);
                //轮播图
                var mlist = material_InfoRepository.GetList(new RB_Material_Info_Extend() { MaterialIds = string.Join(",", CarouselIdList), TenantId = TenantId, MallBaseId = MallBaseId });
                foreach (var item in CarouselIdList) {
                    var cmodel = mlist.Where(x => x.Id == item).FirstOrDefault();
                    model.CarouselImageList.Add(new RB_ImageCommonModel()
                    {
                        Id = item,
                        Name = cmodel?.Name ?? "",
                        Path = cmodel?.Path ?? ""
                    });
                }
            }
            if (model.CustomShareImage > 0) {
                model.CustomShareImagePath = material_InfoRepository.GetEntity(model.CustomShareImage)?.Path ?? "";
            }
            //服务列表
            model.ServiceList = new List<RB_ImageCommonModel>();
            if (model.IsDefaultService == 2)
            {
                if (!string.IsNullOrEmpty(model.GoodsService) && model.GoodsService != "[]") {
                    List<int> ServiceIds = JsonConvert.DeserializeObject<List<int>>(model.GoodsService);
                    var slist = product_ServiceRepository.GetList(new RB_Product_Service_Extend() { ServiceIds = string.Join(",", ServiceIds), TenantId = TenantId, MallBaseId = MallBaseId });
                    foreach (var item in slist) {
                        model.ServiceList.Add(new RB_ImageCommonModel()
                        {
                            Id = item.Id,
                            Name = item.Name
                        });
                    }
                }
            }
            //运费
            if (model.FreightId > 0)
            {
                model.FreightName = logistics_RulesRepository.GetEntity(model.FreightId)?.RulesName ?? "";
            }
            else {
                model.FreightName = "默认运费";
            }
            //表单
            if (model.FormsId > 0)
            {
                model.FormsName = "未建表";
            }
            else {
                model.FormsName = "默认表单";
            }

            return model;
        }

        /// <summary>
        /// 快速修改
        /// </summary>
        /// <param name="goodsId"></param>
        /// <param name="type"></param>
        /// <param name="sort"></param>
        /// <param name="goodsName"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool SetProductGoodsQuickUpdate(int goodsId, int type, int sort, string goodsName, int tenantId, int mallBaseId)
        {
            Dictionary<string, object> keyValues;
            if (type == 1)
            {
                keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Goods.Sort),sort}
                };
            }
            else if (type == 2)
            {
                keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Goods.Name),goodsName}
                };
            }
            else if (type == 3)
            {
                var model = goodsRepository.GetEntity(goodsId);
                if (model == null) {
                    return false;
                }
                keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Goods.IsQuickBuy),model.IsQuickBuy==1?2:1}
                };
            }
            else {
                return false;
            }
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Goods.Id),
                        FiledValue=goodsId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Goods.TenantId),
                        FiledValue=tenantId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Goods.MallBaseId),
                        FiledValue=mallBaseId,
                        OperatorEnum=OperatorEnum.Equal
                }
            };
            return goodsRepository.Update(keyValues, wheres);
        }

        /// <summary>
        /// 快速修改
        /// </summary>
        /// <param name="goodsIds"></param>
        /// <param name="type"></param>
        /// <param name="sort"></param>
        /// <param name="goodsName"></param>
        /// <param name="freightId"></param>
        /// <param name="limitBuyGoodsNum"></param>
        /// <param name="limitBuyOrderNum"></param>
        /// <param name="integralPresent"></param>
        /// <param name="integralPresentType"></param>
        /// <param name="pointsDeduction"></param>
        /// <param name="pointsDeductionType"></param>
        /// <param name="isMultipleDeduction"></param>
        /// <param name="isQuickBuy"></param>
        /// <param name="isGoodsNegotiable"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool SetProductGoodsQuickUpdate(string goodsIds, int type, int sort, string goodsName, int freightId, int limitBuyGoodsNum, int limitBuyOrderNum, int integralPresent, int integralPresentType, decimal pointsDeduction, int pointsDeductionType, int isMultipleDeduction, int isQuickBuy, int isGoodsNegotiable, int tenantId, int mallBaseId)
        {
            Dictionary<string, object> keyValues;
            if (type == 1)
            {
                keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Goods.Sort),sort}
                };
            }//排序
            else if (type == 2)
            {
                keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Goods.Name),goodsName}
                };
            }//商品名称
            else if (type == 3)
            {
                var model = goodsRepository.GetEntity(Convert.ToInt32(goodsIds));
                if (model == null)
                {
                    return false;
                }
                keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Goods.IsQuickBuy),model.IsQuickBuy==1?2:1}
                };
            }//单个快速购买
            else if (type == 4)
            {
                keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Goods.GoodsStatus),1}
                };
            }//上架
            else if (type == 5)
            {
                keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Goods.GoodsStatus),2}
                };
            }//下架
            else if (type == 6)
            {
                keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Goods.Status),1}
                };
            }//删除
            else if (type == 7)
            {
                keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Goods.FreightId),freightId}
                };
            }//运费
            else if (type == 8)
            {
                keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Goods.LimitBuyGoodsNum),limitBuyGoodsNum},
                    { nameof(RB_Goods.LimitBuyOrderNum),limitBuyOrderNum},
                };
            }//限购
            else if (type == 9)
            {
                keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Goods.IntegralPresent),integralPresent},
                    { nameof(RB_Goods.IntegralPresentType),integralPresentType},
                    { nameof(RB_Goods.PointsDeduction),pointsDeduction},
                    { nameof(RB_Goods.PointsDeductionType),pointsDeductionType},
                    { nameof(RB_Goods.IsMultipleDeduction),isMultipleDeduction},
                };
            }//积分
            else if (type == 10)
            {
                keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Goods.IsQuickBuy),isQuickBuy}
                };
            }//批量快速购买
            else if (type == 11)
            {
                keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Goods.IsGoodsNegotiable),isGoodsNegotiable}
                };
            }//面议
            else
            {
                return false;
            }
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Goods.Id),
                        FiledValue=goodsIds,
                        OperatorEnum=OperatorEnum.IN
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Goods.TenantId),
                        FiledValue=tenantId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Goods.MallBaseId),
                        FiledValue=mallBaseId,
                        OperatorEnum=OperatorEnum.Equal
                }
            };
            return goodsRepository.Update(keyValues, wheres);
        }

        /// <summary>
        /// 删除商品
        /// </summary>
        /// <param name="goodsId"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool DelProcudtGoodsInfo(int goodsId, int tenantId, int mallBaseId)
        {
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Goods.Status),1},
                { nameof(RB_Goods.UpdateDate),DateTime.Now}
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Goods.Id),
                        FiledValue=goodsId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Goods.TenantId),
                        FiledValue=tenantId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Goods.MallBaseId),
                        FiledValue=mallBaseId,
                        OperatorEnum=OperatorEnum.Equal
                }
            };
            return goodsRepository.Update(keyValues, wheres);
        }

        /// <summary>
        /// 获取会员等级列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Member_Grade_Extend> GetMemberGradeList(RB_Member_Grade_Extend dmodel)
        {
            var list = member_GradeRepository.GetList(dmodel);
            return list;
        }

        /// <summary>
        /// 获取分销等级列表
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Distributor_Grade_Extend> GetDistributorGradeList(RB_Distributor_Grade_Extend demodel)
        {
            var list = distributor_GradeRepository.GetList(demodel);
            return list;
        }

        #endregion
    }
}
