﻿using Mall.Model.Entity.AppletWeChat;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.AppletWeChat
{
    /// <summary>
    /// 微信小程序基础配置
    /// </summary>
    public class RB_AppletWeChatRepository : RepositoryBase<RB_AppletWeChat>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_AppletWeChat); } }



        /// <summary>
        /// 获取微信基础配置
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_AppletWeChat> GetAppletWeChatList(RB_AppletWeChat query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE 1=1 ");
            if (query != null)
            {
                if (query.ID > 0)
                {
                    builder.Append($" AND {nameof(RB_AppletWeChat.ID)}={query.ID}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_AppletWeChat.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_AppletWeChat.MallBaseId)}={query.MallBaseId}");
                }

            }
            return Get<RB_AppletWeChat>(builder.ToString()).ToList();
        }
    }
}
