﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Model.Entity.AppletWeChat;
using Mall.Module.AppletWeChat;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json.Linq;

namespace Mall.WebApi.Controllers.AppletWeChat
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class PublishController : BaseController
    {

        private AppletWeChatModule appletWeChatModule = new AppletWeChatModule();
        string projectUrl = Mall.Common.Config.ProjectUrl;
        string developerKitsPort = Mall.Common.Config.DeveloperKitsPort;


        /// <summary>
        /// 发布微信小程序获取登录二维码
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetLoginAppletWeChat()
        {
            var parms = RequestParm;
            var query = new RB_AppletWeChat();
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var model = appletWeChatModule.GetAppletWeChatList(query).FirstOrDefault();
            if (model == null)
            {
                return ApiResult.Failed("您还未配置微信小程序基础信息");
            }

            try
            {
                string URL = $"http://127.0.0.1:{developerKitsPort}/v2/login?qr-format=base64&project=&appid={model.AppId}&ext-appid=";
                string result = Mall.Common.Plugin.HttpHelper.HttpGet(URL, Encoding.UTF8, "");
                JObject parmsJob = JObject.Parse(result);
                string imgUrl = parmsJob.GetValue("qrcode").ToString();
                if (parmsJob.ContainsKey("code"))
                {
                    return ApiResult.Failed(parmsJob.GetValue("message").ToString());
                }
                return ApiResult.Success("获取成功", imgUrl);
            }
            catch (Exception ex)
            {
                return ApiResult.Failed("获取登录二维码识别");
            }
        }

        /// <summary>
        /// 获取项目预览二维码
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetPreviewAppletWeChat()
        {
            try
            {
                string URL = $"http://127.0.0.1:{developerKitsPort}/v2/preview?project={Mall.Common.Plugin.StringHelper.UrlEncode(projectUrl)}&qr-format=base64";
                string result = Mall.Common.Plugin.HttpHelper.HttpGet(URL, Encoding.UTF8, "");
                JObject parmsJob = JObject.Parse(result);
                if (parmsJob.ContainsKey("code"))
                {
                    return ApiResult.Failed(parmsJob.GetValue("message").ToString());
                }
                if (!result.Contains("data:image/png;base64,"))
                {
                    result = "data:image/png;base64," + result;
                }
                return ApiResult.Success("获取成功", result);
            }
            catch (Exception ex)
            {
                return ApiResult.Failed("获取登录二维码识别");
            }
        }


        /// <summary>
        /// 获取项目预览二维码
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetPuploadAppletWeChat()
        {
            var parms = RequestParm;
            var query = new RB_AppletWeChat();
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var model = appletWeChatModule.GetAppletWeChatList(query).FirstOrDefault();
            if (model == null)
            {
                return ApiResult.Failed("您还未配置微信小程序基础信息");
            }

            try
            {
                string URL = $"http://127.0.0.1:{developerKitsPort}/v2/upload?project={Mall.Common.Plugin.StringHelper.UrlEncode(projectUrl)}&version=v1.0.0&desc=微信开发者工具HTTP上传&appid={model.AppId}";
                string result = Mall.Common.Plugin.HttpHelper.HttpGet(URL, Encoding.UTF8, "");
                JObject parmsJob = JObject.Parse(result);
                if (parmsJob.ContainsKey("code"))
                {
                    return ApiResult.Failed(parmsJob.GetValue("message").ToString());
                }
                return ApiResult.Success("上传成功", result);
            }
            catch (Exception ex)
            {
                return ApiResult.Failed("上传失败");
            }
        }


    }
}