﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Model.Extend.Product;
using Mall.Module.User;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Mall.Common.Plugin;
using Mall.Common.Enum.User;
using Mall.CacheManager.User;
using Newtonsoft.Json.Linq;
using Mall.Common;
using Mall.Module.Product;

namespace Mall.WebApi.Controllers.MallBase
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class AppletGoodsController : ControllerBase
    {

        private readonly ProductModule productModule = new ProductModule();

        #region 商品分类

        /// <summary>
        /// 获取商品分类分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetProductCategoryPageList(object requestMsg)
        {
            var parms = JsonConvert.DeserializeObject<RequestParm>(requestMsg.ToString());
            if (parms.MallBaseId <= 0)
            {
                return ApiResult.ParamIsNull();
            }
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(parms.msg.ToString());
            RB_Product_Category_Extend demodel = JsonConvert.DeserializeObject<RB_Product_Category_Extend>(parms.msg.ToString());
            
            demodel.TenantId = parms.TenantId;
            demodel.MallBaseId = parms.MallBaseId;
            demodel.Enabled = 1;
            demodel.IsShow = 1;
            var list = productModule.GetProductCategoryPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.Id,
                x.Name,
                x.Tier,
                x.ParentId,
                x.Sort,
                x.Icon,
                x.IconPath,
                x.BigIcon,
                x.BigIconPath,
                x.AdvertisingImage,
                x.AdvertisingImagePath,
                x.AdvertisingAddress,
                CreateDate = x.CreateDate.HasValue ? x.CreateDate.Value.ToString("yyyy-MM-dd") : ""
            });
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 获取分类树形结构
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetProductCategoryTreeList(object requestMsg) {
            var parms = JsonConvert.DeserializeObject<RequestParm>(requestMsg.ToString());
            if (parms.MallBaseId <= 0)
            {
                return ApiResult.ParamIsNull();
            }
            RB_Product_Category_Extend demodel = JsonConvert.DeserializeObject<RB_Product_Category_Extend>(parms.msg.ToString());

            demodel.TenantId = parms.TenantId;
            demodel.MallBaseId = parms.MallBaseId;
            demodel.Enabled = 1;
            demodel.IsShow = 1;
            var list = productModule.GetProductCategoryTreeList(demodel);
            return ApiResult.Success("", list);
        }

        /// <summary>
        /// 获取分类样式
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetProductCategoryStyleInfo(object requestMsg) {
            var parms = JsonConvert.DeserializeObject<RequestParm>(requestMsg.ToString());
            if (parms.MallBaseId <= 0)
            {
                return ApiResult.ParamIsNull();
            }
            var model = productModule.GetProductCategoryStyleInfo(parms.TenantId, parms.MallBaseId);
            return ApiResult.Success("", new
            {
                model.Id,
                model.Type,
                model.Style,
                model.CategoryNum,
                model.RowNum,
                UpdateDate = model.UpdateDate.Value.ToString("yyyy-MM-dd HH:mm:ss")
            });
        }

        #endregion

        #region 商品列表

        /// <summary>
        /// 小程序分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetAppletGoodsPageList(object requestMsg) {
            var parms = JsonConvert.DeserializeObject<RequestParm>(requestMsg.ToString());
            if (parms.MallBaseId <= 0)
            {
                return ApiResult.ParamIsNull();
            }
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(parms.msg.ToString());
            RB_Goods_Extend demodel = JsonConvert.DeserializeObject<RB_Goods_Extend>(parms.msg.ToString());

            demodel.TenantId = parms.TenantId;
            demodel.MallBaseId = parms.MallBaseId;
            demodel.GoodsStatus = 1;//只查询销售中的
            var list = productModule.GetAppletGoodsPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.Id,
                x.Name,
                x.Sort,
                x.CoverImage,
                x.SellingPrice,                
                x.SalesNum,
                x.IsQuickBuy,                
                CreateDate = x.CreateDate.HasValue ? x.CreateDate.Value.ToString("yyyy-MM-dd HH:mm:ss") : ""
            });
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 获取小程序商品详情
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetAppletGoodsInfo(object requestMsg) {
            var req = JsonConvert.DeserializeObject<RequestParm>(requestMsg.ToString());
            if (req.MallBaseId <= 0)
            {
                return ApiResult.ParamIsNull();
            }
            JObject prams = JObject.Parse(req.msg.ToString());
            int GoodsId = prams.GetInt("GoodsId", 0);
            if (GoodsId <= 0) {
                return ApiResult.ParamIsNull();
            }

            var model = productModule.GetAppletGoodsInfo(GoodsId, req.TenantId, req.MallBaseId);
            return ApiResult.Success("", new
            {
                model.Id,
                model.Name,
                model.CarouselImage,
                model.VideoAddress,
                model.CustomShareTitles,
                model.CustomShareImage,
                model.CustomShareImagePath,
                model.GoodsStatus,
                model.InventoryNum,
                model.DefaultSpecificationName,
                model.IsCustomSpecification,
                model.Sort,
                model.SellingPrice,
                model.OriginalPrice,
                model.Unit,
                model.CostPrice,
                model.IsGoodsNegotiable,
                model.SalesNum,
                model.GoodsNumbers,
                model.GoodsWeight,
                model.IsDefaultService,
                model.GoodsService,
                model.FreightId,
                model.FreightName,
                model.FormsId,
                model.FormsName,
                model.LimitBuyGoodsNum,
                model.LimitBuyOrderNum,
                model.FullNumPinkage,
                model.FullMoneyPinkage,
                model.IsAreaBuy,
                model.IntegralPresent,
                model.IntegralPresentType,
                model.PointsDeduction,
                model.PointsDeductionType,
                model.IsMultipleDeduction,
                model.GoodsDetails,
                model.SeparateDistribution,
                model.SeparateDistributionType,
                model.SeparateDistributionMoneyType,
                model.EnjoyMember,
                model.SeparateSetMember,
                model.IsQuickBuy,
                CategoryList= model.CategoryList.Select(x=>new { 
                    x.Id,
                     x.CategoryId,
                     x.CategoryName
                }),
                SpecificationList= model.SpecificationList.Select(x=>new { 
                    x.Id,
                    x.EnabledImage,
                    x.Name,
                    x.Sort,
                    SpecificationValueList= x.SpecificationValueList.Select(y=>new { 
                        y.Id,
                        y.Image,
                        y.ImagePath,
                        y.Name,
                        y.Sort
                    })
                }),
                SpecificationPriceList= model.SpecificationPriceList.Select(x=>new { 
                    x.Id,
                    x.GoodsNumbers,
                    x.GoodsWeight,
                    x.InventoryNum,
                    x.SellingPrice,
                    x.SpecificationSort
                }),
                AreaList= model.AreaList.Select(x=>new { 
                    x.Id,
                    x.AreaId,
                    x.AreaName,
                    x.AreaType
                }),
                DistributionCommissionList= model.DistributionCommissionList.Select(x=>new { 
                    x.Id,
                    x.DistributorGrade,
                    x.OneCommission,
                    x.SpecificationSort,
                    x.ThreeCommission,
                    x.TwoCommission
                }),
                MemberPriceList= model.MemberPriceList.Select(x=>new { 
                    x.Id,
                    x.MemberGrade,
                    x.MemberPrice,
                    x.SpecificationSort
                }),
                model.CarouselImageList,
                model.ServiceList
            });
        }

        #endregion
    }
}