﻿using VT.FW.DB;
using Mall.Common.Enum.MarketingCenter;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.MarketingCenter
{
    /// <summary>
    /// 小程序自定义页面实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Miniprogram_Page_Templ
    {
        /// <summary>
        /// 主键
        /// </summary>        
        public int Id
        {
            get;
            set;
        }

        /// <summary>
        /// 页面名称
        /// </summary>        
        public string PageName
        {
            get;
            set;
        }

        /// <summary>
        /// 启用1,禁用0
        /// </summary>        
        public int? IsUse
        {
            get;
            set;
        }

        /// <summary>
        /// 是否显示导航条(0-不显示,1-显示）
        /// </summary>        
        public int? IsShowNav
        {
            get;
            set;
        }

        /// <summary>
        /// 是否为首页(0-否,1-是)
        /// </summary>        
        public int? IsHome
        {
            get;
            set;
        }

        /// <summary>
        /// 商户号Id
        /// </summary>        
        public int? TenantId
        {
            get;
            set;
        }

        /// <summary>
        /// 小程序Id
        /// </summary>        
        public int? MallBaseId
        {
            get;
            set;
        }

        /// <summary>
        /// 创建日期
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }

        /// <summary>
        /// 创建人
        /// </summary>        
        public int? CreateBy
        {
            get;
            set;
        }

        /// <summary>
        /// 状态
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }

        /// <summary>
        /// 是否为校园版首页
        /// </summary>
        public int IsSchoolHomePage { get; set; }

        /// <summary>
        /// 是否显示底部导航(是否显示底部导航栏(1-显示)
        /// </summary>
        public int IsShowBottomTabBar { get; set; }

        /// <summary>
        /// 不显示标题(1-不显示,0-显示)
        /// </summary>
        public int IsNoShowTitle { get; set; }
    }
}
