﻿using Mall.CacheManager.AppletWeChat;
using Mall.CacheManager.DataStatistic;
using Mall.Common;
using Mall.Common.Enum;
using Mall.Common.Plugin;
using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;
using Mall.Module.User;
using Mall.Repository.TradePavilion;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using RabbitMQ.Client.Framing.Impl;
using System;
using System.Collections.Generic;
using System.Linq;
using VT.FW.DB;
using static ICSharpCode.SharpZipLib.Zip.ExtendedUnixData;

namespace Mall.Module.TradePavilion
{
    /// <summary>
    /// 宜宾商载通新方法处理类
    /// </summary>
    public partial class BuildingCarrierModule
    {
        /// <summary>
        /// 【商载通】品牌/企业申请仓储层
        /// </summary>
        private readonly RB_BrandEnterpriseApplyForRepository brandEnterpriseApplyForRepository = new RB_BrandEnterpriseApplyForRepository();


        /// <summary>
        /// 【商载通】品牌/企业申请仓储层
        /// </summary>
        private readonly RB_CarrierEnterpriseApplyForRepository carrierEnterpriseApplyForRepository = new RB_CarrierEnterpriseApplyForRepository();

        /// <summary>
        /// 【商载通】地铁申请仓储层
        /// </summary>
        private readonly RB_CarrierEnterpriseMetroApplyForRepository carrierEnterpriseMetroApplyForRepository = new RB_CarrierEnterpriseMetroApplyForRepository();

        /// <summary>
        /// 【商载通】公司仓储层
        /// </summary>
        private readonly RB_CompanyEnterpriseRepository companyEnterpriseRepository = new RB_CompanyEnterpriseRepository();
        /// <summary>
        /// 用户
        /// </summary>
        private readonly Repository.User.RB_Member_UserRepository member_UserRepository = new Repository.User.RB_Member_UserRepository();
        /// <summary>
        /// 企业服务
        /// </summary>
        private readonly RB_EnterpriseServicesApplyRepository enterpriseServicesApplyRepository = new RB_EnterpriseServicesApplyRepository();

        /// <summary>
        /// 楼宇入驻仓储层
        /// </summary>
        private readonly RB_BuildingApplyForRepository buildingApplyForRepository = new RB_BuildingApplyForRepository();


        /// <summary>
        /// 收藏仓储层对象
        /// </summary>
        private readonly RB_CollectRepository collectRepository = new RB_CollectRepository();
        #region 品牌/企业
        /// <summary>
        /// 品牌/企业申请信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_BrandEnterpriseApplyFor_Extend> GetCarrierEnterpriseApplyForModule(RB_BrandEnterpriseApplyFor_Extend query)
        {
            return brandEnterpriseApplyForRepository.GetCarrierEnterpriseApplyForRepository(query);

        }

        /// <summary>
        /// 品牌/企业申请信息列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_BrandEnterpriseApplyFor_Extend> GetBrandEnterpriseApplyForPageList(int pageIndex, int pageSize, out long rowCount, RB_BrandEnterpriseApplyFor_Extend query)
        {
            var list = brandEnterpriseApplyForRepository.GetBrandEnterpriseApplyForPageList(pageIndex, pageSize, out rowCount, query);

            return list;
        }

        /// <summary>
        /// 根据id获取品牌/企业详情信息
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public RB_BrandEnterpriseApplyFor_Extend GetCarrierEnterpriseApplyForEntity(int ID)
        {

            return brandEnterpriseApplyForRepository.GetEntity(ID).RefMapperTo<RB_BrandEnterpriseApplyFor_Extend>();
        }



        /// <summary>
        ///删除品牌/企业申请信息状态
        /// </summary>
        /// <param name="CompanyId"></param>
        /// <param name="Status"></param>
        /// <returns></returns>
        public bool RemoveBrandEnterpriseApplyForModule(int ID)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Carrier_Extend.Status), (int)DateStateEnum.Delete},
            };
            bool flag = brandEnterpriseApplyForRepository.Update(fileds, new WhereHelper(nameof(RB_BrandEnterpriseApplyFor_Extend.ID), ID));
            return flag;
        }
        /// <summary>
        /// 新增/修改品牌/企业申请信息
        /// </summary>
        /// <returns></returns>
        public bool SetCarrierEnterpriseApplyFor(RB_BrandEnterpriseApplyFor_Extend model)
        {
            bool flag = false;
            var cmodel = companyEnterpriseRepository.GetEntity(model.CompanyId);
            if (cmodel == null) { return false; }
            if (cmodel.FirstShopType != 1) { return false; }
            //更新认证表  资料状态为完成
            Dictionary<string, object> keyValues = new Dictionary<string, object>()
            {
                { nameof(RB_CompanyEnterprise_Extend.IsComplete),1}
            };
            List<WhereHelper> wheres = new List<WhereHelper>()
            {
                new WhereHelper()
                {
                    FiledName=nameof(RB_CompanyEnterprise_Extend.CompanyId),
                    FiledValue= model.CompanyId,
                    OperatorEnum=OperatorEnum.Equal
                }
            };
            if (model.ID > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.UpdateDate),model.UpdateDate },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.Logo),model.Logo },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.Banner),model.Banner },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.VideoUrl),model.VideoUrl },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.FullBrandName),model.FullBrandName },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.BrandName),model.BrandName },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.ShopNum),model.ShopNum },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.BuiltUpArea),model.BuiltUpArea },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.EndBuiltUpArea),model.EndBuiltUpArea },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.BrandType),model.BrandType },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.CustomerType),model.CustomerType },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.StoreExpansion),model.StoreExpansion },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.ProjectType),model.ProjectType },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.AreaRequirement),model.AreaRequirement },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.EndAreaRequirement),model.EndAreaRequirement },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.Advertising),model.Advertising },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.Other),model.Other },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.ShopSize),model.ShopSize },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.Plumbing),model.Plumbing },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.Caliber),model.Caliber },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.Sewage),model.Sewage },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.RanQi),model.RanQi },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.DianLiang),model.DianLiang },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.PaiYan),model.PaiYan },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.KongTiao),model.KongTiao },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.XinFeng),model.XinFeng },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.BrandClassId),model.BrandClassId },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.RanQiBZ),model.RanQiBZ },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.IsDianLiang),model.IsDianLiang },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.PaiYanBZ),model. PaiYanBZ },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.IsShopSize),model.IsShopSize },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.OpenShopWish),model.OpenShopWish },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.IsInChengdu),model.IsInChengdu },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.ExistBrandId),model.ExistBrandId },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.Introduce),model. Introduce },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.DevIntention),model.DevIntention },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.PropertyDemand),model.PropertyDemand },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.Cooperation),model.Cooperation },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.Complementary),model.Complementary },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.ContactName),model.ContactName },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.ContactPhone),model.ContactPhone },
                };
                flag = brandEnterpriseApplyForRepository.Update(fileds, new WhereHelper(nameof(RB_BrandEnterpriseApplyFor_Extend.ID), model.ID));
            }
            else
            {
                #region 验证品牌数据是否已存在
                var oldList = brandEnterpriseApplyForRepository.GetCarrierEnterpriseApplyForRepository(new RB_BrandEnterpriseApplyFor_Extend() { MallBaseId = model.MallBaseId, CompanyId = model.CompanyId });
                if (oldList != null && oldList.Any())
                {
                    return false;
                }
                #endregion
                flag = brandEnterpriseApplyForRepository.Insert(model) > 0;
                if (flag)
                {
                    if (Config.IsCPSWJAutoExamine == "1")//自动审核
                    {
                        keyValues.Add(nameof(RB_CompanyEnterprise_Extend.CompanyStatus), 1);
                        try
                        {
                            var BrandModel = oldList?.FirstOrDefault();
                            if ((BrandModel?.ExistBrandId ?? 0) > 0)
                            {
                                Dictionary<string, object> filedsBrand = new Dictionary<string, object>()
                                 {
                                            { nameof(RB_Brand_Enterprise_Extend.BrandName),BrandModel.BrandName},
                                            { nameof(RB_Brand_Enterprise_Extend.FullBrandName),BrandModel.FullBrandName},
                                            { nameof(RB_Brand_Enterprise_Extend.VideoUrl),BrandModel.VideoUrl},
                                            { nameof(RB_Brand_Enterprise_Extend.Logo),BrandModel.Logo},
                                            { nameof(RB_Brand_Enterprise_Extend.Banner),BrandModel.Banner},
                                            { nameof(RB_Brand_Enterprise_Extend.ShopNum),BrandModel.ShopNum},
                                            { nameof(RB_Brand_Enterprise_Extend.BuiltUpArea),BrandModel.BuiltUpArea},
                                            { nameof(RB_Brand_Enterprise_Extend.EndBuiltUpArea),BrandModel.EndBuiltUpArea},
                                            { nameof(RB_Brand_Enterprise_Extend.BrandType),BrandModel.BrandType},
                                            { nameof(RB_Brand_Enterprise_Extend.CustomerType),BrandModel.CustomerType},
                                            { nameof(RB_Brand_Enterprise_Extend.AreaRequirement),BrandModel.AreaRequirement},
                                            { nameof(RB_Brand_Enterprise_Extend.EndAreaRequirement),BrandModel.EndAreaRequirement},
                                            { nameof(RB_Brand_Enterprise_Extend.CategoryId),BrandModel.BrandClassId},
                                            { nameof(RB_Brand_Enterprise_Extend.BrandEnterpriseType),BrandModel.BrandEnterpriseType},
                                            { nameof(RB_Brand_Enterprise_Extend.Introduce),BrandModel.Introduce},
                                            { nameof(RB_Brand_Enterprise_Extend.DevIntention),BrandModel.DevIntention},
                                            { nameof(RB_Brand_Enterprise_Extend.PropertyDemand),BrandModel.PropertyDemand},
                                            { nameof(RB_Brand_Enterprise_Extend.Cooperation),BrandModel.Cooperation},
                                            { nameof(RB_Brand_Enterprise_Extend.Complementary),BrandModel.Complementary},
                                             {nameof(RB_Brand_Enterprise_Extend.ContactName),BrandModel.ContactName },
                                            {nameof(RB_Brand_Enterprise_Extend.ContactPhone),BrandModel.ContactPhone },
                                };
                                brand_EnterpriseRepository.Update(filedsBrand, new WhereHelper(nameof(RB_Brand_Enterprise_Extend.ID), BrandModel.ExistBrandId));
                            }
                            else
                            {
                                #region 新增品牌
                                var inserBModel = BrandModel.RefMapperTo<RB_Brand_Enterprise_Extend>();
                                inserBModel.ID = 0;
                                inserBModel.UserId = cmodel.CreateBy;
                                brand_EnterpriseRepository.Insert(inserBModel);
                                #endregion
                            }
                        }
                        catch
                        {
                        }
                    }
                }
            }
            if (flag)
            {  //更新认证表  资料状态为完成
                companyEnterpriseRepository.Update(keyValues, wheres);
            }
            return flag;
        }

        /// <summary>
        /// 新增/修改企业申请信息
        /// </summary>
        /// <returns></returns>
        public bool SetEnterpriseServicesApply(RB_EnterpriseServicesApply_Extend model)
        {
            bool flag = false;
            var cmodel = companyEnterpriseRepository.GetEntity(model.CompanyId);
            if (cmodel == null) { return false; }
            if (cmodel.FirstShopType != 3) { return false; }
            //更新认证表  资料状态为完成
            Dictionary<string, object> keyValues = new Dictionary<string, object>()
            {
                { nameof(RB_CompanyEnterprise_Extend.IsComplete),1}
            };
            List<WhereHelper> wheres = new List<WhereHelper>()
            {
                new WhereHelper()
                {
                    FiledName=nameof(RB_CompanyEnterprise_Extend.CompanyId),
                    FiledValue= model.CompanyId,
                    OperatorEnum=OperatorEnum.Equal
                }
            };
            if (model.ID > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_EnterpriseServicesApply_Extend.Name),model.Name},
                    { nameof(RB_EnterpriseServicesApply_Extend.Banner),model.Banner},
                    { nameof(RB_EnterpriseServicesApply_Extend.Introduction),model.Introduction},
                    { nameof(RB_EnterpriseServicesApply_Extend.DevIntention),model.DevIntention},
                    { nameof(RB_EnterpriseServicesApply_Extend.Address),model.Address},
                    { nameof(RB_EnterpriseServicesApply_Extend.LatAndLon),model.LatAndLon},
                    { nameof(RB_EnterpriseServicesApply_Extend.OperationTime),model.OperationTime},
                    { nameof(RB_EnterpriseServicesApply_Extend.CategoryId),model.CategoryId},
                    { nameof(RB_EnterpriseServicesApply_Extend.Renovation),model.Renovation},
                    { nameof(RB_EnterpriseServicesApply_Extend.Payment),model.Payment},
                    { nameof(RB_EnterpriseServicesApply_Extend.HandoverDate),model.HandoverDate},
                    { nameof(RB_EnterpriseServicesApply_Extend.IntentionalFloor),model.IntentionalFloor},
                    { nameof(RB_EnterpriseServicesApply_Extend.ElevatorNum),model.ElevatorNum},
                    { nameof(RB_EnterpriseServicesApply_Extend.PropertyFee),model.PropertyFee},
                    { nameof(RB_EnterpriseServicesApply_Extend.RentFee),model.RentFee},
                    { nameof(RB_EnterpriseServicesApply_Extend.ContactName),model.ContactName},
                    { nameof(RB_EnterpriseServicesApply_Extend.ContactPhone),model.ContactPhone},
                    { nameof(RB_EnterpriseServicesApply_Extend.UpdateBy),model.UpdateBy},
                    { nameof(RB_EnterpriseServicesApply_Extend.UpdateDate),model.UpdateDate},
                    { nameof(RB_EnterpriseServicesApply_Extend.EType),model.EType},
                    
                };
                flag = enterpriseServicesApplyRepository.Update(fileds, new WhereHelper(nameof(RB_EnterpriseServicesApply_Extend.ID), model.ID));
            }
            else
            {
                #region 验证企业数据是否已存在
                var oldList = enterpriseServicesApplyRepository.GetEnterpriseServicesApplyRepository(new RB_EnterpriseServicesApply_Extend() { MallBaseId = model.MallBaseId, CompanyId = model.CompanyId });
                if (oldList != null && oldList.Any())
                {
                    return false;
                }
                #endregion
                flag = enterpriseServicesApplyRepository.Insert(model) > 0;
                if (flag)
                {
                    if (Config.IsCPSWJAutoExamine == "1")//自动审核
                    {
                        keyValues.Add(nameof(RB_CompanyEnterprise_Extend.CompanyStatus), 1);
                        try
                        {
                            var BrandModel = oldList?.FirstOrDefault();
                            if ((BrandModel?.ExistServiceId ?? 0) > 0)
                            {
                                Dictionary<string, object> filedsBrand = new Dictionary<string, object>()
                                 {
                                    { nameof(RB_EnterpriseServices.Name),BrandModel.Name},
                                    { nameof(RB_EnterpriseServices.Banner),BrandModel.Banner},
                                    { nameof(RB_EnterpriseServices.Introduction),BrandModel.Introduction},
                                    { nameof(RB_EnterpriseServices.DevIntention),BrandModel.DevIntention},
                                    { nameof(RB_EnterpriseServices.Address),BrandModel.Address},
                                    { nameof(RB_EnterpriseServices.LatAndLon),BrandModel.LatAndLon},
                                    { nameof(RB_EnterpriseServices.OperationTime),BrandModel.OperationTime},
                                    { nameof(RB_EnterpriseServices.CategoryId),BrandModel.CategoryId},
                                    { nameof(RB_EnterpriseServices.Renovation),BrandModel.Renovation},
                                    { nameof(RB_EnterpriseServices.Payment),BrandModel.Payment},
                                    { nameof(RB_EnterpriseServices.HandoverDate),BrandModel.HandoverDate},
                                    { nameof(RB_EnterpriseServices.IntentionalFloor),BrandModel.IntentionalFloor},
                                    { nameof(RB_EnterpriseServices.ElevatorNum),BrandModel.ElevatorNum},
                                    { nameof(RB_EnterpriseServices.PropertyFee),BrandModel.PropertyFee},
                                    { nameof(RB_EnterpriseServices.RentFee),BrandModel.RentFee},
                                    { nameof(RB_EnterpriseServices.ContactName),BrandModel.ContactName},
                                    { nameof(RB_EnterpriseServices.ContactPhone),BrandModel.ContactPhone},
                                    { nameof(RB_EnterpriseServices.UpdateBy),BrandModel.UpdateBy},
                                    { nameof(RB_EnterpriseServices.UpdateDate),BrandModel.UpdateDate},
                                    { nameof(RB_EnterpriseServices.EType),BrandModel.EType},
                                    
                                };
                                enterpriseServicesRepository.Update(filedsBrand, new WhereHelper(nameof(RB_EnterpriseServices.ServiceId), BrandModel.ExistServiceId));
                            }
                            else
                            {
                                #region 新增品牌
                                var inserBModel = BrandModel.RefMapperTo<RB_EnterpriseServices>();
                                inserBModel.ServiceId = 0;
                                inserBModel.UserId = cmodel.CreateBy;
                                enterpriseServicesRepository.Insert(inserBModel);
                                #endregion
                            }
                        }
                        catch
                        {
                        }
                    }
                }
            }
            if (flag)
            {  //更新认证表  资料状态为完成
                companyEnterpriseRepository.Update(keyValues, wheres);
            }
            return flag;
        }



        /// <summary>
        /// 新增/修改楼宇申请信息
        /// </summary>
        /// <returns></returns>
        public bool SetBuildingApplyFor(RB_BuildingApplyFor_Extend model)
        {
            bool flag = false;
            var cmodel = companyEnterpriseRepository.GetEntity(model.CompanyId);
            if (cmodel == null) { return false; }
            if (cmodel.FirstShopType != 4) { return false; }
            //更新认证表  资料状态为完成
            Dictionary<string, object> keyValues = new Dictionary<string, object>()
            {
                { nameof(RB_CompanyEnterprise_Extend.IsComplete),1}
            };
            List<WhereHelper> wheres = new List<WhereHelper>()
            {
                new WhereHelper()
                {
                    FiledName=nameof(RB_CompanyEnterprise_Extend.CompanyId),
                    FiledValue= model.CompanyId,
                    OperatorEnum=OperatorEnum.Equal
                }
            };
            if (model.ID > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_BuildingApplyFor_Extend.Name),model.Name},
                    { nameof(RB_BuildingApplyFor_Extend.Name),model.Name},
                    { nameof(RB_BuildingApplyFor_Extend.Banner),model.Banner},
                    { nameof(RB_BuildingApplyFor_Extend.Address),model.Address},
                    { nameof(RB_BuildingApplyFor_Extend.LatAndLon),model.LatAndLon},
                    { nameof(RB_BuildingApplyFor_Extend.OperationTime),model.OperationTime},
                    { nameof(RB_BuildingApplyFor_Extend.CategoryId),model.CategoryId},
                    { nameof(RB_BuildingApplyFor_Extend.Areas),model.Areas},
                    { nameof(RB_BuildingApplyFor_Extend.BuildingNum),model.BuildingNum},
                    { nameof(RB_BuildingApplyFor_Extend.FloorNum),model.FloorNum},
                    { nameof(RB_BuildingApplyFor_Extend.ElevatorNum),model.ElevatorNum},
                    { nameof(RB_BuildingApplyFor_Extend.FloorHeight),model.FloorHeight},
                    { nameof(RB_BuildingApplyFor_Extend.Developers),model.Developers},
                    { nameof(RB_BuildingApplyFor_Extend.PropertyComp),model.PropertyComp},
                    { nameof(RB_BuildingApplyFor_Extend.SaleOrSelf),model.SaleOrSelf},
                    { nameof(RB_BuildingApplyFor_Extend.IsAllOperate),model.IsAllOperate},
                    { nameof(RB_BuildingApplyFor_Extend.ConstructionTime),model.ConstructionTime},
                    { nameof(RB_BuildingApplyFor_Extend.PropertyFee),model.PropertyFee},
                    { nameof(RB_BuildingApplyFor_Extend.RentFee),model.RentFee},
                    { nameof(RB_BuildingApplyFor_Extend.IndustryDirection),model.IndustryDirection},
                    { nameof(RB_BuildingApplyFor_Extend.BrandDemand),model.BrandDemand},
                    { nameof(RB_BuildingApplyFor_Extend.Other),model.Other},
                    { nameof(RB_BuildingApplyFor_Extend.ContactName),model.ContactName},
                    { nameof(RB_BuildingApplyFor_Extend.ContactPhone),model.ContactPhone},
                    { nameof(RB_BuildingApplyFor_Extend.UpdateBy),model.UpdateBy},
                    { nameof(RB_BuildingApplyFor_Extend.UpdateDate),model.UpdateDate},
                };
                flag = buildingApplyForRepository.Update(fileds, new WhereHelper(nameof(RB_BuildingApplyFor_Extend.ID), model.ID));
            }
            else
            {
                #region 验证企业数据是否已存在
                var oldList = buildingApplyForRepository.GetBuildingRepository(new RB_BuildingApplyFor_Extend() { MallBaseId = model.MallBaseId, CompanyId = model.CompanyId });
                if (oldList != null && oldList.Any())
                {
                    return false;
                }
                #endregion
                flag = buildingApplyForRepository.Insert(model) > 0;
                if (flag)
                {
                    if (Config.IsCPSWJAutoExamine == "1")//自动审核
                    {
                        keyValues.Add(nameof(RB_CompanyEnterprise_Extend.CompanyStatus), 1);
                        try
                        {
                            var BrandModel = oldList?.FirstOrDefault();
                            if ((BrandModel?.ExistBuildId ?? 0) > 0)
                            {
                                Dictionary<string, object> filedsBrand = new Dictionary<string, object>()
                                 {
                                   { nameof(RB_Building_Extend.Name),BrandModel.Name},
                                    { nameof(RB_Building_Extend.Banner),BrandModel.Banner},
                                    { nameof(RB_Building_Extend.Address),BrandModel.Address},
                                    { nameof(RB_Building_Extend.LatAndLon),BrandModel.LatAndLon},
                                    { nameof(RB_Building_Extend.OperationTime),BrandModel.OperationTime},
                                    { nameof(RB_Building_Extend.CategoryId),BrandModel.CategoryId},
                                    { nameof(RB_Building_Extend.Areas),BrandModel.Areas},
                                    { nameof(RB_Building_Extend.BuildingNum),BrandModel.BuildingNum},
                                    { nameof(RB_Building_Extend.FloorNum),BrandModel.FloorNum},
                                    { nameof(RB_Building_Extend.ElevatorNum),BrandModel.ElevatorNum},
                                    { nameof(RB_Building_Extend.FloorHeight),BrandModel.FloorHeight},
                                    { nameof(RB_Building_Extend.Developers),BrandModel.Developers},
                                    { nameof(RB_Building_Extend.PropertyComp),BrandModel.PropertyComp},
                                    { nameof(RB_Building_Extend.SaleOrSelf),BrandModel.SaleOrSelf},
                                    { nameof(RB_Building_Extend.IsAllOperate),BrandModel.IsAllOperate},
                                    { nameof(RB_Building_Extend.ConstructionTime),BrandModel.ConstructionTime},
                                    { nameof(RB_Building_Extend.PropertyFee),BrandModel.PropertyFee},
                                    { nameof(RB_Building_Extend.RentFee),BrandModel.RentFee},
                                    { nameof(RB_Building_Extend.IndustryDirection),BrandModel.IndustryDirection},
                                    { nameof(RB_Building_Extend.BrandDemand),BrandModel.BrandDemand},
                                    { nameof(RB_Building_Extend.Other),BrandModel.Other},
                                    { nameof(RB_Building_Extend.ContactName),BrandModel.ContactName},
                                    { nameof(RB_Building_Extend.ContactPhone),BrandModel.ContactPhone},
                                    { nameof(RB_Building_Extend.UpdateBy),BrandModel.UpdateBy},
                                    { nameof(RB_Building_Extend.UpdateDate),BrandModel.UpdateDate},
                                };
                                buildingRepository.Update(filedsBrand, new WhereHelper(nameof(RB_Building_Extend.BuildId), BrandModel.ExistBuildId));
                            }
                            else
                            {
                                #region 新增楼宇
                                var inserBModel = BrandModel.RefMapperTo<RB_Building_Extend>();
                                inserBModel.BuildId = 0;
                                inserBModel.UserId = cmodel.CreateBy;
                                buildingRepository.Insert(inserBModel);
                                #endregion
                            }
                        }
                        catch
                        {
                        }
                    }
                }
            }
            if (flag)
            {  //更新认证表  资料状态为完成
                companyEnterpriseRepository.Update(keyValues, wheres);
            }
            return flag;
        }
        #endregion



        #region 载体/楼宇
        /// <summary>
        /// 新增修改载体申请
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetCarrierEnterpriseApplyFor(RB_CarrierEnterpriseApplyFor_Extend model)
        {

            bool flag = false;
            var cmodel = companyEnterpriseRepository.GetEntity(model.CompanyId);
            if (cmodel == null) { return false; }

            if (model.ID > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.CarrierName),model.CarrierName },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.Logo),model.Logo },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.Banner),model.Banner },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.VideoUrl),model.VideoUrl },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.Address),model.Address },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.LatAndLon),model.LatAndLon },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.Developers),model.Developers },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.OpenTime),model.OpenTime },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.CarrierSize),model.CarrierSize },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.ProjectType),(int)model.ProjectType },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.LayersNum),model.LayersNum },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.CarNum),model.CarNum },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.CarrierPlan),model.CarrierPlan },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.CarrierTarget),model.CarrierTarget },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.Location),model.Location },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.Crowd),model.Crowd },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.ExistCarrierId),model.ExistCarrierId },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.Discount),model.Discount },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.Honor),model.Honor },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.YeJi),model.YeJi },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.ShopNum),model.ShopNum },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.AreaRequirement ),model.AreaRequirement  },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.EndAreaRequirement),model.EndAreaRequirement },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.BuiltUpArea),model.BuiltUpArea },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.EndBuiltUpArea),model.EndBuiltUpArea },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.FirstShopNum),model.FirstShopNum },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.StartingInfo),model.StartingInfo },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.Ascription),model.Ascription },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.PropertyComposition),model.PropertyComposition },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.VisitorsFlowrate),model.VisitorsFlowrate },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.SupportingFacilities),model.SupportingFacilities },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.ManagementCompany),model.ManagementCompany },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.BrandDemand),model.BrandDemand },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.CategoryId),model.CategoryId },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.ContactName),model.ContactName },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.ContactPhone),model.ContactPhone },
                };
                flag = carrierEnterpriseApplyForRepository.Update(fileds, new WhereHelper(nameof(RB_CarrierEnterpriseApplyFor_Extend.ID), model.ID));
                if (flag)
                {
                    var oldCarrierMetroList = carrierEnterpriseMetroApplyForRepository.GetCarrierMetroList(new RB_CarrierEnterpriseMetroApplyFor_Extend { TenantId = model.TenantId, MallBaseId = model.MallBaseId, CarrierId = model.ID });
                    carrierEnterpriseMetroApplyForRepository.DeleteBatch(oldCarrierMetroList);
                }
            }
            else
            {
                #region 验证载体申请是否已存在
                var oldList = carrierEnterpriseApplyForRepository.GetCarrierEnterpriseList(new RB_CarrierEnterpriseApplyFor_Extend() { MallBaseId = model.MallBaseId, CompanyId = model.CompanyId });
                if (oldList.Any())
                {
                    return false;
                }
                #endregion
                int Id = carrierEnterpriseApplyForRepository.Insert(model);
                model.ID = Id;
                flag = Id > 0;
            }
            if (flag)
            {
                //更新认证表  资料状态为完成
                //更新认证表  资料状态为完成
                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                        { nameof(RB_CompanyEnterprise_Extend.IsComplete),1}
                    };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                        new WhereHelper(){
                                FiledName=nameof(RB_CompanyEnterprise_Extend.CompanyId),
                                FiledValue= model.CompanyId,
                                OperatorEnum=OperatorEnum.Equal
                        }
                    };
                if (Config.IsFirtsShopAutoExamine == "1")//自动审核
                {
                    keyValues.Add(nameof(RB_CompanyEnterprise_Extend.CompanyStatus), 1);
                    //载体
                    var carrierList = carrierEnterpriseApplyForRepository.GetCarrierEnterpriseList(new RB_CarrierEnterpriseApplyFor_Extend() { MallBaseId = cmodel.MallBaseId, CompanyId = cmodel.CompanyId });
                    if (carrierList != null && carrierList.Any())
                    {
                        var CarrierModel = carrierList.FirstOrDefault();
                        var MetroList = carrierEnterpriseMetroApplyForRepository.GetCarrierMetroList(new RB_CarrierEnterpriseMetroApplyFor_Extend { MallBaseId = cmodel.MallBaseId, CarrierId = CarrierModel.ID });

                        if (CarrierModel.ExistCarrierId > 0)
                        {
                            var carrmodel = building_CarrierRepository.GetEntity(CarrierModel.ExistCarrierId);

                            #region 修改载体
                            int FirstStoreTest = 0;
                            if (!string.IsNullOrWhiteSpace(CarrierModel.StartingInfo))
                            {
                                FirstStoreTest = 1;
                            }
                            int OpeningStatus = 0;
                            if (CarrierModel.OpenTime.HasValue)
                            {
                                if (CarrierModel.OpenTime.Value <= System.DateTime.Now)
                                {
                                    OpeningStatus = 1;
                                }
                            }
                            Dictionary<string, object> filedsCarrier = new Dictionary<string, object>()
                            {
                                {nameof(RB_Building_Carrier_Extend.CarrierName),CarrierModel.CarrierName },
                                {nameof(RB_Building_Carrier_Extend.Logo),CarrierModel.Logo },
                                {nameof(RB_Building_Carrier_Extend.Banner),CarrierModel.Banner },
                                {nameof(RB_Building_Carrier_Extend.Honor),CarrierModel.Honor },
                                {nameof(RB_Building_Carrier_Extend.Developers),CarrierModel.Developers },
                                {nameof(RB_Building_Carrier_Extend.OpeningStatus),OpeningStatus },
                                {nameof(RB_Building_Carrier_Extend.VideoUrl),CarrierModel.VideoUrl },
                                {nameof(RB_Building_Carrier_Extend.Address),CarrierModel.Address },
                                {nameof(RB_Building_Carrier_Extend.LatAndLon),CarrierModel.LatAndLon },
                                {nameof(RB_Building_Carrier_Extend.OpenTime),CarrierModel.OpenTime },
                                {nameof(RB_Building_Carrier_Extend.BuildingCarrierType),CarrierModel.BuildingCarrierType },
                                {nameof(RB_Building_Carrier_Extend.CategoryId),CarrierModel.CategoryId },
                                {nameof(RB_Building_Carrier_Extend.Ascription),CarrierModel.Ascription },
                                {nameof(RB_Building_Carrier_Extend.CarrierSize),CarrierModel.CarrierSize },
                                {nameof(RB_Building_Carrier_Extend.PropertyComposition),CarrierModel.PropertyComposition },
                                {nameof(RB_Building_Carrier_Extend.Location),CarrierModel.Location },
                                {nameof(RB_Building_Carrier_Extend.Crowd),CarrierModel.Crowd },
                                {nameof(RB_Building_Carrier_Extend.VisitorsFlowrate),CarrierModel.VisitorsFlowrate },
                                {nameof(RB_Building_Carrier_Extend.LayersNum),CarrierModel.LayersNum },
                                {nameof(RB_Building_Carrier_Extend.SupportingFacilities),CarrierModel.SupportingFacilities },
                                {nameof(RB_Building_Carrier_Extend.ManagementCompany),CarrierModel.ManagementCompany },
                                {nameof(RB_Building_Carrier_Extend.BrandDemand),CarrierModel.BrandDemand },
                                {nameof(RB_Building_Carrier_Extend.UpdateBy),CarrierModel.UpdateBy },
                                {nameof(RB_Building_Carrier_Extend.UpdateDate),CarrierModel.UpdateDate },
                                 {nameof(RB_Building_Carrier_Extend.ContactName),CarrierModel.ContactName },
                                {nameof(RB_Building_Carrier_Extend.ContactPhone),CarrierModel.ContactPhone },
                            };
                            flag = building_CarrierRepository.Update(filedsCarrier, new WhereHelper(nameof(RB_Building_Carrier_Extend.ID), carrmodel.ID));
                            if (flag)
                            {
                                var oldCarrierMetroList = carrierEnterpriseMetroApplyForRepository.GetCarrierMetroList(new RB_CarrierEnterpriseMetroApplyFor_Extend { MallBaseId = CarrierModel.MallBaseId, CarrierId = carrmodel.ID });
                                carrierEnterpriseMetroApplyForRepository.DeleteBatch(oldCarrierMetroList);
                                var mlist = MetroList.RefMapperToList<RB_CarrierEnterpriseMetroApplyFor_Extend>();
                                mlist.ForEach(x =>
                                {
                                    x.ID = 0;
                                    x.CarrierId = carrmodel.ID;
                                    x.Status = 0;
                                    x.TenantId = CarrierModel.TenantId;
                                    x.MallBaseId = CarrierModel.MallBaseId;
                                });
                                carrierEnterpriseMetroApplyForRepository.InsertBatch(mlist);
                            }
                            #endregion
                        }
                        else
                        {

                            #region 新增载体
                            var inserCModel = CarrierModel.RefMapperTo<RB_Building_Carrier_Extend>();
                            inserCModel.ID = 0;
                            inserCModel.UserId = cmodel.CreateBy;
                            if (CarrierModel.OpenTime.HasValue)
                            {
                                if (CarrierModel.OpenTime.Value <= System.DateTime.Now)
                                {
                                    inserCModel.OpeningStatus = 1;
                                }
                            }
                            if (!string.IsNullOrWhiteSpace(CarrierModel.StartingInfo))
                            {
                                inserCModel.FirstStoreTest = 1;
                            }
                            int Id = building_CarrierRepository.Insert(inserCModel);
                            if (Id > 0)
                            {
                                var mlist = MetroList.RefMapperToList<RB_CarrierEnterpriseMetroApplyFor_Extend>();
                                mlist.ForEach(x =>
                                {
                                    x.ID = 0;
                                    x.CarrierId = Id;
                                    x.Status = 0;
                                    x.TenantId = CarrierModel.TenantId;
                                    x.MallBaseId = CarrierModel.MallBaseId;
                                });
                                carrierEnterpriseMetroApplyForRepository.InsertBatch(mlist);
                            }
                            #endregion
                        }
                    }
                }
                model.CarrierMetroList.ForEach(x =>
                {
                    x.CarrierId = model.ID;
                    x.Status = 0;
                    x.TenantId = model.TenantId;
                    x.MallBaseId = model.MallBaseId;
                });
                carrierEnterpriseMetroApplyForRepository.InsertBatch(model.CarrierMetroList);
                companyEnterpriseRepository.Update(keyValues, wheres);
            }
            return flag;
        }



        #endregion


        #region 公司

        /// <summary>
        /// 新增修改公司信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int SetCompanyModule(RB_CompanyEnterprise_Extend model)
        {
            int ID;
            if (model.CompanyId > 0)
            {
                ID = model.CompanyId;
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_CompanyEnterprise_Extend.CompanyName),model.CompanyName },
                    {nameof(RB_CompanyEnterprise_Extend.Principal),model.Principal },
                    {nameof(RB_CompanyEnterprise_Extend.Mobile),model.Mobile },
                    {nameof(RB_CompanyEnterprise_Extend.BusinessLicense),model.BusinessLicense },
                    {nameof(RB_CompanyEnterprise_Extend.LegalPerson),model.LegalPerson },
                    {nameof(RB_CompanyEnterprise_Extend.UnifiedCode),model.UnifiedCode },
                    {nameof(RB_CompanyEnterprise_Extend.CompanyIntro),model.CompanyIntro },
                    {nameof(RB_CompanyEnterprise_Extend.FirstShopType),model.FirstShopType },
                    {nameof(RB_CompanyEnterprise_Extend.CompanyStatus),model.CompanyStatus },
                    {nameof(RB_CompanyEnterprise_Extend.UpdateBy),model.UpdateBy },
                    {nameof(RB_CompanyEnterprise_Extend.UpdateDate),model.UpdateDate },
                };
                companyEnterpriseRepository.Update(fileds, new WhereHelper(nameof(RB_CompanyEnterprise_Extend.CompanyId), model.CompanyId));
            }
            else
            {
                var newId = companyEnterpriseRepository.Insert(model);
                model.CompanyId = newId;
                ID = newId;
            }
            return ID;
        }


        /// <summary>
        /// 获取公司信息实体
        /// </summary>
        /// <param name="CompanyId"></param>
        /// <returns></returns>
        public RB_CompanyEnterprise_Extend GetCompanyByUserIdModule(int userId)
        {
            var model = companyEnterpriseRepository.GetCompanyRepository(new RB_CompanyEnterprise_Extend() { CreateBy = userId });
            if (model != null && model.CompanyId > 0)
            {
                model.BrandModel = new RB_BrandEnterpriseApplyFor_Extend();
                model.CarrierModel = new RB_CarrierEnterpriseApplyFor_Extend();
                model.EnterpriseServicesModel = new RB_EnterpriseServicesApply_Extend();
                model.buildingApplyForModel = new RB_BuildingApplyFor_Extend();
                if (model.CompanyStatus == 1)
                {
                    if (model.FirstShopType == 1)
                    {
                        //审核通过了的  直接查询资料表
                        var blist = brand_EnterpriseRepository.GetBrandEnterpriseListRepository(new RB_Brand_Enterprise_Extend() { TenantId = model.TenantId, MallBaseId = model.MallBaseId, UserId = userId });
                        model.BrandModel = blist.FirstOrDefault().RefMapperTo<RB_BrandEnterpriseApplyFor_Extend>();


                        if (model.BrandModel != null)
                        {
                            if (!string.IsNullOrWhiteSpace(model.BrandModel.CustomerType))
                            {
                                model.BrandModel.CustomerTypeInfo = new List<string>();
                                foreach (var itemCustomerType in model.BrandModel.CustomerType.Split(","))
                                {
                                    model.BrandModel.CustomerTypeInfo.Add(Common.Plugin.EnumHelper.GetEnumName(itemCustomerType));
                                }
                            }

                            if (!string.IsNullOrWhiteSpace(model.BrandModel.Banner))
                            {
                                model.BrandModel.BannerList = JsonConvert.DeserializeObject<List<string>>(model.BrandModel.Banner);
                            }
                            else
                            {
                                model.BrandModel.BannerList = new List<string>();
                            }
                        }
                        else
                        {
                            model.BrandModel = new RB_BrandEnterpriseApplyFor_Extend
                            {
                                BannerList = new List<string>(),
                                CustomerTypeInfo = new List<string>()
                            };
                        }
                    }
                    else if (model.FirstShopType == 2)
                    {
                        var clist = building_CarrierRepository.GetBuildingCarrierListRepository(new RB_Building_Carrier_Extend() { TenantId = model.TenantId, MallBaseId = model.MallBaseId, UserId = userId });
                        if (clist.Any())
                        {
                            model.CarrierModel = clist.FirstOrDefault().RefMapperTo<RB_CarrierEnterpriseApplyFor_Extend>();
                            var metroList = carrierEnterpriseMetroApplyForRepository.GetCarrierMetroList(new RB_CarrierEnterpriseMetroApplyFor_Extend { TenantId = model.TenantId, MallBaseId = model.MallBaseId, CarrierId = model.CarrierModel.ID });
                            model.CarrierModel.CarrierMetroList = new List<RB_CarrierEnterpriseMetroApplyFor_Extend>();
                            if (metroList != null && metroList.Any())
                            {
                                model.CarrierModel.CarrierMetroList = metroList.RefMapperToList<RB_CarrierEnterpriseMetroApplyFor_Extend>();
                            }
                            if (!string.IsNullOrWhiteSpace(model.CarrierModel.Banner))
                            {
                                model.CarrierModel.BannerList = JsonConvert.DeserializeObject<List<string>>(model.CarrierModel.Banner);
                            }
                            else
                            {
                                model.CarrierModel.BannerList = new List<string>();
                            }
                        }
                    }
                    else if (model.FirstShopType == 3)
                    {
                        //审核通过了的  直接查询资料表
                        var blist = enterpriseServicesRepository.GetEnterpriseServicesListRepository(new RB_EnterpriseServices_Extend() { TenantId = model.TenantId, MallBaseId = model.MallBaseId, UserId = userId });
                        model.EnterpriseServicesModel = blist.FirstOrDefault().RefMapperTo<RB_EnterpriseServicesApply_Extend>();
                        if (model.EnterpriseServicesModel != null)
                        {

                            if (!string.IsNullOrWhiteSpace(model.EnterpriseServicesModel.Banner))
                            {
                                model.EnterpriseServicesModel.BannerList = JsonConvert.DeserializeObject<List<string>>(model.EnterpriseServicesModel.Banner);
                            }
                            else
                            {
                                model.EnterpriseServicesModel.BannerList = new List<string>();
                            }
                        }
                        else
                        {
                            model.EnterpriseServicesModel = new RB_EnterpriseServicesApply_Extend
                            {
                                BannerList = new List<string>(),
                            };
                        }
                    }
                    else if (model.FirstShopType == 4)
                    {
                        //审核通过了的  直接查询资料表
                        var blist = buildingRepository.GetBuildingRepository(new RB_Building_Extend() { TenantId = model.TenantId, MallBaseId = model.MallBaseId, UserId = userId });
                        model.buildingApplyForModel = blist.FirstOrDefault().RefMapperTo<RB_BuildingApplyFor_Extend>();
                        if (model.EnterpriseServicesModel != null)
                        {

                            if (!string.IsNullOrWhiteSpace(model.EnterpriseServicesModel.Banner))
                            {
                                model.EnterpriseServicesModel.BannerList = JsonConvert.DeserializeObject<List<string>>(model.EnterpriseServicesModel.Banner);
                            }
                            else
                            {
                                model.EnterpriseServicesModel.BannerList = new List<string>();
                            }
                        }
                        else
                        {
                            model.EnterpriseServicesModel = new RB_EnterpriseServicesApply_Extend
                            {
                                BannerList = new List<string>(),
                            };
                        }
                    }
                }
                else
                {
                    if (model.FirstShopType == 1)
                    {
                        var brandList = brandEnterpriseApplyForRepository.GetCarrierEnterpriseApplyForRepository(new RB_BrandEnterpriseApplyFor_Extend { TenantId = model.TenantId, MallBaseId = model.MallBaseId, CompanyId = model.CompanyId });
                        if (brandList != null && brandList.Any())
                        {
                            model.BrandModel = brandList.FirstOrDefault();
                            if (model.BrandModel != null)
                            {
                                if (!string.IsNullOrWhiteSpace(model.BrandModel.CustomerType))
                                {
                                    model.BrandModel.CustomerTypeInfo = new List<string>();
                                    foreach (var itemCustomerType in model.BrandModel.CustomerType.Split(","))
                                    {
                                        model.BrandModel.CustomerTypeInfo.Add(Common.Plugin.EnumHelper.GetEnumName(itemCustomerType));
                                    }
                                }
                                if (!string.IsNullOrWhiteSpace(model.BrandModel.Banner))
                                {
                                    model.BrandModel.BannerList = JsonConvert.DeserializeObject<List<string>>(model.BrandModel.Banner);
                                }
                                else
                                {
                                    model.BrandModel.BannerList = new List<string>();
                                }
                            }
                            else
                            {
                                model.BrandModel = new RB_BrandEnterpriseApplyFor_Extend
                                {
                                    BannerList = new List<string>(),
                                    CustomerTypeInfo = new List<string>()
                                };
                            }
                        }
                    }
                    else if (model.FirstShopType == 2)
                    {
                        var carrierList = carrierEnterpriseApplyForRepository.GetCarrierEnterpriseList(new RB_CarrierEnterpriseApplyFor_Extend() { TenantId = model.TenantId, MallBaseId = model.MallBaseId, CompanyId = model.CompanyId });
                        if (carrierList.Any())
                        {
                            model.CarrierModel = carrierList.FirstOrDefault();
                            var metroList = carrierEnterpriseMetroApplyForRepository.GetCarrierMetroList(new RB_CarrierEnterpriseMetroApplyFor_Extend { TenantId = model.TenantId, MallBaseId = model.MallBaseId, CarrierId = model.CarrierModel.ID });
                            model.CarrierModel.CarrierMetroList = new List<RB_CarrierEnterpriseMetroApplyFor_Extend>();
                            if (metroList != null && metroList.Any())
                            {
                                model.CarrierModel.CarrierMetroList = metroList;
                            }
                            if (!string.IsNullOrWhiteSpace(model.CarrierModel.Banner))
                            {
                                model.CarrierModel.BannerList = JsonConvert.DeserializeObject<List<string>>(model.CarrierModel.Banner);
                            }
                            else
                            {
                                model.CarrierModel.BannerList = new List<string>();
                            }
                            if (!string.IsNullOrWhiteSpace(model.CarrierModel.Honor))
                            {
                                model.CarrierModel.HonorList = JsonConvert.DeserializeObject<List<string>>(model.CarrierModel.Honor);
                            }
                            else
                            {
                                model.CarrierModel.HonorList = new List<string>();
                            }
                            if (!string.IsNullOrWhiteSpace(model.CarrierModel.FirstShopNum))
                            {
                                model.CarrierModel.FirstShopNumList = JsonConvert.DeserializeObject<List<FirstShopNumModel>>(model.CarrierModel.FirstShopNum);
                            }
                            else
                            {
                                model.CarrierModel.FirstShopNumList = new List<FirstShopNumModel>();
                            }


                        }
                    }
                    else if (model.FirstShopType == 3)
                    {
                        var brandList = enterpriseServicesApplyRepository.GetEnterpriseServicesApplyRepository(new RB_EnterpriseServicesApply_Extend { TenantId = model.TenantId, MallBaseId = model.MallBaseId, CompanyId = model.CompanyId });
                        if (brandList != null && brandList.Any())
                        {
                            model.EnterpriseServicesModel = brandList.FirstOrDefault();
                            if (model.BrandModel != null)
                            {
                                if (!string.IsNullOrWhiteSpace(model.BrandModel.CustomerType))
                                {
                                    model.BrandModel.CustomerTypeInfo = new List<string>();
                                    foreach (var itemCustomerType in model.BrandModel.CustomerType.Split(","))
                                    {
                                        model.BrandModel.CustomerTypeInfo.Add(Common.Plugin.EnumHelper.GetEnumName(itemCustomerType));
                                    }
                                }
                                if (!string.IsNullOrWhiteSpace(model.BrandModel.Banner))
                                {
                                    model.BrandModel.BannerList = JsonConvert.DeserializeObject<List<string>>(model.BrandModel.Banner);
                                }
                                else
                                {
                                    model.BrandModel.BannerList = new List<string>();
                                }
                            }
                            else
                            {
                                model.BrandModel = new RB_BrandEnterpriseApplyFor_Extend
                                {
                                    BannerList = new List<string>(),
                                    CustomerTypeInfo = new List<string>()
                                };
                            }
                        }
                    }
                    else if (model.FirstShopType == 4)
                    {
                        var brandList = buildingApplyForRepository.GetBuildingRepository(new RB_BuildingApplyFor_Extend { TenantId = model.TenantId, MallBaseId = model.MallBaseId, CompanyId = model.CompanyId });
                        if (brandList != null && brandList.Any())
                        {
                            model.buildingApplyForModel = brandList.FirstOrDefault();
                            if (model.BrandModel != null)
                            {
                                if (!string.IsNullOrWhiteSpace(model.BrandModel.CustomerType))
                                {
                                    model.BrandModel.CustomerTypeInfo = new List<string>();
                                    foreach (var itemCustomerType in model.BrandModel.CustomerType.Split(","))
                                    {
                                        model.BrandModel.CustomerTypeInfo.Add(Common.Plugin.EnumHelper.GetEnumName(itemCustomerType));
                                    }
                                }
                                if (!string.IsNullOrWhiteSpace(model.BrandModel.Banner))
                                {
                                    model.BrandModel.BannerList = JsonConvert.DeserializeObject<List<string>>(model.BrandModel.Banner);
                                }
                                else
                                {
                                    model.BrandModel.BannerList = new List<string>();
                                }
                            }
                            else
                            {
                                model.BrandModel = new RB_BrandEnterpriseApplyFor_Extend
                                {
                                    BannerList = new List<string>(),
                                    CustomerTypeInfo = new List<string>()
                                };
                            }
                        }
                    }
                }
            }
            return model;
        }
        /// <summary>
        /// 获取认证状态
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        public object GetCommpanyStatus(int userId)
        {
            var model = companyEnterpriseRepository.GetCompanyRepository(new RB_CompanyEnterprise_Extend() { CreateBy = userId });
            if (model != null)
            {
                if (model.CompanyStatus == 1)
                {
                    return new
                    {
                        CompanyStatus = 5,//认证通过
                        model.FirstShopType,
                        model.CompanyName
                    };
                }
                else if (model.CompanyStatus == 0)
                {
                    if (model.IsComplete == 1)
                    {
                        return new
                        {
                            CompanyStatus = 3,//认证审核中
                            model.FirstShopType,
                            model.CompanyName
                        };
                    }
                    else
                    {
                        return new
                        {
                            CompanyStatus = 2,//认证待完善
                            model.FirstShopType,
                            model.CompanyName
                        };
                    }
                }
                else if (model.CompanyStatus == 2)
                {
                    return new
                    {
                        CompanyStatus = 4,//认证未通过
                        model.FirstShopType,
                        model.CompanyName
                    };
                }
            }
            else
            {
                return new
                {
                    CompanyStatus = 1,//未认证
                    FirstShopType = 0,
                    CompanyName = ""
                };
            }
            return model;
        }
        /// <summary>
        /// 获取公司信息分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_CompanyEnterprise_Extend> GetCompanyEnterprisePageModule(int pageIndex, int pageSize, out long rowsCount, RB_CompanyEnterprise_Extend query)
        {
            var list = companyEnterpriseRepository.GetCompanyEnterprisePageRepository(pageIndex, pageSize, out rowsCount, query);
            if (list != null && list.Any())
            {
                //查询用户列表
                string userIds = string.Join(",", list.Select(x => x.CreateBy));
                var ulist = member_UserRepository.GetList(new Model.Extend.User.RB_Member_User_Extend() { MallBaseId = query.MallBaseId, UserIds = userIds });
                foreach (var item in list)
                {
                    var umodel = ulist.Where(x => x.Id == item.CreateBy).FirstOrDefault();
                    item.UserName = umodel?.Name ?? "";
                    item.UserIcon = umodel?.Photo ?? "";
                }
            }
            return list;
        }


        /// <summary>
        /// 获取公司信息实体
        /// </summary>
        /// <param name="CompanyId"></param>
        /// <returns></returns>
        public RB_CompanyEnterprise_Extend GetCompanyModule(object CompanyId)
        {
            var model = companyEnterpriseRepository.GetEntity<RB_CompanyEnterprise_Extend>(CompanyId);
            if (model != null && model.CompanyId > 0)
            {
                model.BrandModel = new RB_BrandEnterpriseApplyFor_Extend();
                model.CarrierModel = new RB_CarrierEnterpriseApplyFor_Extend();
                model.EnterpriseServicesModel = new RB_EnterpriseServicesApply_Extend();
                model.buildingApplyForModel = new RB_BuildingApplyFor_Extend();
                if (model.FirstShopType == 1)
                {
                    var brandList = brandEnterpriseApplyForRepository.GetCarrierEnterpriseApplyForRepository(new RB_BrandEnterpriseApplyFor_Extend { TenantId = model.TenantId, MallBaseId = model.MallBaseId, CompanyId = model.CompanyId });
                    if (brandList != null && brandList.Any())
                    {
                        model.BrandModel = brandList.FirstOrDefault();
                        if (model.BrandModel != null && !string.IsNullOrWhiteSpace(model.BrandModel.CustomerType))
                        {
                            model.BrandModel.CustomerTypeInfo = new List<string>();
                            foreach (var itemCustomerType in model.BrandModel.CustomerType.Split(","))
                            {
                                model.BrandModel.CustomerTypeInfo.Add(Common.Plugin.EnumHelper.GetEnumName(itemCustomerType));
                            }
                        }

                        if (!string.IsNullOrWhiteSpace(model.BrandModel.Banner))
                        {
                            model.BrandModel.BannerList = JsonConvert.DeserializeObject<List<string>>(model.BrandModel.Banner);
                        }
                        else
                        {
                            model.BrandModel.BannerList = new List<string>();
                        }

                        model.BrandModel.ProjectName = model.BrandModel.ProjectType.GetEnumName();
                    }
                }
                else if (model.FirstShopType == 2)
                {
                    var carrierList = carrierEnterpriseApplyForRepository.GetCarrierEnterpriseList(new RB_CarrierEnterpriseApplyFor_Extend() { TenantId = model.TenantId, MallBaseId = model.MallBaseId, CompanyId = model.CompanyId });
                    if (carrierList.Any())
                    {
                        model.CarrierModel = carrierList.FirstOrDefault();
                        var metroList = carrierEnterpriseMetroApplyForRepository.GetCarrierMetroList(new RB_CarrierEnterpriseMetroApplyFor_Extend { TenantId = model.TenantId, MallBaseId = model.MallBaseId, CarrierId = model.CarrierModel.ID });
                        model.CarrierModel.CarrierMetroList = new List<RB_CarrierEnterpriseMetroApplyFor_Extend>();
                        if (metroList != null && metroList.Any())
                        {
                            model.CarrierModel.CarrierMetroList = metroList;
                        }
                        if (!string.IsNullOrWhiteSpace(model.CarrierModel.Banner))
                        {
                            model.CarrierModel.BannerList = JsonConvert.DeserializeObject<List<string>>(model.CarrierModel.Banner);
                        }
                        else
                        {
                            model.CarrierModel.BannerList = new List<string>();
                        }

                        model.CarrierModel.ProjectName = model.CarrierModel.ProjectType.GetEnumName();
                    }
                }
                else if (model.FirstShopType == 3)
                {
                    var brandList = enterpriseServicesApplyRepository.GetEnterpriseServicesApplyRepository(new RB_EnterpriseServicesApply_Extend { TenantId = model.TenantId, MallBaseId = model.MallBaseId, CompanyId = model.CompanyId });
                    if (brandList != null && brandList.Any())
                    {
                        model.EnterpriseServicesModel = brandList.FirstOrDefault();


                        if (!string.IsNullOrWhiteSpace(model.EnterpriseServicesModel.Banner))
                        {
                            model.EnterpriseServicesModel.BannerList = JsonConvert.DeserializeObject<List<string>>(model.EnterpriseServicesModel.Banner);
                        }
                        else
                        {
                            model.EnterpriseServicesModel.BannerList = new List<string>();
                        }
                    }
                }
                else if (model.FirstShopType == 4)
                {
                    var brandList = buildingApplyForRepository.GetBuildingRepository(new RB_BuildingApplyFor_Extend { TenantId = model.TenantId, MallBaseId = model.MallBaseId, CompanyId = model.CompanyId });
                    if (brandList != null && brandList.Any())
                    {
                        model.buildingApplyForModel = brandList.FirstOrDefault();


                        if (!string.IsNullOrWhiteSpace(model.EnterpriseServicesModel.Banner))
                        {
                            model.EnterpriseServicesModel.BannerList = JsonConvert.DeserializeObject<List<string>>(model.EnterpriseServicesModel.Banner);
                        }
                        else
                        {
                            model.EnterpriseServicesModel.BannerList = new List<string>();
                        }
                    }
                }
            }
            return model;
        }


        /// <summary>
        /// 更新公司信息状态
        /// </summary>
        /// <param name="CompanyId"></param>
        /// <param name="Status"></param>
        /// <returns></returns>
        public bool RemoveCompanyModule(int CompanyId, int Status)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_CompanyEnterprise_Extend.Status),Status },
            };
            bool flag = companyEnterpriseRepository.Update(fileds, new WhereHelper(nameof(RB_CompanyEnterprise_Extend.CompanyId), CompanyId));
            return flag;
        }

        /// <summary>
        /// 获取公司信息实体
        /// </summary>
        /// <param name="CompanyId"></param>
        /// <returns></returns>
        public RB_CompanyEnterprise_Extend GetCompanyEntity(object CompanyId)
        {
            var model = companyEnterpriseRepository.GetEntity<RB_CompanyEnterprise_Extend>(CompanyId);

            return model;
        }


        /// <summary>
        /// 更新公司审核状态
        /// </summary>
        /// <param name="CompanyId"></param>
        /// <param name="Status"></param>
        /// <param name="remark"></param>
        /// <returns></returns>
        public string UpdateCompanyStatus(int CompanyId, int Status, string remark)
        {
            var trans = companyEnterpriseRepository.DbTransaction;
            try
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_CompanyEnterprise_Extend.CompanyStatus),Status },
                };
                if (Status == 2)
                {
                    fileds.Add(nameof(RB_CompanyEnterprise_Extend.RejectRemark), remark);
                }
                List<WhereHelper> wheres = new List<WhereHelper>() {
                     new WhereHelper(){
                         FiledName=nameof(RB_CompanyEnterprise_Extend.CompanyId),
                          FiledValue=CompanyId,
                           OperatorEnum=OperatorEnum.Equal
                     }
                };
                bool flag = companyEnterpriseRepository.Update(fileds, wheres, trans);
                if (flag)
                {
                    //新增 更新品牌 载体信息
                    if (Status == 1)
                    {
                        var cmodel = companyEnterpriseRepository.GetEntity(CompanyId);
                        if (cmodel.FirstShopType == 1)
                        {
                            //品牌
                            var brandList = brandEnterpriseApplyForRepository.GetCarrierEnterpriseApplyForRepository(new RB_BrandEnterpriseApplyFor_Extend { MallBaseId = cmodel.MallBaseId, CompanyId = cmodel.CompanyId });
                            if (brandList != null && brandList.Any())
                            {
                                var BrandModel = brandList.FirstOrDefault();
                                if (BrandModel.ExistBrandId > 0)
                                {
                                    //修改
                                    #region 验证品牌是否已关联用户
                                    //var bmodel = brand2Repository.GetEntity(BrandModel.ExistBrandId);
                                    //if (bmodel.UserId > 0)
                                    //{
                                    //    companyEnterpriseRepository.DBSession.Rollback();
                                    //    return "该品牌已被其他用户认证，请核实后再试";
                                    //}
                                    #endregion
                                    Dictionary<string, object> filedsBrand = new Dictionary<string, object>()
                                     {
                                                { nameof(RB_Brand_Enterprise_Extend.BrandName),BrandModel.BrandName},
                                                { nameof(RB_Brand_Enterprise_Extend.FullBrandName),BrandModel.FullBrandName},
                                                { nameof(RB_Brand_Enterprise_Extend.VideoUrl),BrandModel.VideoUrl},
                                                { nameof(RB_Brand_Enterprise_Extend.Logo),BrandModel.Logo},
                                                { nameof(RB_Brand_Enterprise_Extend.Banner),BrandModel.Banner},
                                                { nameof(RB_Brand_Enterprise_Extend.ShopNum),BrandModel.ShopNum},
                                                { nameof(RB_Brand_Enterprise_Extend.BuiltUpArea),BrandModel.BuiltUpArea},
                                                { nameof(RB_Brand_Enterprise_Extend.EndBuiltUpArea),BrandModel.EndBuiltUpArea},
                                                { nameof(RB_Brand_Enterprise_Extend.BrandType),BrandModel.BrandType},
                                                { nameof(RB_Brand_Enterprise_Extend.CustomerType),BrandModel.CustomerType},
                                                { nameof(RB_Brand_Enterprise_Extend.AreaRequirement),BrandModel.AreaRequirement},
                                                { nameof(RB_Brand_Enterprise_Extend.EndAreaRequirement),BrandModel.EndAreaRequirement},
                                                { nameof(RB_Brand_Enterprise_Extend.CategoryId),BrandModel.BrandClassId},
                                                { nameof(RB_Brand_Enterprise_Extend.BrandEnterpriseType),BrandModel.BrandEnterpriseType},
                                                { nameof(RB_Brand_Enterprise_Extend.Introduce),BrandModel.Introduce},
                                                { nameof(RB_Brand_Enterprise_Extend.DevIntention),BrandModel.DevIntention},
                                                { nameof(RB_Brand_Enterprise_Extend.PropertyDemand),BrandModel.PropertyDemand},
                                                { nameof(RB_Brand_Enterprise_Extend.Cooperation),BrandModel.Cooperation},
                                                { nameof(RB_Brand_Enterprise_Extend.Complementary),BrandModel.Complementary},
                                    };
                                    brand_EnterpriseRepository.Update(filedsBrand, new WhereHelper(nameof(RB_Brand_Enterprise_Extend.ID), BrandModel.ExistBrandId), trans);
                                }
                                else
                                {
                                    //新增
                                    #region 再次验证品牌名称
                                    //if (ValidateBrandName(BrandModel.BrandName, cmodel.MallBaseId))
                                    //{
                                    //    companyEnterpriseRepository.DBSession.Rollback();
                                    //    return "该品牌名称已存在,请确认品牌名称后再次审核";
                                    //}
                                    //if (ValidateFullBrandName(BrandModel.FullBrandName, cmodel.MallBaseId))
                                    //{
                                    //    companyEnterpriseRepository.DBSession.Rollback();
                                    //    return "该品牌全名已存在,请确认品牌全名后再次审核";
                                    //}
                                    #endregion

                                    #region 新增品牌
                                    var inserBModel = BrandModel.RefMapperTo<RB_Brand_Enterprise_Extend>();
                                    inserBModel.ID = 0;
                                    inserBModel.UserId = cmodel.CreateBy;
                                    brand_EnterpriseRepository.Insert(inserBModel, trans);
                                    #endregion
                                }
                            }
                        }
                        else if (cmodel.FirstShopType == 2)
                        {
                            //载体
                            var carrierList = carrierEnterpriseApplyForRepository.GetCarrierEnterpriseList(new RB_CarrierEnterpriseApplyFor_Extend() { MallBaseId = cmodel.MallBaseId, CompanyId = cmodel.CompanyId });
                            if (carrierList != null && carrierList.Any())
                            {
                                var CarrierModel = carrierList.FirstOrDefault();
                                var MetroList = carrierEnterpriseMetroApplyForRepository.GetCarrierMetroList(new RB_CarrierEnterpriseMetroApplyFor_Extend { MallBaseId = cmodel.MallBaseId, CarrierId = CarrierModel.ID });

                                if (CarrierModel.ExistCarrierId > 0)
                                {
                                    //修改
                                    #region 验证品牌是否已关联用户
                                    var carrmodel = building_CarrierRepository.GetEntity(CarrierModel.ExistCarrierId);
                                    //if (carrmodel.UserId > 0)
                                    //{
                                    //    companyEnterpriseRepository.DBSession.Rollback();
                                    //    return "该载体已被其他用户认证，请核实后再试";
                                    //}
                                    #endregion
                                    #region 修改载体
                                    int FirstStoreTest = 0;
                                    if (!string.IsNullOrWhiteSpace(CarrierModel.StartingInfo))
                                    {
                                        FirstStoreTest = 1;
                                    }
                                    int OpeningStatus = 0;
                                    if (CarrierModel.OpenTime.HasValue)
                                    {
                                        if (CarrierModel.OpenTime.Value <= System.DateTime.Now)
                                        {
                                            OpeningStatus = 1;
                                        }
                                    }
                                    Dictionary<string, object> filedsCarrier = new Dictionary<string, object>()
                                    {
                                        {nameof(RB_Building_Carrier_Extend.CarrierName),CarrierModel.CarrierName },
                                        {nameof(RB_Building_Carrier_Extend.Logo),CarrierModel.Logo },
                                        {nameof(RB_Building_Carrier_Extend.Banner),CarrierModel.Banner },
                                        {nameof(RB_Building_Carrier_Extend.Honor),CarrierModel.Honor },
                                        {nameof(RB_Building_Carrier_Extend.Developers),CarrierModel.Developers },
                                        {nameof(RB_Building_Carrier_Extend.OpeningStatus),OpeningStatus },
                                        {nameof(RB_Building_Carrier_Extend.VideoUrl),CarrierModel.VideoUrl },
                                        {nameof(RB_Building_Carrier_Extend.Address),CarrierModel.Address },
                                        {nameof(RB_Building_Carrier_Extend.LatAndLon),CarrierModel.LatAndLon },
                                        {nameof(RB_Building_Carrier_Extend.OpenTime),CarrierModel.OpenTime },
                                        {nameof(RB_Building_Carrier_Extend.BuildingCarrierType),CarrierModel.BuildingCarrierType },
                                        {nameof(RB_Building_Carrier_Extend.CategoryId),CarrierModel.CategoryId },
                                        {nameof(RB_Building_Carrier_Extend.Ascription),CarrierModel.Ascription },
                                        {nameof(RB_Building_Carrier_Extend.CarrierSize),CarrierModel.CarrierSize },
                                        {nameof(RB_Building_Carrier_Extend.PropertyComposition),CarrierModel.PropertyComposition },
                                        {nameof(RB_Building_Carrier_Extend.Location),CarrierModel.Location },
                                        {nameof(RB_Building_Carrier_Extend.Crowd),CarrierModel.Crowd },
                                        {nameof(RB_Building_Carrier_Extend.VisitorsFlowrate),CarrierModel.VisitorsFlowrate },
                                        {nameof(RB_Building_Carrier_Extend.LayersNum),CarrierModel.LayersNum },
                                        {nameof(RB_Building_Carrier_Extend.SupportingFacilities),CarrierModel.SupportingFacilities },
                                        {nameof(RB_Building_Carrier_Extend.ManagementCompany),CarrierModel.ManagementCompany },
                                        {nameof(RB_Building_Carrier_Extend.BrandDemand),CarrierModel.BrandDemand },
                                        {nameof(RB_Building_Carrier_Extend.UpdateBy),CarrierModel.UpdateBy },
                                        {nameof(RB_Building_Carrier_Extend.UpdateDate),CarrierModel.UpdateDate },
                                    };
                                    flag = building_CarrierRepository.Update(filedsCarrier, new WhereHelper(nameof(RB_Building_Carrier_Extend.ID), carrmodel.ID), trans);
                                    if (flag)
                                    {
                                        var oldCarrierMetroList = carrierEnterpriseMetroApplyForRepository.GetCarrierMetroList(new RB_CarrierEnterpriseMetroApplyFor_Extend { MallBaseId = CarrierModel.MallBaseId, CarrierId = carrmodel.ID });
                                        carrierEnterpriseMetroApplyForRepository.DeleteBatch(oldCarrierMetroList);
                                        var mlist = MetroList.RefMapperToList<RB_CarrierEnterpriseMetroApplyFor_Extend>();
                                        mlist.ForEach(x =>
                                        {
                                            x.ID = 0;
                                            x.CarrierId = carrmodel.ID;
                                            x.Status = 0;
                                            x.TenantId = CarrierModel.TenantId;
                                            x.MallBaseId = CarrierModel.MallBaseId;
                                        });
                                        carrierEnterpriseMetroApplyForRepository.InsertBatch(mlist);
                                    }
                                    #endregion
                                }
                                else
                                {
                                    //新增
                                    #region 再次验证载体名称
                                    //if (ValidateCarrierName(CarrierModel.CarrierName, CarrierModel.MallBaseId))
                                    //{
                                    //    return "该载体名称已存在,请确认载体名称后再次审核";
                                    //}
                                    #endregion
                                    #region 新增载体
                                    var inserCModel = CarrierModel.RefMapperTo<RB_Building_Carrier_Extend>();
                                    inserCModel.ID = 0;
                                    inserCModel.UserId = cmodel.CreateBy;
                                    if (CarrierModel.OpenTime.HasValue)
                                    {
                                        if (CarrierModel.OpenTime.Value <= System.DateTime.Now)
                                        {
                                            inserCModel.OpeningStatus = 1;
                                        }
                                    }
                                    if (!string.IsNullOrWhiteSpace(CarrierModel.StartingInfo))
                                    {
                                        inserCModel.FirstStoreTest = 1;
                                    }
                                    int Id = building_CarrierRepository.Insert(inserCModel, trans);
                                    if (Id > 0)
                                    {
                                        var mlist = MetroList.RefMapperToList<RB_CarrierEnterpriseMetroApplyFor_Extend>();
                                        mlist.ForEach(x =>
                                        {
                                            x.ID = 0;
                                            x.CarrierId = Id;
                                            x.Status = 0;
                                            x.TenantId = CarrierModel.TenantId;
                                            x.MallBaseId = CarrierModel.MallBaseId;
                                        });
                                        carrierEnterpriseMetroApplyForRepository.InsertBatch(mlist, trans);
                                    }
                                    #endregion
                                }
                            }
                        }
                        else if (cmodel.FirstShopType == 3)
                        {
                            //企业服务
                            var brandList = enterpriseServicesApplyRepository.GetEnterpriseServicesApplyRepository(new RB_EnterpriseServicesApply_Extend { MallBaseId = cmodel.MallBaseId, CompanyId = cmodel.CompanyId });
                            if (brandList != null && brandList.Any())
                            {
                                var BrandModel = brandList.FirstOrDefault();
                                if (BrandModel.ExistServiceId > 0)
                                {
                                    //修改
                                    #region 验证品牌是否已关联用户
                                    //var bmodel = brand2Repository.GetEntity(BrandModel.ExistBrandId);
                                    //if (bmodel.UserId > 0)
                                    //{
                                    //    companyEnterpriseRepository.DBSession.Rollback();
                                    //    return "该品牌已被其他用户认证，请核实后再试";
                                    //}
                                    #endregion
                                    Dictionary<string, object> filedsBrand = new Dictionary<string, object>()
                                     {
                                        { nameof(RB_EnterpriseServices_Extend.Name),BrandModel.Name},
                                        { nameof(RB_EnterpriseServices_Extend.Banner),BrandModel.Banner},
                                        { nameof(RB_EnterpriseServices_Extend.Introduction),BrandModel.Introduction},
                                        { nameof(RB_EnterpriseServices_Extend.DevIntention),BrandModel.DevIntention},
                                        { nameof(RB_EnterpriseServices_Extend.Address),BrandModel.Address},
                                        { nameof(RB_EnterpriseServices_Extend.LatAndLon),BrandModel.LatAndLon},
                                        { nameof(RB_EnterpriseServices_Extend.OperationTime),BrandModel.OperationTime},
                                        { nameof(RB_EnterpriseServices_Extend.CategoryId),BrandModel.CategoryId},
                                        { nameof(RB_EnterpriseServices_Extend.Renovation),BrandModel.Renovation},
                                        { nameof(RB_EnterpriseServices_Extend.Payment),BrandModel.Payment},
                                        { nameof(RB_EnterpriseServices_Extend.HandoverDate),BrandModel.HandoverDate},
                                        { nameof(RB_EnterpriseServices_Extend.IntentionalFloor),BrandModel.IntentionalFloor},
                                        { nameof(RB_EnterpriseServices_Extend.ElevatorNum),BrandModel.ElevatorNum},
                                        { nameof(RB_EnterpriseServices_Extend.PropertyFee),BrandModel.PropertyFee},
                                        { nameof(RB_EnterpriseServices_Extend.RentFee),BrandModel.RentFee},
                                        { nameof(RB_EnterpriseServices_Extend.ContactName),BrandModel.ContactName},
                                        { nameof(RB_EnterpriseServices_Extend.ContactPhone),BrandModel.ContactPhone},
                                        { nameof(RB_EnterpriseServices_Extend.UpdateBy),BrandModel.UpdateBy},
                                        { nameof(RB_EnterpriseServices_Extend.UpdateDate),BrandModel.UpdateDate},
                                    };
                                    enterpriseServicesRepository.Update(filedsBrand, new WhereHelper(nameof(RB_EnterpriseServices_Extend.ServiceId), BrandModel.ExistServiceId), trans);
                                }
                                else
                                {
                                    //新增
                                    #region 再次验证品牌名称
                                    //if (ValidateBrandName(BrandModel.BrandName, cmodel.MallBaseId))
                                    //{
                                    //    companyEnterpriseRepository.DBSession.Rollback();
                                    //    return "该品牌名称已存在,请确认品牌名称后再次审核";
                                    //}
                                    //if (ValidateFullBrandName(BrandModel.FullBrandName, cmodel.MallBaseId))
                                    //{
                                    //    companyEnterpriseRepository.DBSession.Rollback();
                                    //    return "该品牌全名已存在,请确认品牌全名后再次审核";
                                    //}
                                    #endregion

                                    #region 新增品牌
                                    var inserBModel = BrandModel.RefMapperTo<RB_EnterpriseServices_Extend>();
                                    inserBModel.ServiceId = 0;
                                    inserBModel.UserId = cmodel.CreateBy;
                                    enterpriseServicesRepository.Insert(inserBModel, trans);
                                    #endregion
                                }
                            }
                        }
                        else if (cmodel.FirstShopType == 4)
                        {
                            //企业服务
                            var brandList = buildingApplyForRepository.GetBuildingRepository(new RB_BuildingApplyFor_Extend { MallBaseId = cmodel.MallBaseId, CompanyId = cmodel.CompanyId });
                            if (brandList != null && brandList.Any())
                            {
                                var BrandModel = brandList.FirstOrDefault();
                                if (BrandModel.ExistBuildId > 0)
                                {
                                    //修改
                                    #region 验证品牌是否已关联用户
                                    //var bmodel = brand2Repository.GetEntity(BrandModel.ExistBrandId);
                                    //if (bmodel.UserId > 0)
                                    //{
                                    //    companyEnterpriseRepository.DBSession.Rollback();
                                    //    return "该品牌已被其他用户认证，请核实后再试";
                                    //}
                                    #endregion
                                    Dictionary<string, object> filedsBrand = new Dictionary<string, object>()
                                     {
                                        { nameof(RB_Building_Extend.Name),BrandModel.Name},
                                        { nameof(RB_Building_Extend.Banner),BrandModel.Banner},
                                        { nameof(RB_Building_Extend.Address),BrandModel.Address},
                                        { nameof(RB_Building_Extend.LatAndLon),BrandModel.LatAndLon},
                                        { nameof(RB_Building_Extend.OperationTime),BrandModel.OperationTime},
                                        { nameof(RB_Building_Extend.CategoryId),BrandModel.CategoryId},
                                        { nameof(RB_Building_Extend.Areas),BrandModel.Areas},
                                        { nameof(RB_Building_Extend.BuildingNum),BrandModel.BuildingNum},
                                        { nameof(RB_Building_Extend.FloorNum),BrandModel.FloorNum},
                                        { nameof(RB_Building_Extend.ElevatorNum),BrandModel.ElevatorNum},
                                        { nameof(RB_Building_Extend.FloorHeight),BrandModel.FloorHeight},
                                        { nameof(RB_Building_Extend.Developers),BrandModel.Developers},
                                        { nameof(RB_Building_Extend.PropertyComp),BrandModel.PropertyComp},
                                        { nameof(RB_Building_Extend.SaleOrSelf),BrandModel.SaleOrSelf},
                                        { nameof(RB_Building_Extend.IsAllOperate),BrandModel.IsAllOperate},
                                        { nameof(RB_Building_Extend.ConstructionTime),BrandModel.ConstructionTime},
                                        { nameof(RB_Building_Extend.PropertyFee),BrandModel.PropertyFee},
                                        { nameof(RB_Building_Extend.RentFee),BrandModel.RentFee},
                                        { nameof(RB_Building_Extend.IndustryDirection),BrandModel.IndustryDirection},
                                        { nameof(RB_Building_Extend.BrandDemand),BrandModel.BrandDemand},
                                        { nameof(RB_Building_Extend.Other),BrandModel.Other},
                                        { nameof(RB_Building_Extend.ContactName),BrandModel.ContactName},
                                        { nameof(RB_Building_Extend.ContactPhone),BrandModel.ContactPhone},
                                        { nameof(RB_Building_Extend.UpdateBy),BrandModel.UpdateBy},
                                        { nameof(RB_Building_Extend.UpdateDate),BrandModel.UpdateDate},
                                    };
                                    buildingRepository.Update(filedsBrand, new WhereHelper(nameof(RB_Building_Extend.BuildId), BrandModel.ExistBuildId), trans);
                                }
                                else
                                {
                                    //新增
                                    #region 再次验证品牌名称
                                    //if (ValidateBrandName(BrandModel.BrandName, cmodel.MallBaseId))
                                    //{
                                    //    companyEnterpriseRepository.DBSession.Rollback();
                                    //    return "该品牌名称已存在,请确认品牌名称后再次审核";
                                    //}
                                    //if (ValidateFullBrandName(BrandModel.FullBrandName, cmodel.MallBaseId))
                                    //{
                                    //    companyEnterpriseRepository.DBSession.Rollback();
                                    //    return "该品牌全名已存在,请确认品牌全名后再次审核";
                                    //}
                                    #endregion

                                    #region 新增品牌
                                    var inserBModel = BrandModel.RefMapperTo<RB_Building_Extend>();
                                    inserBModel.BuildId = 0;
                                    inserBModel.UserId = cmodel.CreateBy;
                                    buildingRepository.Insert(inserBModel, trans);
                                    #endregion
                                }
                            }
                        }
                    }
                }
                companyEnterpriseRepository.DBSession.Commit();
                return flag ? "" : "出错了，请联系管理员";
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "UpdateCompanyStatus");
                companyEnterpriseRepository.DBSession.Rollback();
                return "出错了，请联系管理员";
            }
        }
        #endregion


        #region 访问量统计
        /// <summary>
        /// 获取访问记录信息
        /// </summary>
        /// <param name="query"></param>
        /// <param name="startTime"></param>
        /// <param name="endTime"></param>
        /// <returns></returns>
        public List<RB_Visit_Log_Extend> GetTopStatisticsList(RB_Visit_Log_Extend query)
        {
            var list = visit_LogRepository.GetTopStatisticsList(query);
            if (list != null && list.Any())
            {
                string productIds = string.Join(",", list.Select(x => x.ProductID).Distinct());

                if (query.ProductType == 1)
                {
                    var productList = building_CarrierRepository.GetBuildingCarrierListRepository(new RB_Building_Carrier_Extend { TenantId = query.TenantId, MallBaseId = query.MallBaseId, SelectIds = productIds, OpeningStatus = -1 });
                    list.ForEach(x => x.ProductName = productList?.FirstOrDefault(z => z.ID == x.ProductID)?.CarrierName ?? "");
                }
                else if (query.ProductType == 2) { }
                else if (query.ProductType == 3)
                {
                    var productList = brand_EnterpriseRepository.GetBrandEnterpriseListRepository(new RB_Brand_Enterprise_Extend { TenantId = query.TenantId, MallBaseId = query.MallBaseId, SelectIds = productIds });
                    list.ForEach(x => x.ProductName = productList?.FirstOrDefault(z => z.ID == x.ProductID)?.BrandName ?? "");
                }

                else if (query.ProductType == 4) { }

            }
            return list;
        }
        #endregion


        #region 收藏
        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Collect_Extend> GetMyCollectEnterprisePage(int pageIndex, int pageSize, out long rowCount, RB_Collect_Extend query)
        {
            var list = collectRepository.GetPageList(pageIndex, pageSize, out rowCount, query);
            string sourceIds = "";
            if (list != null && list.Any())
            {
                sourceIds = string.Join(",", list.Select(x => x.SourceId));
            }
            if (query.Type == 1)//1-载体
            {
                if (!string.IsNullOrEmpty(sourceIds))
                {
                    var sourceList = GetBuildingCarrierListModule(new RB_Building_Carrier_Extend { TenantId = query.TenantId, MallBaseId = query.MallBaseId, SelectIds = sourceIds });
                    foreach (var item in list)
                    {
                        RB_Building_Carrier_Extend carrierModel = sourceList.Where(x => x.ID == item.SourceId).FirstOrDefault();
                        if (carrierModel != null && carrierModel.ID > 0)
                        {
                            item.SourceName = carrierModel.CarrierName;
                            item.Address = carrierModel.Address;
                            item.ProjectName = carrierModel.CategoryName;
                            item.ProjectId = carrierModel.CategoryId;
                            item.BannerList = carrierModel.BannerList;
                        }
                    }
                }
            }
            else if (query.Type == 2)//2-品牌
            {
                if (!string.IsNullOrEmpty(sourceIds))
                {
                    var sourceList = GetBrandEnterpriseListModule(new RB_Brand_Enterprise_Extend
                    {
                        TenantId = query.TenantId,
                        MallBaseId = query.MallBaseId,
                        SelectIds = sourceIds,
                        RanQi = -1,
                        KongTiao = -1,
                        XinFeng = -1,
                        Plumbing = -1,
                        Caliber = -1,
                        Sewage = -1,
                        PaiYan = -1,
                    });
                    foreach (var item in list)
                    {
                        RB_Brand_Enterprise_Extend carrierModel = sourceList.Where(x => x.ID == item.SourceId).FirstOrDefault();
                        if (carrierModel != null && carrierModel.ID > 0)
                        {
                            if (!string.IsNullOrWhiteSpace(carrierModel.Banner))
                            {
                                carrierModel.BannerList = JsonConvert.DeserializeObject<List<string>>(carrierModel.Banner);
                            }
                            item.SourceName = carrierModel.BrandName;
                            item.SourceFullName = carrierModel.FullBrandName;
                            item.ProjectName = carrierModel.CategoryName;
                            item.ProjectId = carrierModel.CategoryId;
                            item.BannerList = carrierModel.BannerList;
                        }
                    }
                }
            }
            else if (query.Type == 3)//企业
            {
                if (!string.IsNullOrEmpty(sourceIds))
                {
                    var sourceList = enterpriseServicesRepository.GetEnterpriseServicesListRepository(new RB_EnterpriseServices_Extend
                    {
                        TenantId = query.TenantId,
                        MallBaseId = query.MallBaseId,
                        SelectIds = sourceIds,
                    });
                    foreach (var item in list)
                    {
                        RB_EnterpriseServices_Extend carrierModel = sourceList.Where(x => x.ServiceId == item.SourceId).FirstOrDefault();
                        if (carrierModel != null && carrierModel.ServiceId > 0)
                        {
                            if (!string.IsNullOrWhiteSpace(carrierModel.Banner))
                            {
                                carrierModel.BannerList = JsonConvert.DeserializeObject<List<string>>(carrierModel.Banner);
                            }
                            item.SourceName = carrierModel.Name;
                            item.SourceFullName = carrierModel.Name;
                            item.ProjectName = carrierModel.CategoryName;
                            item.ProjectId = carrierModel.CategoryId;
                            item.BannerList = carrierModel.BannerList;
                        }
                    }
                }
            }
            else if (query.Type == 4)//楼宇
            {
                if (!string.IsNullOrEmpty(sourceIds))
                {
                    var sourceList = buildingRepository.GetBuildingRepository(new RB_Building_Extend
                    {
                        TenantId = query.TenantId,
                        MallBaseId = query.MallBaseId,
                        QIds = sourceIds,
                    });
                    foreach (var item in list)
                    {
                        RB_Building_Extend carrierModel = sourceList.Where(x => x.BuildId == item.SourceId).FirstOrDefault();
                        if (carrierModel != null && carrierModel.BuildId > 0)
                        {
                            if (!string.IsNullOrWhiteSpace(carrierModel.Banner))
                            {
                                carrierModel.BannerList = JsonConvert.DeserializeObject<List<string>>(carrierModel.Banner);
                            }
                            item.SourceName = carrierModel.Name;
                            item.SourceFullName = carrierModel.Name;
                            item.ProjectName = carrierModel.CategoryName;
                            item.ProjectId = carrierModel.CategoryId;
                            item.BannerList = carrierModel.BannerList;
                        }
                    }
                }
            }
            return list;
        }
        #endregion
    }
}
