﻿using Mall.CacheManager.Base;
using Mall.Common.API;
using Mall.Common.Plugin;
using Mall.Model.Extend.TradePavilion;
using Mall.Module.TradePavilion;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Threading.Tasks;

namespace Mall.WebApi.Controllers.TradePavilion
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class YBTradeController : BaseController
    {


        private readonly BuildingCarrierModule buildingCarrierModule = new BuildingCarrierModule();

        RedisHelper redisHelper = new RedisHelper();

        /// <summary>
        /// 获取活力楼宇分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetBuildingPage()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            ResultPageModel pageModel = new ResultPageModel()
            {
                pageIndex = parms.GetInt("pageIndex"),
                pageSize = parms.GetInt("pageSize"),
            };
            RB_Building_Extend query = new RB_Building_Extend()
            {
                Name = parms.GetStringValue("Name"),
                CategoryId = parms.GetInt("CategoryId"),
                Address = parms.GetStringValue("Address"),
                MallBaseId = RequestParm.MallBaseId,
                TenantId = RequestParm.TenantId,
            };

            List<object> list = new List<object>();
            var dataList = buildingCarrierModule.GetBuildingPageModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            foreach (var item in dataList)
            {
                string CoverImg = "";
                if (!string.IsNullOrEmpty(item.Banner))
                {
                    try
                    {
                        List<string> imgList = Common.Plugin.JsonHelper.DeserializeObject<List<string>>(item.Banner);
                        CoverImg = imgList?.FirstOrDefault() ?? "";
                    }
                    catch
                    {

                    }
                }
                list.Add(new
                {
                    item.BuildId,
                    item.Name,
                    CoverImg,
                    item.Address,
                    item.LatAndLon,
                    item.OperationTime,
                    item.CategoryId,
                    item.CategoryName,
                    item.Areas,
                    item.BuildingNum,
                    item.FloorNum,
                    item.ElevatorNum,
                    item.FloorHeight,
                    item.Developers,
                    item.PropertyComp,
                    item.SaleOrSelf,
                    item.IsAllOperate,
                    item.ConstructionTime,
                    item.PropertyFee,
                    item.RentFee,
                    item.IndustryDirection,
                    item.BrandDemand,
                    item.Other,
                    item.ContactName,
                    item.ContactPhone,
                    CreateDate = Common.ConvertHelper.FormatTime(item.CreateDate),
                });
            }
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 新增修改活力楼宇
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetBuildingInfo()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            RB_Building_Extend extModel = new RB_Building_Extend()
            {
                BuildId = parms.GetInt("BuildId"),
                Name = parms.GetStringValue("Name"),
                Address = parms.GetStringValue("Address"),
                LatAndLon = parms.GetStringValue("LatAndLon"),
                OperationTime = parms.GetStringValue("OperationTime"),
                CategoryId = parms.GetInt("CategoryId"),
                Areas = parms.GetStringValue("Areas"),
                BuildingNum = parms.GetStringValue("BuildingNum"),
                FloorNum = parms.GetStringValue("FloorNum"),
                ElevatorNum = parms.GetStringValue("ElevatorNum"),
                FloorHeight = parms.GetDecimal("FloorHeight"),
                Developers = parms.GetStringValue("Developers"),
                PropertyComp = parms.GetStringValue("PropertyComp"),
                SaleOrSelf = parms.GetStringValue("SaleOrSelf"),
                IsAllOperate = parms.GetInt("IsAllOperate"),
                ConstructionTime = parms.GetStringValue("ConstructionTime"),
                PropertyFee = parms.GetDecimal("PropertyFee"),
                RentFee = parms.GetDecimal("RentFee"),
                IndustryDirection = parms.GetStringValue("IndustryDirection"),
                BrandDemand = parms.GetStringValue("BrandDemand"),
                Other = parms.GetStringValue("Other"),
                ContactName = parms.GetStringValue("ContactName"),
                ContactPhone = parms.GetStringValue("ContactPhone"),
            };
            List<string> bannerList = new List<string>();
            string BannerStr = parms.GetStringValue("Banner");
            if (!string.IsNullOrEmpty(BannerStr))
            {
                try
                {
                    bannerList = Common.Plugin.JsonHelper.DeserializeObject<List<string>>(BannerStr);
                }
                catch
                {

                }
            }
            extModel.Banner = Common.Plugin.JsonHelper.Serialize(bannerList);

            if (extModel.BuildId == 0)
            {
                extModel.CreateBy = RequestParm.TenantId;
                extModel.CreateDate = DateTime.Now;
            }
            else
            {
                extModel.UpdateBy = RequestParm.TenantId;
                extModel.UpdateDate = DateTime.Now;
            }
            extModel.TenantId = RequestParm.TenantId;
            extModel.MallBaseId = RequestParm.MallBaseId;
            bool flag = buildingCarrierModule.SetBuildingModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 根据编号获取活力楼宇信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetBuildingInfo()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            int BuildingId = parms.GetInt("BuildId");
            if (BuildingId <= 0)
            {
                return ApiResult.ParamIsNull(message: "参数不能为空");
            }
            var extModel = buildingCarrierModule.GetBuildingInfoModule(BuildingId);
            List<string> Banner = new List<string>();
            string BannerStr = extModel?.Banner ?? "";
            if (!string.IsNullOrEmpty(BannerStr))
            {
                try
                {
                    Banner = Common.Plugin.JsonHelper.DeserializeObject<List<string>>(BannerStr);
                }
                catch
                {

                }
            }
            var dataObj = new
            {
                BuildId = extModel?.BuildId ?? 0,
                Name = extModel?.Name ?? "",
                Banner,
                Address = extModel?.Address ?? "",
                LatAndLon = extModel?.LatAndLon ?? "",
                OperationTime = extModel?.OperationTime ?? "",
                CategoryId = extModel?.CategoryId ?? 0,
                CategoryName = extModel?.CategoryName ?? "",
                Areas = extModel?.Areas ?? "",
                BuildingNum = extModel?.BuildingNum ?? "",
                FloorNum = extModel?.FloorNum ?? "",
                ElevatorNum = extModel?.ElevatorNum ?? "",
                FloorHeight = extModel?.FloorHeight ?? 0,
                Developers = extModel?.Developers ?? "",
                PropertyComp = extModel?.PropertyComp ?? "",
                SaleOrSelf = extModel?.SaleOrSelf ?? "",
                IsAllOperate = extModel?.IsAllOperate ?? 0,
                ConstructionTime = extModel?.ConstructionTime ?? "",
                PropertyFee = extModel?.PropertyFee ?? 0,
                RentFee = extModel?.RentFee ?? 0,
                IndustryDirection = extModel?.IndustryDirection ?? "",
                BrandDemand = extModel?.BrandDemand ?? "",
                Other = extModel?.Other ?? "",
                ContactName = extModel?.ContactName ?? "",
                ContactPhone = extModel?.ContactPhone ?? "",
            };
            return ApiResult.Success(data: dataObj);
        }

        /// <summary>
        /// 根据编号删除活力楼宇
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult RemoveBuildingInfo()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            int BuildId = parms.GetInt("BuildId");
            if (BuildId <= 0)
            {
                return ApiResult.ParamIsNull(message: "参数不能为空");
            }
            var extModel = buildingCarrierModule.RemoveBuildingModule(BuildId);
            return ApiResult.Success(data: extModel);
        }



        /// <summary>
        /// 获取【商载通】载体、楼宇下载枚举列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetBuildingExportEnumList()
        {
            var list = EnumHelper.GetEnumList(typeof(Common.Enum.TradePavilion.SZTBuildExportEnum));
            return ApiResult.Success("", list.Select(x => new
            {
                Name = x.Key,
                Id = Convert.ToInt32(x.Value)
            }));
        }

        /// <summary>
        /// 检查【商再通】楼宇文件是否存在
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public async Task<ApiResult> CheckBuildingFile()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            RB_Building_Extend query = new RB_Building_Extend()
            {
                Name = parms.GetStringValue("Name"),
                CategoryId = parms.GetInt("CategoryId"),
                Address = parms.GetStringValue("Address"),
                MallBaseId = RequestParm.MallBaseId,
                TenantId = RequestParm.TenantId,
            };

            string RandomNum = parms.GetStringValue("RandomNum");
            string ExcelEnumIdsStr = parms.GetStringValue("ExcelEnumIds");
            List<int> ExcelEnumIds = JsonConvert.DeserializeObject<List<int>>(ExcelEnumIdsStr);
            string hashKey = Common.Config.GetHash(Common.Plugin.JsonHelper.Serialize(query) + ExcelEnumIdsStr + RandomNum);
            string fileName = "楼宇" + ".xls";
            string filePath = Path.Combine(Directory.GetCurrentDirectory(), "upfile/temporary");
            if (System.IO.Directory.Exists(filePath) == false)//如果不存在就创建file文件夹
            {
                System.IO.Directory.CreateDirectory(filePath);
            }
            string tempPath = filePath + "\\" + hashKey + "\\";
            //如果不存在就创建file文件夹
            if (!System.IO.Directory.Exists(tempPath))
            {
                System.IO.Directory.CreateDirectory(tempPath);
            }
            string fileUrl = tempPath + fileName;
            string key = "Mall_SD_BUILDINGCARRIER_" + hashKey;
            string redisValue = redisHelper.StringGet(key);
            if (string.IsNullOrEmpty(redisValue))
            {
                redisValue = redisHelper.StringGet(key);
                if (string.IsNullOrEmpty(redisValue))
                {
                    redisHelper.StringSet(key, fileName, TimeSpan.FromMinutes(10));
                    Task.Run(() =>
                    {
                        GetBuildingListToExcel(query, ExcelEnumIds, tempPath, fileUrl);
                    });
                }
            }
            return await Task.Run<ApiResult>(() =>
            {
                ApiResult apiResult = new ApiResult()
                {
                    resultCode = 0,
                };
                if (System.IO.File.Exists(fileUrl))
                {
                    var filePath = "/upfile/temporary/" + hashKey + "/";
                    var fileUrl = "/upfile/temporary/" + hashKey + "/" + fileName;
                    apiResult.resultCode = 1;
                    apiResult.data = new { filePath, fileUrl };
                    apiResult.message = key;
                }
                return apiResult;
            });
        }


        /// <summary>
        /// 生成【商载通】载体、楼宇文件
        /// </summary>
        /// <param name="demodel">查询参数</param>
        /// <param name="ExcelEnumIdList">下载列</param>
        /// <param name="filePath">Logo文件存放路径</param>
        /// <param name="excelFileUrl">Excel文件路径</param>
        private async void GetBuildingListToExcel(RB_Building_Extend demodel, List<int> ExcelEnumIdList, string filePath, string excelFileUrl)
        {
            byte[] bytes = null;
            string ExcelName = "载体列表" + DateTime.Now.ToString("yyyyMMddHHmmss") + ".xls";
            List<ExcelDataSource> slist = new List<ExcelDataSource>();
            var Enumlist = EnumHelper.GetEnumList(typeof(Common.Enum.TradePavilion.SZTBuildExportEnum));
            ExcelDataSource header = new ExcelDataSource()
            {
                ExcelRows = new List<ExcelColumn>(30)
                {
                    new ExcelColumn(value: "序号") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER }
                }
            };
            foreach (var item in ExcelEnumIdList)
            {
                var Name = Enumlist.Where(x => x.Value == item.ToString()).FirstOrDefault().Key ?? "";
                header.ExcelRows.Add(new ExcelColumn(value: Name) { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER });
            }
            slist.Add(header);
            try
            {
                var list = buildingCarrierModule.GetBuildingModule(demodel);
                List<Action> actions = new List<Action>();
                if (list != null && list.Count > 0)
                {
                    //判断是否下载图片
                    if (ExcelEnumIdList.Contains(2))
                    {
                        foreach (var item in list)
                        {
                            if (item.BannerList != null && item.BannerList.Any())
                            {
                                actions.Add(new Action(() =>
                                {
                                    DownLoadUrl(item.BannerList.FirstOrDefault(), filePath);
                                }));
                            }
                        }
                    }
                }

                if (actions != null && actions.Count > 0)
                {
                    ParallelOptions options = new ParallelOptions { MaxDegreeOfParallelism = 4 };  // 设置最大并行度为 4
                    Parallel.Invoke(options, actions.ToArray());
                }

                #region 组装数据
                int Num = 0;
                foreach (var item in list)
                {
                    Num++;
                    ExcelDataSource datarow = new ExcelDataSource()
                    {
                        ExcelRows = new List<ExcelColumn>(30) {
                            new ExcelColumn(value:Num.ToString()){ },
                        }
                    };
                    foreach (var qitem in ExcelEnumIdList)
                    {
                        //
                        switch (qitem)
                        {
                            case 1:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.Name) { }); break;
                            case 2:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.BannerList?.FirstOrDefault() ?? "", isPic: 1) { }); break;
                            case 3:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.Address) { }); break;
                            case 4:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.LatAndLon) { }); break;
                            case 5:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.OperationTime ) { }); break;
                            case 6:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.CategoryName) { }); break;
                            case 7:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.Areas) { }); break;
                            case 8:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.BuildingNum) { }); break;
                            case 9:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.FloorNum) { }); break;
                            case 10:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.ElevatorNum) { }); break;
                            case 11:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.FloorHeight.ToString("")) { }); break;
                            case 12:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.Developers) { }); break;
                            case 13:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.PropertyComp) { }); break;
                            case 14:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.SaleOrSelf) { }); break;
                            case 15:
                                datarow.ExcelRows.Add(new ExcelColumn(value: (item.IsAllOperate == 1 ? "是" : "否")) { }); break;
                            case 16:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.ConstructionTime) { }); break;
                            case 17:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.PropertyFee.ToString("")) { }); break;
                            case 18:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.RentFee.ToString("")) { }); break;
                            case 19:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.IndustryDirection) { }); break;
                            case 20:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.BrandDemand) { }); break;
                            case 21:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.Other) { }); break;
                            case 22:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.ContactName) { }); break;
                            case 23:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.ContactPhone) { }); break;
                        }
                    }
                    slist.Add(datarow);
                }
                #endregion
                bytes = ExcelTempLateHelper.ToBrandExcelExtend(slist, filePath);
                using (FileStream fs = new FileStream(excelFileUrl, FileMode.CreateNew))
                {
                    fs.Write(bytes, 0, bytes.Length);
                }
            }
            catch (Exception ex)
            {
                bytes = ExcelTempLateHelper.ToBrandExcelExtend(slist, filePath);
                using (FileStream fs = new FileStream(excelFileUrl, FileMode.CreateNew))
                {
                    fs.Write(bytes, 0, bytes.Length);
                }
                LogHelper.Write(ex, string.Format("GetBuildingCarrierListToExcel_Requst: {0}", JsonHelper.Serialize(demodel)));
            }
        }

        ///// <summary>
        ///// 获取【商载通】载体、楼宇下载枚举列表
        ///// </summary>
        ///// <returns></returns>
        //[HttpPost]
        //public ApiResult GetBuildingCarrierExportEnumList()
        //{
        //    var list = EnumHelper.GetEnumList(typeof(Common.Enum.TradePavilion.BuildCarrierExportEnum));
        //    return ApiResult.Success("", list.Select(x => new
        //    {
        //        Name = x.Key,
        //        Id = Convert.ToInt32(x.Value)
        //    }));
        //}

        ///// <summary>
        ///// 检查【商再通】载体、楼宇文件是否存在
        ///// </summary>
        ///// <returns></returns>
        //[HttpPost]
        //public async Task<ApiResult> CheckBuildingCarrierFile()
        //{
        //    JObject parms = JObject.Parse(RequestParm.msg.ToString());
        //    RB_Building_Carrier_Extend query = new RB_Building_Carrier_Extend()
        //    {
        //        CarrierName = parms.GetStringValue("CarrierName"),
        //        CategoryId = parms.GetInt("CategoryId"),
        //        QStartDate = parms.GetStringValue("QStartDate"),
        //        QEndDate = parms.GetStringValue("QEndDate"),
        //        MetroName = parms.GetStringValue("MetroName"),
        //        MetroNum = parms.GetInt("MetroNum"),
        //        BuildingCarrierType = parms.GetInt("BuildingCarrierType"),
        //        OpeningStatus = parms.GetInt("OpeningStatus", -1),
        //        QShopType = parms.GetInt("QShopType"),
        //        MallBaseId = RequestParm.MallBaseId,
        //        TenantId = RequestParm.TenantId,
        //    };

        //    string RandomNum = parms.GetStringValue("RandomNum");
        //    string ExcelEnumIdsStr = parms.GetStringValue("ExcelEnumIds");
        //    List<int> ExcelEnumIds = JsonConvert.DeserializeObject<List<int>>(ExcelEnumIdsStr);
        //    string hashKey = Common.Config.GetHash(Common.Plugin.JsonHelper.Serialize(query) + ExcelEnumIdsStr + RandomNum);
        //    string fileName = "载体楼宇" + ".xls";
        //    string filePath = Path.Combine(Directory.GetCurrentDirectory(), "upfile/temporary");
        //    if (System.IO.Directory.Exists(filePath) == false)//如果不存在就创建file文件夹
        //    {
        //        System.IO.Directory.CreateDirectory(filePath);
        //    }
        //    string tempPath = filePath + "\\" + hashKey + "\\";
        //    //如果不存在就创建file文件夹
        //    if (!System.IO.Directory.Exists(tempPath))
        //    {
        //        System.IO.Directory.CreateDirectory(tempPath);
        //    }
        //    string fileUrl = tempPath + fileName;
        //    string key = "Mall_SD_BUILDINGCARRIER_" + hashKey;
        //    string redisValue = redisHelper.StringGet(key);
        //    if (string.IsNullOrEmpty(redisValue))
        //    {
        //        redisValue = redisHelper.StringGet(key);
        //        if (string.IsNullOrEmpty(redisValue))
        //        {
        //            redisHelper.StringSet(key, fileName, TimeSpan.FromMinutes(10));
        //            Task.Run(() =>
        //            {
        //                GetBuildingCarrierListToExcel(query, ExcelEnumIds, tempPath, fileUrl);
        //            });
        //        }
        //    }
        //    return await Task.Run<ApiResult>(() =>
        //    {
        //        ApiResult apiResult = new ApiResult()
        //        {
        //            resultCode = 0,
        //        };
        //        if (System.IO.File.Exists(fileUrl))
        //        {
        //            var filePath = "/upfile/temporary/" + hashKey + "/";
        //            var fileUrl = "/upfile/temporary/" + hashKey + "/" + fileName;
        //            apiResult.resultCode = 1;
        //            apiResult.data = new { filePath, fileUrl };
        //            apiResult.message = key;
        //        }
        //        return apiResult;
        //    });
        //}


        ///// <summary>
        ///// 生成【商载通】载体、楼宇文件
        ///// </summary>
        ///// <param name="demodel">查询参数</param>
        ///// <param name="ExcelEnumIdList">下载列</param>
        ///// <param name="filePath">Logo文件存放路径</param>
        ///// <param name="excelFileUrl">Excel文件路径</param>
        //private async void GetBuildingCarrierListToExcel(RB_Building_Carrier_Extend demodel, List<int> ExcelEnumIdList, string filePath, string excelFileUrl)
        //{
        //    byte[] bytes = null;
        //    string ExcelName = "载体列表" + DateTime.Now.ToString("yyyyMMddHHmmss") + ".xls";
        //    List<ExcelDataSource> slist = new List<ExcelDataSource>();
        //    var Enumlist = EnumHelper.GetEnumList(typeof(Common.Enum.TradePavilion.BuildCarrierExportEnum));
        //    ExcelDataSource header = new ExcelDataSource()
        //    {
        //        ExcelRows = new List<ExcelColumn>(30)
        //        {
        //            new ExcelColumn(value: "序号") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER }
        //        }
        //    };
        //    foreach (var item in ExcelEnumIdList)
        //    {
        //        var Name = Enumlist.Where(x => x.Value == item.ToString()).FirstOrDefault().Key ?? "";
        //        header.ExcelRows.Add(new ExcelColumn(value: Name) { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER });
        //    }
        //    slist.Add(header);
        //    try
        //    {
        //        var list = buildingCarrierModule.GetBuildingCarrierListModule(demodel);
        //        List<Action> actions = new List<Action>();
        //        if (list != null && list.Count > 0)
        //        {
        //            //判断是否下载图片
        //            if (ExcelEnumIdList.Contains(2))
        //            {
        //                foreach (var item in list)
        //                {
        //                    actions.Add(new Action(() =>
        //                    {
        //                        DownLoadUrl(item.Logo, filePath);
        //                    }));
        //                }
        //            }
        //        }

        //        if (actions != null && actions.Count > 0)
        //        {
        //            ParallelOptions options = new ParallelOptions { MaxDegreeOfParallelism = 4 };  // 设置最大并行度为 4
        //            Parallel.Invoke(options, actions.ToArray());
        //        }

        //        #region 组装数据
        //        int Num = 0;
        //        foreach (var item in list)
        //        {
        //            Num++;
        //            ExcelDataSource datarow = new ExcelDataSource()
        //            {
        //                ExcelRows = new List<ExcelColumn>(30) {
        //                    new ExcelColumn(value:Num.ToString()){ },
        //                }
        //            };
        //            foreach (var qitem in ExcelEnumIdList)
        //            {
        //                switch (qitem)
        //                {
        //                    case 1:
        //                        datarow.ExcelRows.Add(new ExcelColumn(value: item.CarrierName) { }); break;
        //                    case 2:
        //                        datarow.ExcelRows.Add(new ExcelColumn(value: item.Logo, isPic: 1) { }); break;
        //                    case 3:
        //                        datarow.ExcelRows.Add(new ExcelColumn(value: item.Developers) { }); break;
        //                    case 4:
        //                        datarow.ExcelRows.Add(new ExcelColumn(value: item.VideoUrl) { }); break;
        //                    case 5:
        //                        datarow.ExcelRows.Add(new ExcelColumn(value: item.Address) { }); break;
        //                    case 6:
        //                        datarow.ExcelRows.Add(new ExcelColumn(value: Common.ConvertHelper.FormatDate(item.OpenTime)) { }); break;
        //                    case 7:
        //                        datarow.ExcelRows.Add(new ExcelColumn(value: item.CategoryName) { }); break;
        //                    case 8:
        //                        datarow.ExcelRows.Add(new ExcelColumn(value: item.Ascription) { }); break;
        //                    case 9:
        //                        datarow.ExcelRows.Add(new ExcelColumn(value: (item.CarrierSize.ToString()) + "万平方米") { }); break;
        //                    case 10:
        //                        datarow.ExcelRows.Add(new ExcelColumn(value: item.PropertyComposition) { }); break;
        //                    case 11:
        //                        datarow.ExcelRows.Add(new ExcelColumn(value: item.Location) { }); break;
        //                    case 12:
        //                        datarow.ExcelRows.Add(new ExcelColumn(value: item.Crowd) { }); break;
        //                    case 13:
        //                        datarow.ExcelRows.Add(new ExcelColumn(value: item.VisitorsFlowrate) { }); break;
        //                    case 14:
        //                        datarow.ExcelRows.Add(new ExcelColumn(value: item.LayersNum) { }); break;
        //                    case 15:
        //                        datarow.ExcelRows.Add(new ExcelColumn(value: item.SupportingFacilities) { }); break;
        //                    case 16:
        //                        datarow.ExcelRows.Add(new ExcelColumn(value: item.ManagementCompany) { }); break;
        //                    case 17:
        //                        datarow.ExcelRows.Add(new ExcelColumn(value: item.BrandDemand) { }); break;
        //                    case 18:
        //                        datarow.ExcelRows.Add(new ExcelColumn(value: (item.BuildingCarriermetroList != null && item.BuildingCarriermetroList.Any()) ? (string.Join(",", item.BuildingCarriermetroList.Select(x => x.MetroNum + "号线" + x.MetroName + x.Distance))) : "") { }); break;

        //                }
        //            }
        //            slist.Add(datarow);
        //        }
        //        #endregion
        //        bytes = ExcelTempLateHelper.ToBrandExcelExtend(slist, filePath);
        //        using (FileStream fs = new FileStream(excelFileUrl, FileMode.CreateNew))
        //        {
        //            fs.Write(bytes, 0, bytes.Length);
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        bytes = ExcelTempLateHelper.ToBrandExcelExtend(slist, filePath);
        //        using (FileStream fs = new FileStream(excelFileUrl, FileMode.CreateNew))
        //        {
        //            fs.Write(bytes, 0, bytes.Length);
        //        }
        //        LogHelper.Write(ex, string.Format("GetBuildingCarrierListToExcel_Requst: {0}", JsonHelper.Serialize(demodel)));
        //    }
        //}


        /// <summary>
        /// 【商载通】企业服务分页列表
        /// </summary>
        /// <returns></returns>

        [HttpPost]
        public ApiResult GetEnterpriseServicesPage()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            ResultPageModel pageModel = new ResultPageModel()
            {
                pageIndex = parms.GetInt("pageIndex"),
                pageSize = parms.GetInt("pageSize"),
            };
            RB_EnterpriseServices_Extend query = new RB_EnterpriseServices_Extend()
            {
                Name = parms.GetStringValue("Name"),
                CategoryId = parms.GetInt("CategoryId"),
            };
            query.TenantId = RequestParm.TenantId;
            query.MallBaseId = RequestParm.MallBaseId;
            List<object> list = new List<object>();
            var dataList = buildingCarrierModule.GetEnterpriseServicesPageModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            foreach (var item in dataList)
            {
                string CoverImg = "";
                if (!string.IsNullOrEmpty(item.Banner))
                {
                    try
                    {
                        List<string> imgList = Common.Plugin.JsonHelper.DeserializeObject<List<string>>(item.Banner);
                        CoverImg = imgList?.FirstOrDefault() ?? "";
                    }
                    catch
                    {

                    }
                }

                list.Add(new
                {
                    item.ServiceId,
                    item.Name,
                    CoverImg,
                    item.Introduction,
                    item.Address,
                    item.LatAndLon,
                    item.OperationTime,
                    item.CategoryId,
                    item.CategoryName,
                    item.Renovation,
                    item.Payment,
                    item.HandoverDate,
                    item.PropertyFee,
                    item.IntentionalFloor,
                    item.ElevatorNum,
                    item.RentFee,
                    item.ContactName,
                    item.ContactPhone,
                    item.ETypeName,
                    item.EType,
                    CreateDate = Common.ConvertHelper.FormatDate(item.CreateDate),
                });
            }
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 【商载通】新增修改企业服务
        /// </summary>
        /// <returns></returns>
        public ApiResult SetEnterpriseServicesInfo()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            RB_EnterpriseServices_Extend model = new RB_EnterpriseServices_Extend()
            {
                ServiceId = parms.GetInt("ServiceId"),
                Name = parms.GetStringValue("Name"),
                Introduction = parms.GetStringValue("Introduction"),
                DevIntention = parms.GetStringValue("DevIntention"),
                Address = parms.GetStringValue("Address"),
                LatAndLon = parms.GetStringValue("LatAndLon"),
                OperationTime = parms.GetStringValue("OperationTime"),
                CategoryId = parms.GetInt("CategoryId"),
                Renovation = parms.GetStringValue("Renovation"),
                Payment = parms.GetStringValue("Payment"),
                HandoverDate = parms.GetStringValue("HandoverDate"),
                IntentionalFloor = parms.GetStringValue("IntentionalFloor"),
                ElevatorNum = parms.GetStringValue("ElevatorNum"),
                PropertyFee = parms.GetDecimal("PropertyFee"),
                RentFee = parms.GetDecimal("RentFee"),
                ContactName = parms.GetStringValue("ContactName"),
                ContactPhone = parms.GetStringValue("ContactPhone"),
                EType = parms.GetInt("EType"),
            };
            List<string> BannerList = new List<string>();
            string bannerListStr = parms.GetStringValue("BannerList");
            if (!string.IsNullOrEmpty(bannerListStr))
            {
                try
                {
                    BannerList = Common.Plugin.JsonHelper.DeserializeObject<List<string>>(bannerListStr);
                }
                catch
                {

                }
            }
            model.Banner = Common.Plugin.JsonHelper.Serialize(BannerList);
            model.TenantId = RequestParm.TenantId;
            model.MallBaseId = RequestParm.MallBaseId;
            if (model.ServiceId > 0)
            {
                model.UpdateBy = RequestParm.TenantId;
                model.UpdateDate = DateTime.Now;
            }
            else
            {
                model.CreateBy = RequestParm.TenantId;
                model.CreateDate = DateTime.Now;
            }
            bool flag = buildingCarrierModule.SetEnterpriseServicesModule(model);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 根据编号获取企业服务详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetEnterpriseServicesInfo()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            int ServiceId = parms.GetInt("ServiceId");
            if (ServiceId <= 0)
            {
                return ApiResult.ParamIsNull(message: "编号不能为空!");
            }
            List<string> BannerList = new List<string>();
            var extModel = buildingCarrierModule.GetEnterpriseServicesInfoModule(ServiceId);
            string Banner = extModel?.Banner ?? "";
            if (!string.IsNullOrEmpty(Banner))
            {
                try
                {
                    BannerList = Common.Plugin.JsonHelper.DeserializeObject<List<string>>(Banner);
                }
                catch
                {

                }
            }
            var dataObj = new
            {
                ServiceId = extModel?.ServiceId ?? 0,
                Name = extModel?.Name ?? "",
                Introduction = extModel?.Introduction ?? "",
                DevIntention = extModel?.DevIntention ?? "",
                Address = extModel?.Address ?? "",
                LatAndLon = extModel?.LatAndLon ?? "",
                OperationTime = extModel?.OperationTime ?? "",
                CategoryId = extModel?.CategoryId ?? 0,
                CategoryName = extModel?.CategoryName ?? "",
                Renovation = extModel?.Renovation ?? "",
                Payment = extModel?.Payment ?? "",
                HandoverDate = extModel?.HandoverDate ?? "",
                IntentionalFloor = extModel?.IntentionalFloor ?? "",
                ElevatorNum = extModel?.ElevatorNum ?? "",
                PropertyFee = extModel?.PropertyFee ?? 0,
                RentFee = extModel?.RentFee ?? 0,
                ContactName = extModel?.ContactName ?? "",
                ContactPhone = extModel?.ContactPhone ?? "",
                EType = extModel?.EType ?? 0,
                ETypeName = extModel?.ETypeName ?? "",
                BannerList,
            };
            return ApiResult.Success(data: dataObj);
        }

        /// <summary>
        /// 根据编号删除企业服务
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveEnterpriseServicesInfo()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            int ServiceId = parms.GetInt("ServiceId");
            if (ServiceId <= 0)
            {
                return ApiResult.ParamIsNull(message: "参数不能为空");
            }
            bool flag = buildingCarrierModule.RemoveEnterpriseServicesModule(ServiceId);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }




        /// <summary>
        /// 获取【商载通】载体、楼宇下载枚举列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetEnterpriseServicesExportEnumList()
        {
            var list = EnumHelper.GetEnumList(typeof(Common.Enum.TradePavilion.SZTBrandServicesExportEnum));
            return ApiResult.Success("", list.Select(x => new
            {
                Name = x.Key,
                Id = Convert.ToInt32(x.Value)
            }));
        }

        /// <summary>
        /// 检查【商再通】企业服务文件是否存在
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public async Task<ApiResult> CheckEnterpriseServicesFile()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            RB_EnterpriseServices_Extend query = new RB_EnterpriseServices_Extend()
            {
                Name = parms.GetStringValue("Name"),
                CategoryId = parms.GetInt("CategoryId"),
                MallBaseId = RequestParm.MallBaseId,
                TenantId = RequestParm.TenantId,
            };
            string RandomNum = parms.GetStringValue("RandomNum");
            string ExcelEnumIdsStr = parms.GetStringValue("ExcelEnumIds");
            List<int> ExcelEnumIds = JsonConvert.DeserializeObject<List<int>>(ExcelEnumIdsStr);
            string hashKey = Common.Config.GetHash(Common.Plugin.JsonHelper.Serialize(query) + ExcelEnumIdsStr + RandomNum);
            string fileName = "企业服务" + ".xls";
            string filePath = Path.Combine(Directory.GetCurrentDirectory(), "upfile/temporary");
            if (System.IO.Directory.Exists(filePath) == false)//如果不存在就创建file文件夹
            {
                System.IO.Directory.CreateDirectory(filePath);
            }
            string tempPath = filePath + "\\" + hashKey + "\\";
            //如果不存在就创建file文件夹
            if (!System.IO.Directory.Exists(tempPath))
            {
                System.IO.Directory.CreateDirectory(tempPath);
            }
            string fileUrl = tempPath + fileName;
            string key = "Mall_SD_BUILDINGCARRIER_" + hashKey;
            string redisValue = redisHelper.StringGet(key);
            if (string.IsNullOrEmpty(redisValue))
            {
                redisValue = redisHelper.StringGet(key);
                if (string.IsNullOrEmpty(redisValue))
                {
                    redisHelper.StringSet(key, fileName, TimeSpan.FromMinutes(10));
                    Task.Run(() =>
                    {
                        GetEnterpriseServicesListToExcel(query, ExcelEnumIds, tempPath, fileUrl);
                    });
                }
            }
            return await Task.Run<ApiResult>(() =>
            {
                ApiResult apiResult = new ApiResult()
                {
                    resultCode = 0,
                };
                if (System.IO.File.Exists(fileUrl))
                {
                    var filePath = "/upfile/temporary/" + hashKey + "/";
                    var fileUrl = "/upfile/temporary/" + hashKey + "/" + fileName;
                    apiResult.resultCode = 1;
                    apiResult.data = new { filePath, fileUrl };
                    apiResult.message = key;
                }
                return apiResult;
            });
        }


        /// <summary>
        /// 生成【商载通】载体、楼宇文件
        /// </summary>
        /// <param name="demodel">查询参数</param>
        /// <param name="ExcelEnumIdList">下载列</param>
        /// <param name="filePath">Logo文件存放路径</param>
        /// <param name="excelFileUrl">Excel文件路径</param>
        private async void GetEnterpriseServicesListToExcel(RB_EnterpriseServices_Extend demodel, List<int> ExcelEnumIdList, string filePath, string excelFileUrl)
        {
            byte[] bytes = null;
            string ExcelName = "企业服务" + DateTime.Now.ToString("yyyyMMddHHmmss") + ".xls";
            List<ExcelDataSource> slist = new List<ExcelDataSource>();
            var Enumlist = EnumHelper.GetEnumList(typeof(Common.Enum.TradePavilion.SZTBrandServicesExportEnum));
            ExcelDataSource header = new ExcelDataSource()
            {
                ExcelRows = new List<ExcelColumn>(30)
                {
                    new ExcelColumn(value: "序号") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER }
                }
            };
            foreach (var item in ExcelEnumIdList)
            {
                var Name = Enumlist.Where(x => x.Value == item.ToString()).FirstOrDefault().Key ?? "";
                header.ExcelRows.Add(new ExcelColumn(value: Name) { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER });
            }
            slist.Add(header);
            try
            {
                var list = buildingCarrierModule.GetEnterpriseServicesModule(demodel);
                List<Action> actions = new List<Action>();
                if (list != null && list.Count > 0)
                {
                    //判断是否下载图片
                    if (ExcelEnumIdList.Contains(2))
                    {
                        foreach (var item in list)
                        {
                            if (item.BannerList != null && item.BannerList.Any())
                            {
                                actions.Add(new Action(() =>
                                {
                                    DownLoadUrl(item.BannerList.FirstOrDefault(), filePath);
                                }));
                            }
                        }
                    }
                }

                if (actions != null && actions.Count > 0)
                {
                    ParallelOptions options = new ParallelOptions { MaxDegreeOfParallelism = 4 };  // 设置最大并行度为 4
                    Parallel.Invoke(options, actions.ToArray());
                }

                #region 组装数据
                int Num = 0;
                foreach (var item in list)
                {
                    Num++;
                    ExcelDataSource datarow = new ExcelDataSource()
                    {
                        ExcelRows = new List<ExcelColumn>(30) {
                            new ExcelColumn(value:Num.ToString()){ },
                        }
                    };
                    foreach (var qitem in ExcelEnumIdList)
                    {
                        //
                        switch (qitem)
                        {
                            case 1:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.Name) { }); break;
                            case 2:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.BannerList?.FirstOrDefault() ?? "", isPic: 1) { }); break;
                            case 3:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.Introduction) { }); break;
                            case 4:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.ETypeName) { }); break;
                            case 5:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.CategoryName) { }); break;
                            case 6:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.Address) { }); break;
                            case 7:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.LatAndLon) { }); break;
                            case 8:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.OperationTime) { }); break;
                            case 9:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.DevIntention) { }); break;
                            case 10:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.Renovation) { }); break;
                            case 11:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.Payment) { }); break;
                            case 12:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.HandoverDate) { }); break;
                            case 13:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.IntentionalFloor) { }); break;
                            case 14:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.ElevatorNum) { }); break;
                            case 15:
                                datarow.ExcelRows.Add(new ExcelColumn(value: (item.PropertyFee.ToString(""))) { }); break;
                            case 16:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.RentFee.ToString("")) { }); break;
                            case 17:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.ContactName) { }); break;
                            case 18:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.ContactPhone) { }); break;
                        }
                    }
                    slist.Add(datarow);
                }
                #endregion
                bytes = ExcelTempLateHelper.ToBrandExcelExtend(slist, filePath);
                using (FileStream fs = new FileStream(excelFileUrl, FileMode.CreateNew))
                {
                    fs.Write(bytes, 0, bytes.Length);
                }
            }
            catch (Exception ex)
            {
                bytes = ExcelTempLateHelper.ToBrandExcelExtend(slist, filePath);
                using (FileStream fs = new FileStream(excelFileUrl, FileMode.CreateNew))
                {
                    fs.Write(bytes, 0, bytes.Length);
                }
                LogHelper.Write(ex, string.Format("GetBuildingCarrierListToExcel_Requst: {0}", JsonHelper.Serialize(demodel)));
            }
        }


        /// <summary>
        /// 下载文件
        /// </summary>
        private void DownLoadUrl(string url, string savePath)
        {
            Uri uri = new Uri(url);
            string path = uri.AbsolutePath;
            int lastSlashIndex = path.LastIndexOf('/');
            string fileName = path.Substring(lastSlashIndex + 1);
            string newFilePath = savePath + fileName;
            string logStr = string.Format("{0} 开始下载 Url_{1} 文件 ", DateTime.Now.ToString("MM-dd HH:mm:ss fff"), url);
            try
            {
                HttpWebRequest request = (HttpWebRequest)WebRequest.Create(url);
                request.Timeout = 1000 * 60 * 20; // 10分钟超时时间
                using (WebResponse response = request.GetResponse())
                using (Stream responseStream = response.GetResponseStream())
                using (Stream fileStream = new FileStream(newFilePath, FileMode.Create, FileAccess.Write, FileShare.None))
                {
                    responseStream.CopyTo(fileStream);
                }
            }
            catch (Exception ex)
            {
                logStr = string.Format("{0} 下载 Url_{1} 异常:{2}  message:{3}", DateTime.Now.ToString("MM-dd HH:mm:ss fff"), url, ex.StackTrace, ex.Message);
                LogHelper.WriteInfo(logStr);
            }
        }

        ///// <summary>
        ///// 获取品牌下载枚举列表
        ///// </summary>
        ///// <returns></returns>
        //[HttpPost]
        //public ApiResult GetBrandEnterpriseExportEnumList()
        //{
        //    var list = EnumHelper.GetEnumList(typeof(Common.Enum.TradePavilion.BrandEnterpriseExportEnum));
        //    return ApiResult.Success("", list.Select(x => new
        //    {
        //        Name = x.Key,
        //        Id = Convert.ToInt32(x.Value)
        //    }));
        //}

        ///// <summary>
        ///// 检查品牌文件是否存在
        ///// </summary>
        ///// <returns></returns>
        //[HttpPost]
        //public async Task<ApiResult> CheckBrandEnterpriseFile()
        //{
        //    JObject parms = JObject.Parse(RequestParm.msg.ToString());
        //    RB_Brand_Enterprise_Extend query = new RB_Brand_Enterprise_Extend()
        //    {
        //        BrandEnterpriseType = parms.GetInt("BrandEnterpriseType"),
        //        BrandName = parms.GetStringValue("BrandName"),
        //        CategoryId = parms.GetInt("CategoryId"),
        //    };
        //    query.MallBaseId = RequestParm.MallBaseId;
        //    query.TenantId = RequestParm.TenantId;
        //    string RandomNum = parms.GetStringValue("RandomNum");
        //    string ExcelEnumIdsStr = parms.GetStringValue("ExcelEnumIds");
        //    List<int> ExcelEnumIds = JsonConvert.DeserializeObject<List<int>>(ExcelEnumIdsStr);
        //    string hashKey = Common.Config.GetHash(Common.Plugin.JsonHelper.Serialize(query) + ExcelEnumIdsStr + ExcelEnumIdsStr);
        //    string fileName = "消费品牌企业服务信息" + ".xls";
        //    string filePath = Path.Combine(Directory.GetCurrentDirectory(), "upfile/temporary");
        //    if (System.IO.Directory.Exists(filePath) == false)//如果不存在就创建file文件夹
        //    {
        //        System.IO.Directory.CreateDirectory(filePath);
        //    }
        //    string tempPath = filePath + "\\" + hashKey + "\\";
        //    //如果不存在就创建file文件夹
        //    if (!System.IO.Directory.Exists(tempPath))
        //    {
        //        System.IO.Directory.CreateDirectory(tempPath);
        //    }
        //    string fileUrl = tempPath + fileName;
        //    string key = "Mall_SD_BRANDENTERPRISE_" + hashKey;
        //    string redisValue = redisHelper.StringGet(key);
        //    if (string.IsNullOrEmpty(redisValue))
        //    {
        //        redisValue = redisHelper.StringGet(key);
        //        if (string.IsNullOrEmpty(redisValue))
        //        {
        //            redisHelper.StringSet(key, fileName, TimeSpan.FromMinutes(10));
        //            Task.Run(() =>
        //            {
        //                GetBrandEnterpriseListToExcel(query, ExcelEnumIds, tempPath, fileUrl);
        //            });
        //        }
        //    }
        //    return await Task.Run<ApiResult>(() =>
        //    {
        //        ApiResult apiResult = new ApiResult()
        //        {
        //            resultCode = 0,
        //        };
        //        if (System.IO.File.Exists(fileUrl))
        //        {
        //            var filePath = "/upfile/temporary/" + hashKey + "/";
        //            var fileUrl = "/upfile/temporary/" + hashKey + "/" + fileName;
        //            apiResult.resultCode = 1;
        //            apiResult.data = new { filePath, fileUrl };
        //            apiResult.message = key;
        //        }
        //        return apiResult;
        //    });
        //}


        ///// <summary>
        /////【商载通】 生成品牌文件
        ///// </summary>
        ///// <param name="demodel">查询参数</param>
        ///// <param name="ExcelEnumIdList">需要导出的列</param>
        ///// <param name="filePath">Logon存放路劲</param>
        ///// <param name="excelFileUrl">Excel文件路径</param>
        //private async void GetBrandEnterpriseListToExcel(RB_Brand_Enterprise_Extend demodel, List<int> ExcelEnumIdList, string filePath, string excelFileUrl)
        //{
        //    byte[] bytes = null;
        //    List<ExcelDataSource> slist = new List<ExcelDataSource>();
        //    var Enumlist = EnumHelper.GetEnumList(typeof(Common.Enum.TradePavilion.BrandEnterpriseExportEnum));
        //    ExcelDataSource header = new ExcelDataSource()
        //    {
        //        ExcelRows = new List<ExcelColumn>(30)
        //        {
        //            new ExcelColumn(value: "序号") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER }
        //        }
        //    };
        //    foreach (var item in ExcelEnumIdList)
        //    {
        //        var Name = Enumlist.Where(x => x.Value == item.ToString()).FirstOrDefault().Key ?? "";
        //        header.ExcelRows.Add(new ExcelColumn(value: Name) { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER });
        //    }
        //    slist.Add(header);

        //    try
        //    {
        //        var list = buildingCarrierModule.GetBrandEnterpriseListModule(demodel);
        //        List<Action> actions = new List<Action>();
        //        if (list != null && list.Count > 0)
        //        {
        //            //判断是否下载图片
        //            if (ExcelEnumIdList.Contains(4))
        //            {
        //                foreach (var item in list)
        //                {
        //                    actions.Add(new Action(() =>
        //                    {
        //                        DownLoadUrl(item.Logo, filePath);
        //                    }));
        //                }
        //            }
        //        }

        //        if (actions != null && actions.Count > 0)
        //        {
        //            ParallelOptions options = new ParallelOptions { MaxDegreeOfParallelism = 4 };  // 设置最大并行度为 4
        //            Parallel.Invoke(options, actions.ToArray());
        //        }

        //        #region 组装数据
        //        int Num = 0;
        //        foreach (var item in list)
        //        {
        //            Num++;
        //            ExcelDataSource datarow = new ExcelDataSource()
        //            {
        //                ExcelRows = new List<ExcelColumn>(30) 
        //                {
        //                    new ExcelColumn(value:Num.ToString()){ },
        //                }
        //            };
        //            foreach (var qitem in ExcelEnumIdList)
        //            {
        //                switch (qitem)
        //                {
        //                    case 1:
        //                        datarow.ExcelRows.Add(new ExcelColumn(value: item.CategoryName) { }); break;
        //                    case 2:
        //                        datarow.ExcelRows.Add(new ExcelColumn(value: item.FullBrandName) { }); break;
        //                    case 3:
        //                        datarow.ExcelRows.Add(new ExcelColumn(value: item.BrandName) { }); break;
        //                    case 4:
        //                        datarow.ExcelRows.Add(new ExcelColumn(value: item.Logo, isPic: 1) { }); break;
        //                    case 5:
        //                        datarow.ExcelRows.Add(new ExcelColumn(value: item.VideoUrl) { }); break;
        //                    case 6:
        //                        datarow.ExcelRows.Add(new ExcelColumn(value: item.ShopNum.ToString()) { }); break;
        //                    case 7:
        //                        datarow.ExcelRows.Add(new ExcelColumn(value: (item.BuiltUpArea.ToString()) + "-" + (item.EndBuiltUpArea.ToString())) { }); break;
        //                    case 8:
        //                        datarow.ExcelRows.Add(new ExcelColumn(value: (item.AreaRequirement.ToString()) + "-" + (item.EndAreaRequirement.ToString())) { }); break;
        //                    case 9:
        //                        datarow.ExcelRows.Add(new ExcelColumn(value: item.CustomerType) { }); break;
        //                    case 10:
        //                        datarow.ExcelRows.Add(new ExcelColumn(value: item.BrandType) { }); break;
        //                    case 11:
        //                        datarow.ExcelRows.Add(new ExcelColumn(value: item.Introduce) { }); break;
        //                    case 12:
        //                        datarow.ExcelRows.Add(new ExcelColumn(value: item.DevIntention) { }); break;
        //                    case 13:
        //                        datarow.ExcelRows.Add(new ExcelColumn(value: item.PropertyDemand) { }); break;
        //                    case 14:
        //                        datarow.ExcelRows.Add(new ExcelColumn(value: item.Cooperation) { }); break;
        //                    case 15:
        //                        datarow.ExcelRows.Add(new ExcelColumn(value: item.Complementary) { }); break;
        //                }
        //            }
        //            slist.Add(datarow);
        //        }
        //        #endregion
        //        bytes = ExcelTempLateHelper.ToBrandExcelExtend(slist, filePath);
        //        using (FileStream fs = new FileStream(excelFileUrl, FileMode.CreateNew))
        //        {
        //            fs.Write(bytes, 0, bytes.Length);
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        bytes = ExcelTempLateHelper.ToBrandExcelExtend(slist, filePath);
        //        using (FileStream fs = new FileStream(excelFileUrl, FileMode.CreateNew))
        //        {
        //            fs.Write(bytes, 0, bytes.Length);
        //        }
        //        LogHelper.Write(ex, string.Format("GetBrandEnterpriseListToExcel_Request: {0}", JsonHelper.Serialize(demodel)));
        //    }
        //}
    }
}