﻿using VT.FW.DB;
using Mall.Common.Enum.Goods;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Product
{
    /// <summary>
    /// 商品订单表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Goods_Order
    {

        /// <summary>
        /// OrderId
        /// </summary>        
        public int OrderId
        {
            get;
            set;
        }
        /// <summary>
        /// 订单号
        /// </summary>        
        public string OrderNo
        {
            get;
            set;
        }
        /// <summary>
        /// 商户单号
        /// </summary>        
        public string MerchantsNo
        {
            get;
            set;
        }
        /// <summary>
        /// 用户id
        /// </summary>        
        public int? UserId
        {
            get;
            set;
        }
        /// <summary>
        /// 订单来源（平台）  枚举
        /// </summary>        
        public UserSourceEnum? OrderSource
        {
            get;
            set;
        }
        /// <summary>
        /// 支付方式   枚举
        /// </summary>        
        public OrderPaymentTypeEnum? PaymentWay
        {
            get;
            set;
        }
        /// <summary>
        /// 应收金额
        /// </summary>        
        public decimal? PreferPrice
        {
            get;
            set;
        }
        /// <summary>
        /// 实收金额
        /// </summary>        
        public decimal? Income
        {
            get;
            set;
        }
        /// <summary>
        /// 运费
        /// </summary>        
        public decimal? FreightMoney
        {
            get;
            set;
        }
        /// <summary>
        /// 配送方式
        /// </summary>        
        public OrderDeliveryMethodEnum? DeliveryMethod
        {
            get;
            set;
        }
        /// <summary>
        /// 手续费
        /// </summary>        
        public decimal? Fee
        {
            get;
            set;
        }
        /// <summary>
        /// 退款
        /// </summary>        
        public decimal? Refund
        {
            get;
            set;
        }
        /// <summary>
        /// 优惠金额
        /// </summary>        
        public decimal? CouponMoney
        {
            get;
            set;
        }
        /// <summary>
        /// 优惠卷ids
        /// </summary>        
        public string CouponsIds
        {
            get;
            set;
        }
        /// <summary>
        /// 收件人
        /// </summary>        
        public string Consignee
        {
            get;
            set;
        }
        /// <summary>
        /// 手机号码
        /// </summary>        
        public string Mobile
        {
            get;
            set;
        }
        /// <summary>
        /// 国家
        /// </summary>        
        public int? Country
        {
            get;
            set;
        }
        /// <summary>
        /// 省
        /// </summary>        
        public int? Province
        {
            get;
            set;
        }
        /// <summary>
        /// 市
        /// </summary>        
        public int? City
        {
            get;
            set;
        }
        /// <summary>
        /// 区
        /// </summary>        
        public int? District
        {
            get;
            set;
        }
        /// <summary>
        /// 收货地址
        /// </summary>        
        public string ShoppingAddress
        {
            get;
            set;
        }
        /// <summary>
        /// 买家留言
        /// </summary>        
        public string BuyerMessage
        {
            get;
            set;
        }
        /// <summary>
        /// 下单备注
        /// </summary>        
        public string Remark
        {
            get;
            set;
        }
        /// <summary>
        /// 订单状态  枚举
        /// </summary>        
        public OrderStatusEnum? OrderStatus
        {
            get;
            set;
        }
        /// <summary>
        /// 回收   1是  2否
        /// </summary>        
        public int? Recycled
        {
            get;
            set;
        }
        /// <summary>
        /// 删除状态
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }
        /// <summary>
        /// 支付时间
        /// </summary>
        public DateTime? PaymentTime { get; set; }
        /// <summary>
        /// 发货时间
        /// </summary>
        public DateTime? DeliveryTime { get; set; }
        /// <summary>
        /// 收货时间
        /// </summary>
        public DateTime? ReceivingTime { get; set; }
        /// <summary>
        /// 完成时间
        /// </summary>
        public DateTime? FinishTime { get; set; }
        /// <summary>
        /// 取消时间
        /// </summary>
        public DateTime? CancelTime { get; set; }
        /// <summary>
        /// 是否申请取消订单  1是  2否
        /// </summary>
        public int? IsApplyForCancel { get; set; }
        /// <summary>
        /// 历史订单状态
        /// </summary>
        public int? HistoryOrderStatus { get; set; }
        /// <summary>
        /// 申请取消订单备注
        /// </summary>
        public string CancelRemark { get; set; }
        /// <summary>
        /// 申请取消审核状态  1同意  2拒绝
        /// </summary>
        public int? ApplyForCancelStatus { get; set; }
        /// <summary>
        /// 拒绝取消订单得备注
        /// </summary>
        public string RejectRemark { get; set; }
        /// <summary>
        /// 退款单号
        /// </summary>
        public string RefundOrderNo { get; set; }
        /// <summary>
        /// 主播名称（多个以逗号分隔）
        /// </summary>
        public string AnchorName { get; set; }

        /// <summary>
        /// 微店id
        /// </summary>
        public int? SmallShopsId { get; set; }
        /// <summary>
        /// 订单分类  0正常订单  1司导订单  2教育订单 3-线下服务订单
        /// </summary>
        public int OrderClassify { get; set; }
        /// <summary>
        /// 目的地（司导订单）
        /// </summary>
        public string DestinationAddress { get; set; }
        /// <summary>
        /// 课程卡抵扣金额
        /// </summary>
        public decimal? EducationMoney { get; set; }

        /// <summary>
        /// 门店编号
        /// </summary>
        public int StoresId { get; set; }

        /// <summary>
        /// 购买抵扣佣金金额
        /// </summary>
        public decimal? DeductionCommission { get; set; }
    }
}
