﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Extend.User;
using Mall.Repository;
using VT.FW.DB;

namespace Mall.Module.User
{
    /// <summary>
    /// 商户表处理层
    /// </summary>
    public class TenantModule
    {
        /// <summary>
        /// 商户仓储层对象
        /// </summary>
        private readonly Mall.Repository.User.RB_TenantRepository tenantRepository = new Repository.User.RB_TenantRepository();


        /// <summary>
        /// 根据查询条件获取商户列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Tenant_Extend> GetTenantListModule(RB_Tenant_Extend query)
        {
            return tenantRepository.GetListRepository(query);
        }

        /// <summary>
        /// 根据小程序获取商户信息
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public RB_Tenant_Extend GetTenantByMallModule(RB_Tenant_Extend query)
        {
            return tenantRepository.GetTenantByMallRepository(query);
        }

        /// <summary>
        /// 获取商户分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Tenant_Extend> GetTenantPageListModule(int pageIndex, int pageSize, out long rowCount, RB_Tenant_Extend query)
        {
            return tenantRepository.GetPageListRepository(pageIndex, pageSize, out rowCount, query);
        }

   
        /// <summary>
        /// 判断用户是否存在
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool CheckTenantModule(RB_Tenant_Extend extModel)
        {
            List<WhereHelper> wheres = new List<WhereHelper>()
            {
                new WhereHelper(nameof(RB_Tenant_Extend.Account),extModel.Account.Trim())
            };
            return tenantRepository.Exists(wheres);
        }

        /// <summary>
        /// 用户注册第一步
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetTenantFirstModule(RB_Tenant_Extend extModel)
        {
            extModel.Account = extModel.Account.Trim();
            extModel.Password= Common.DES.Encrypt(extModel.Password, Common.Config.WebApiKey, Common.Config.WebApiIV);
            int NewId = tenantRepository.Insert(extModel);
            extModel.TenantId = NewId;
            bool flag = NewId > 0;
            return flag;
        }

        /// <summary>
        /// 新增修改商户信息
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetTenantSecondModule(RB_Tenant_Extend extModel)
        {
            bool flag = false;
            if (extModel.TenantId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_Tenant_Extend.Name),extModel.Name.Trim()},
                    { nameof(RB_Tenant_Extend.MobilePhone),extModel.MobilePhone.Trim()},
                    { nameof(RB_Tenant_Extend.WeChatNum),extModel.WeChatNum.Trim()},
                    { nameof(RB_Tenant_Extend.ApplyReason),extModel.ApplyReason},
                    { nameof(RB_Tenant_Extend.IDCardPositiveImg),extModel.IDCardPositiveImg},
                    { nameof(RB_Tenant_Extend.IDCardReverseImg),extModel.IDCardReverseImg},
                    { nameof(RB_Tenant_Extend.BusinessLicenseImg),extModel.BusinessLicenseImg},
                    { nameof(RB_Tenant_Extend.AccountStatus),extModel.AccountStatus},
                };
                flag = tenantRepository.Update(fileds, new WhereHelper(nameof(RB_Tenant_Extend.TenantId), extModel.TenantId));
            }
            return flag;
        }

        /// <summary>
        /// 检查手机号码是否存在
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool CheckMobilePhoneModule(RB_Tenant_Extend extModel)
        {
            List<WhereHelper> wheres = new List<WhereHelper>()
            {
                new WhereHelper(nameof(RB_Tenant_Extend.MobilePhone),extModel.MobilePhone.Trim())
            };
            return tenantRepository.Exists(wheres);
        }

        /// <summary>
        /// 修改密码
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool UpdateTenantPwdModule(RB_Tenant_Extend extModel)
        {
            extModel.Password = Common.DES.Encrypt(extModel.Password, Common.Config.WebApiKey, Common.Config.WebApiIV);
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                { nameof(RB_Tenant_Extend.Password),extModel.Password},
            };
            bool flag = tenantRepository.Update(fileds, new WhereHelper(nameof(RB_Tenant_Extend.MobilePhone), extModel.MobilePhone.Trim()));
            return flag;
        }

        /// <summary>
        /// 根据编号获取商户信息
        /// </summary>
        /// <param name="TenantId">商户号</param>
        /// <returns></returns>
        public RB_Tenant_Extend GetTenantModule(object TenantId)
        {
            RB_Tenant_Extend extModel = tenantRepository.GetEntity<RB_Tenant_Extend>(TenantId);
            if (extModel == null)
            {
                extModel = new RB_Tenant_Extend();
            }
            return extModel;
        }

        /// <summary>
        /// 更新账户张婷
        /// </summary>
        /// <param name="TenantId">商户号</param>
        /// <param name="AccountStatus">账户状态</param>
        /// <returns></returns>
        public bool SetTenantStatusModule(object TenantId, int AccountStatus)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                { nameof(RB_Tenant_Extend.AccountStatus),AccountStatus},
            };
            bool flag = tenantRepository.Update(fileds, new WhereHelper(nameof(RB_Tenant_Extend.TenantId), TenantId));
            return flag;
        }
    }
}
