﻿using VT.FW.DB;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 商户分销商等级表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Distributor_Grade
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 等级
        /// </summary>        
        public int? Grade
        {
            get;
            set;
        }
        /// <summary>
        /// 等级名称
        /// </summary>        
        public string Name
        {
            get;
            set;
        }
        /// <summary>
        /// 是否自动升级  1是  2否
        /// </summary>        
        public int? IsAutoUpGrade
        {
            get;
            set;
        }
        /// <summary>
        /// 升级条件  枚举
        /// </summary>        
        public DistrbutorGradeUpdateEnum? UpGradeCondition
        {
            get;
            set;
        }
        /// <summary>
        /// 下线数量
        /// </summary>        
        public int? ReferralsNumber
        {
            get;
            set;
        }
        /// <summary>
        /// 累计佣金
        /// </summary>        
        public decimal? TotalCommission
        {
            get;
            set;
        }
        /// <summary>
        /// 已提现佣金
        /// </summary>        
        public decimal? CommissionWithdrawn
        {
            get;
            set;
        }
        /// <summary>
        /// 分销佣金类型 1百分比  2固定金额
        /// </summary>        
        public int? DistributionCommissionType
        {
            get;
            set;
        }
        /// <summary>
        /// 一级佣金
        /// </summary>        
        public decimal? OneCommission
        {
            get;
            set;
        }
        /// <summary>
        /// 二级佣金
        /// </summary>        
        public decimal? TwoCommission
        {
            get;
            set;
        }
        /// <summary>
        /// 三级级佣金
        /// </summary>        
        public decimal? ThreeCommission
        {
            get;
            set;
        }
        /// <summary>
        /// 是否启用  1是  2否
        /// </summary>        
        public int? Enabled
        {
            get;
            set;
        }
        /// <summary>
        /// 等级说明
        /// </summary>        
        public string GradeExplain
        {
            get;
            set;
        }
        /// <summary>
        /// 删除状态
        /// </summary>
        public int? Status { get; set; }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }
    }
}
