﻿using Mall.Common.Enum;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Entity.TradePavilion
{
    /// <summary>
    /// 商会活动表实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Commerce_Activity
    {
		/// <summary>
		/// 活动编号(主键)
		/// </summary>
		public int Id { get; set; }

		/// <summary>
		/// 活动名称
		/// </summary>
		public string ActivityName { get; set; }

		/// <summary>
		/// 开始时间
		/// </summary>
		public DateTime StartTime { get; set; }

		/// <summary>
		/// 结束时间
		/// </summary>
		public DateTime EndTime { get; set; }

		/// <summary>
		/// 封面图
		/// </summary>
		public string CoverImg { get; set; }

		/// <summary>
		/// 活动类型(rb_commerce_activitytype表Id)
		/// </summary>
		public int? ActivityType { get; set; }

		/// <summary>
		/// 活动详情
		/// </summary>
		public string ActivityInfo { get; set; }

		/// <summary>
		/// 商户号id
		/// </summary>
		public int TenantId { get; set; }

		/// <summary>
		/// 小程序id
		/// </summary>
		public int MallBaseId { get; set; }

		/// <summary>
		/// 创建人
		/// </summary>
		public int CreateBy { get; set; }

		/// <summary>
		/// 创建时间
		/// </summary>
		public DateTime CreateDate { get; set; }

		/// <summary>
		/// 修改人
		/// </summary>
		public int UpdateBy { get; set; }

		/// <summary>
		/// 修改时间
		/// </summary>
		public DateTime UpdateDate { get; set; }

		/// <summary>
		/// 删除状态
		/// </summary>
		public DateStateEnum Status { get; set; }
	}
}
