﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Miai;

namespace Mall.Model.Extend.Miai
{
    /// <summary>
    /// 活动评论表扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Miai_ActivityDiscuss_Extend : RB_Miai_ActivityDiscuss
    {
        /// <summary>
        /// 活动ids
        /// </summary>
        public string ActivityIds { get; set; }

        /// <summary>
        /// 用户名称
        /// </summary>
        public string UserName { get; set; }

        /// <summary>
        /// 用户头像
        /// </summary>
        public string Photo { get; set; }

        /// <summary>
        /// 回复某人
        /// </summary>
        public string ReplyUserName { get; set; }

        /// <summary>
        /// 回复列表
        /// </summary>
        public List<RB_Miai_ActivityDiscuss_Extend> ReplyList { get; set; }

        /// <summary>
        /// 回复数量
        /// </summary>
        public int ReplyNum { get; set; }

        /// <summary>
        /// 图片列表
        /// </summary>
        public List<string> ImageList { get; set; }
    }
}
