﻿using Mall.Common.Enum;
using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Mall.Repository.TradePavilion
{
    /// <summary>
    /// 韩国馆新闻仓储层
    /// </summary>
    public class RB_Commerce_NewsRepository : BaseRepository<RB_Commerce_News>
    {
        /// <summary>
        /// 获取新闻分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Commerce_News_Extend> GetCommerceNewsPageListRepository(int pageIndex, int pageSize, out long rowsCount, RB_Commerce_News_Extend query)
        {
            rowsCount = 0;
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.*
FROM rb_commerce_news AS A
WHERE 1=1
");
            builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Commerce_News_Extend.Status), (int)DateStateEnum.Normal);
            if (query == null)
            {
                return new List<RB_Commerce_News_Extend>();
            }
            else
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Commerce_News_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Commerce_News_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.Title))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @Name ", nameof(RB_Commerce_News_Extend.Title));
                    parameters.Add("Name", "%" + query.Title.Trim() + "%");
                }
            }
            return GetPage<RB_Commerce_Activity_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }
    }
}
