﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Mall.Common.Plugin;
using Mall.CacheManager.User;
using Newtonsoft.Json.Linq;
using Mall.Common;
using Mall.AOP;
using Mall.Module.Miai;
using Mall.Model.Extend.Miai;

namespace Mall.WebApi.Controllers.MallBase
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class MiaiController : BaseController
    {

        private readonly MiaiModule miaiModule = new MiaiModule();

        #region 活动版块
        /// <summary>
        /// 获取活动版块分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetForumPageList() {
            var req = base.RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(req.msg.ToString());
            RB_Miai_Forum_Extend demodel = JsonConvert.DeserializeObject<RB_Miai_Forum_Extend>(req.msg.ToString());

            demodel.TenantId = Convert.ToInt32(req.uid);
            demodel.MallBaseId = req.MallBaseId;
            var list = miaiModule.GetForumPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.Id,
                x.Name,
                x.Icon,
                x.Sort,
                x.IsShow,
                CreateDate = x.CreateDate.ToString("yyyy-MM-dd HH:mm:ss")
            });
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 设置版块
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetForumInfo() {
            var req = base.RequestParm;
            RB_Miai_Forum_Extend demodel = JsonConvert.DeserializeObject<RB_Miai_Forum_Extend>(req.msg.ToString());
            if (string.IsNullOrEmpty(demodel.Name))
            {
                return ApiResult.ParamIsNull("请输入版块名称");
            }
            if (string.IsNullOrEmpty(demodel.Icon)) {
                return ApiResult.ParamIsNull("请选择版块图标");
            }

            demodel.TenantId = Convert.ToInt32(req.uid);
            demodel.MallBaseId = req.MallBaseId;
            demodel.IsShow = demodel.IsShow == 0 ? 1 : demodel.IsShow;
            demodel.Status = 0;
            demodel.CreateDate = DateTime.Now;
            demodel.UpdateDate = DateTime.Now;
            bool flag = miaiModule.SetForumInfo(demodel);
            if (flag)
            {
                return ApiResult.Success();
            }
            else {
                return ApiResult.Failed();
            }
        }

        /// <summary>
        /// 设置版块状态
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetForumState() {
            var req = base.RequestParm;
            var parms = JObject.Parse(req.msg.ToString());
            int ForumId = parms.GetInt("ForumId", 0);
            int Type = parms.GetInt("Type", 1);// 类型  1显示/不显示   2删除

            bool flag = miaiModule.SetForumState(ForumId, Type);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }
        #endregion

       


    }
}