﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Miai;
using Mall.Model.Extend.Miai;
using System.Linq;

namespace Mall.Repository.Miai
{
    /// <summary>
    /// 活动仓储层
    /// </summary>
    public class RB_Miai_ActivityRepository : BaseRepository<RB_Miai_Activity>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Miai_Activity_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Miai_Activity_Extend dmodel)
        {
            string where = $" 1=1 and a.{nameof(RB_Miai_Activity_Extend.Status)}=0 ";
            if (dmodel.TenantId > 0) {
                where += $@" and a.{nameof(RB_Miai_Activity_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and a.{nameof(RB_Miai_Activity_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (!string.IsNullOrEmpty(dmodel.ActivityTitle)) {
                where += $@" and a.{nameof(RB_Miai_Activity_Extend.ActivityTitle)} like '%{dmodel.ActivityTitle}%'";
            }
            if (dmodel.ForumId > 0) {
                where += $@" and a.{nameof(RB_Miai_Activity_Extend.ForumId)} ={dmodel.ForumId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and a.{nameof(RB_Miai_Activity_Extend.UserId)} ={dmodel.UserId}";
            }
            string sql = $@"select a.*,u.Name as UserName,u.Photo from RB_Miai_Activity a
left join rb_member_user u on a.UserId =u.Id
where {where} order by a.Id desc";
            return GetPage<RB_Miai_Activity_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Miai_Activity_Extend> GetList(RB_Miai_Activity_Extend dmodel)
        {
            string where = $" 1=1 and {nameof(RB_Miai_Activity_Extend.Status)}=0 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Miai_Activity_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Miai_Activity_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (!string.IsNullOrEmpty(dmodel.ActivityTitle))
            {
                where += $@" and {nameof(RB_Miai_Activity_Extend.ActivityTitle)} like '%{dmodel.ActivityTitle}%'";
            }
            if (dmodel.ForumId > 0)
            {
                where += $@" and {nameof(RB_Miai_Activity_Extend.ForumId)} ={dmodel.ForumId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and {nameof(RB_Miai_Activity_Extend.UserId)} ={dmodel.UserId}";
            }
            string sql = $@"select * from RB_Miai_Activity where {where} order by Id desc";
            return Get<RB_Miai_Activity_Extend>(sql).ToList();
        }
    }
}
