﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using Mall.Common;
using Mall.Common.API;
using Mall.Common.Plugin;
using Mall.Model.Extend.Finance;
using Mall.Repository.Product;
using Newtonsoft.Json;

namespace Mall.Module.Product
{
    /// <summary>
    /// 财务处理层
    /// </summary>
    public class FinanceModule
    {
        /// <summary>
        /// 财务配置
        /// </summary>
        private readonly RB_Finance_ConfigurineRepository finance_ConfigurineRepository = new RB_Finance_ConfigurineRepository();
        private readonly Rb_Workflow_TemplateRepository workflow_TemplateRepository = new Rb_Workflow_TemplateRepository();



        /// <summary>
        /// 获取财务配置
        /// </summary>
        /// <param name="type"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public object GetFinanceConfigurationInfo(int type, int tenantId, int mallBaseId)
        {
            var fmodel = finance_ConfigurineRepository.GetList(new RB_Finance_Configurine_Extend() { Type = type, TenantId = tenantId, MallBaseId = mallBaseId }).FirstOrDefault();
            if (fmodel == null)
            {
                return new
                {
                    Status = 1,
                    Msg = "需新增"
                };
            }
            else {
                return new
                {
                    Status = 2,
                    FModel = new
                    {
                        fmodel.Id,
                        fmodel.IsPublic,
                        fmodel.AccountType,
                        fmodel.AccountId,
                        fmodel.RemitterName,
                        fmodel.CurrencyId,
                        fmodel.IncomeCostTypeId,
                        fmodel.FreightCostTypeId,
                        fmodel.RefundCostTypeId,
                        fmodel.CBCostTypeId,
                        fmodel.RemitCostTypeId,
                        fmodel.WorkFlowId,
                        fmodel.Type,
                        StartTime = fmodel.StartTime.HasValue?fmodel.StartTime.Value.ToString("yyyy-MM-dd HH:mm:ss"):"",
                        fmodel.IntervalDay,
                        fmodel.BranchId
                    }
                };
            }
        }

        /// <summary>
        /// 获取流程列表
        /// </summary>
        /// <returns></returns>
        public object GetFinanceWorkFlowTemplateList(int TempLateClass)
        {
            var list = workflow_TemplateRepository.GetList(new Rb_Workflow_Template_Extend() { RB_GroupId = 2, Status = 1, TempLateClass = (Common.Enum.Finance.WFTempLateClassEnum)TempLateClass, TemplateSorce = 1 });
            return list.Select(x => new
            {
                x.Id,
                x.Name
            });
        }
    }
}
